var gExceptions;

var gExceptionsList;
var gURIBox;
var gAddButton;
var gRemoveButton;
var gRemoveAllButton;

function init()
{
	gExceptions      = TabbrowserService.JSWindowOpenExceptions;

	gExceptionsList  = document.getElementById('exceptions');
	gURIBox          = document.getElementById('URIBox');
	gAddButton       = document.getElementById('addButton');
	gRemoveButton    = document.getElementById('removeButton');
	gRemoveAllButton = document.getElementById('removeAllButton');

	document.documentElement.addEventListener('keypress', onReturnHit, true);

	window.sizeToContent();
	window.setTimeout('initWithDelay();', 0);
}
function initWithDelay()
{
	if ('arguments' in window &&
		window.arguments[0])
		gURIBox.value = window.arguments[0];

	initList();
}


function initList()
{
	while (gExceptionsList.hasChildNodes())
		gExceptionsList.removeChild(gExceptionsList.lastChild);

	var item;
	var node;
	for (var i = 0; i < gExceptions.length; i++)
	{
		node = gExceptions.item(i);

		item = document.createElement('listitem');
		item.setAttribute('label', gExceptions.getData(node, 'Rule'));
		gExceptionsList.appendChild(item);
	}

	gRemoveButton.disabled = true;
	gRemoveAllButton.disabled = !gExceptionsList.hasChildNodes();
}


function addURI()
{
	var uri = gURIBox.value;
	if (!uri) return;

	gExceptions.setData(uri, 'Rule', uri);
	gURIBox.value = '';
	initList();
}

function removeURI()
{
	if (!gExceptionsList.selectedItem) return;

	var uri = gExceptionsList.selectedItem.getAttribute('label');

	gExceptions.removeData(uri);
	initList();
}

function removeAllURIs()
{
	gExceptions.clearData();
	initList();
}




function onSelect()
{
	gRemoveButton.disabled = !gExceptionsList.selectedItem;
}

function onReturnHit(aEvent)
{
	var focusedElement = document.commandDispatcher.focusedElement;

	if (!focusedElement ||
		(aEvent.keyCode != aEvent.DOM_VK_ENTER &&
		aEvent.keyCode != aEvent.DOM_VK_RETURN)) return;

	aEvent.preventBubble();
	if (focusedElement == gURIBox.inputField)
		gAddButton.doCommand();
}
