/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Tabbrowser Extensions.
 *
 * The Initial Developer of the Original Code is SHIMODA Hiroshi.
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): SHIMODA Hiroshi <piro@p.club.ne.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 
function controlLinkedItems(elem, aShouldEnable, aAttr)
{
	var target = elem.getAttribute(aAttr || 'linked').split(/ +/);
	var item;

	var disabled = (aShouldEnable !== void(0)) ? !aShouldEnable :
				(elem.localName == 'textbox' ? (!elem.value || !Number(elem.value)) : !elem.checked );

	for (var i in target)
	{
		item = document.getElementById(target[i]);
		if (item) item.disabled = disabled;
	}
}

function spinButtonsUpDown(aEvent, aTargetID, aMin, aMax)
{
	var eventNode = aEvent.target;
	while (eventNode.localName != 'spinbuttons')
		eventNode = eventNode.parentNode;

	var buttonNode = aEvent.originalTarget;
	while (buttonNode.localName != 'image')
		buttonNode = buttonNode.buttonNode;

	if (eventNode.getAttribute('disabled') == 'true' ||
		eventNode.disabled) return;


	var node = document.getElementById(aTargetID);
	var val = Number(node.value);
	if (isNaN(val)) val = 0;

	if (buttonNode.getAttribute('class') == 'up')
		val++;
	else if (buttonNode.getAttribute('class') == 'down')
		val--;

	if (
		(aMin !== void(0) && val < aMin) ||
		(aMax !== void(0) && val > aMax)
		)
		return;

	node.value = val;
}


function isModified(aKey, aPageURI)
{
	if (!aPageURI) aPageURI = location.href;

	var pageData = parent.hPrefWindow.wsm.dataManager.pageData;
	if (aPageURI in pageData) {
		var data = pageData[aPageURI];
		return (data && 'modifiedData' in data && aKey in data.modifiedData && data.modifiedData[aKey].value);
	}
	return false;
}

function onModified(aKey, aNewValue)
{
	var pageData = parent.hPrefWindow.wsm.dataManager.pageData;
	if (!(location.href in pageData))
		pageData[location.href] = [];

	var data = pageData[location.href];
//	if (!('modifiedData' in data))
//		data.modifiedData = [];
	if (!('valueData' in data))
		data.valueData = [];

//	if (aKey in data.modifiedData)
//		data.modifiedData[aKey].value = !data.modifiedData[aKey].value;
//	else
//		data.modifiedData[aKey] = { value : true };

	data.valueData[aKey] = { value : aNewValue };
}

function getModifiedValue(aKey, aPageURI)
{
	if (!aPageURI) aPageURI = location.href;

	var pageData = parent.hPrefWindow.wsm.dataManager.pageData;
	if (aPageURI in pageData) {
		var data = pageData[aPageURI];
		if (data && 'valueData' in data && aKey in data.valueData)
			return data.valueData[aKey].value;
	}

	return TabbrowserService.getPref(aKey);
}



function initMacLabel()
{
	if (navigator.platform.match(/Mac/)) {
		var macLabels = document.getElementsByAttribute('maclabel-for', '*');
		var node;

		for (var i = 0; i < macLabels.length; i++)
		{
			node = document.getElementById(macLabels[i].getAttribute('maclabel-for'));
			if (!node) continue;
			node.setAttribute('label', macLabels[i].getAttribute('value'));
			node.setAttribute('flex', 1);
		}
	}
}

function initExpert() 
{
	if (window.top.location.href != 'chrome://communicator/content/pref/pref.xul' &&
		window.top.location.href != 'chrome://browser/content/pref/pref.xul' &&
		window.top.location.href != 'chrome://tabextensions/content/pref/prefDialog.xul')
		return;

	var panel = window.top.location.href.match(/^chrome:\/\/browser\//) ? 'chrome://browser/content/pref/pref-tabs.xul' :
			window.top.location.href.match(/^chrome:\/\/tabextensions\//) ? 'chrome://tabextensions/content/pref/pref-tabs.xul' :
			'chrome://communicator/content/pref/pref-tabs.xul' ;
	var expert = getModifiedValue('browser.tabs.extensions.expert_prefs', panel);
//	dump(panel+' : '+expert+'\n');

	if (expert)
		document.documentElement.setAttribute('expert', true);
	else
		document.documentElement.removeAttribute('expert');
}
initExpert();
