/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Tabbrowser Extensions.
 *
 * The Initial Developer of the Original Code is SHIMODA Hiroshi.
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): SHIMODA Hiroshi <piro@p.club.ne.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 
// start of definition 
if (!window.TabbrowserService) {
 
// ^uuEŮg@\ 
// extensions for the tabbrowser widget

/*
	<global "undo close tab" cache for multiple windows>
	this reference shares the global cache with other windows.
*/
var gTSGlobalUndoRemoveTabCache;
var gTSObserveClipboardLastURI;

// static class "TabbrowserService"
var TabbrowserService =
{
	debug : true,

	initialized               : false,
	destructed                : false,
	onQuit                    : false,
	tabHistoryQuitInitialized : false,
	tabsBackupInitialized     : false,
	startWithOpenURLRequest   : false,

	openerType   : null,
	openTabTimer : null,

	referrerBlockers : [
		'http://ime.nu/'
	],

	lastSent_bookmarks_command : 0,
	lastSent_bookmarks_click   : 0,
	lastSent_history_command   : 0,
	lastSent_history_click     : 0,
	
	// 萔 
	XULNS : 'http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul',
	XHTMLNS : 'http://www.w3.org/1999/xhtml',
	XLinkNS : 'http://www.w3.org/1999/xlink',
	knsIRDFResource    : Components.interfaces.nsIRDFResource,
	knsIRDFLiteral     : Components.interfaces.nsIRDFLiteral,
	knsISupportsString : ('nsISupportsWString' in Components.interfaces) ? Components.interfaces.nsISupportsWString : Components.interfaces.nsISupportsString,
	
	get kNC_URL() 
	{
		if (!this._kNC_URL)
			this._kNC_URL = this.RDF.GetResource('http://home.netscape.com/NC-rdf#URL');
		return this._kNC_URL;
	},
	_kNC_URL : null,
 
	get kNC_NAME() 
	{
		if (!this._kNC_NAME)
			this._kNC_NAME = this.RDF.GetResource('http://home.netscape.com/NC-rdf#Name');
		return this._kNC_NAME;
	},
	_kNC_NAME : null,
 
	get kNC_WebPanel() 
	{
		if (!this._kNC_WebPanel)
			this._kNC_WebPanel = this.RDF.GetResource('http://home.netscape.com/NC-rdf#WebPanel');
		return this._kNC_WebPanel;
	},
	_kNC_WebPanel : null,
 
	get kRDF_HistoryEntry() 
	{
		if (!this._kRDF_HistoryEntry)
			this._kRDF_HistoryEntry = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#HistoryEntry');
		return this._kRDF_HistoryEntry;
	},
	_kRDF_HistoryEntry : null,
	
	get kRDF_ID() 
	{
		if (!this._kRDF_ID)
			this._kRDF_ID = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#ID');
		return this._kRDF_ID;
	},
	_kRDF_ID : null,
 
	get kRDF_URI() 
	{
		if (!this._kRDF_URI)
			this._kRDF_URI = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#URI');
		return this._kRDF_URI;
	},
	_kRDF_URI : null,
 
	get kRDF_title() 
	{
		if (!this._kRDF_title)
			this._kRDF_title = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#title');
		return this._kRDF_title;
	},
	_kRDF_title : null,
 
	get kRDF_isSubFrame() 
	{
		if (!this._kRDF_isSubFrame)
			this._kRDF_isSubFrame = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#isSubFrame');
		return this._kRDF_isSubFrame;
	},
	_kRDF_isSubFrame : null,
 
	get kRDF_saveLayoutState() 
	{
		if (!this._kRDF_saveLayoutState)
			this._kRDF_saveLayoutState = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#saveLayoutState');
		return this._kRDF_saveLayoutState;
	},
	_kRDF_saveLayoutState : null,
 
	get kRDF_loadType() 
	{
		if (!this._kRDF_loadType)
			this._kRDF_loadType = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#loadType');
		return this._kRDF_loadType;
	},
	_kRDF_loadType : null,
 
	get kRDF_expirationStatus() 
	{
		if (!this._kRDF_expirationStatus)
			this._kRDF_expirationStatus = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#expirationStatus');
		return this._kRDF_expirationStatus;
	},
	_kRDF_expirationStatus : null,
 
	get kRDF_cacheKey() 
	{
		if (!this._kRDF_cacheKey)
			this._kRDF_cacheKey = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#cacheKey');
		return this._kRDF_cacheKey;
	},
	_kRDF_cacheKey : null,
 
	get kRDF_postContentType() 
	{
		if (!this._kRDF_postContentType)
			this._kRDF_postContentType = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#postContentType');
		return this._kRDF_postContentType;
	},
	_kRDF_postContentType : null,
 
	get kRDF_postContent() 
	{
		if (!this._kRDF_postContent)
			this._kRDF_postContent = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#postContent');
		return this._kRDF_postContent;
	},
	_kRDF_postContent : null,
 
	get kRDF_x() 
	{
		if (!this._kRDF_x)
			this._kRDF_x = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#x');
		return this._kRDF_x;
	},
	_kRDF_x : null,
 
	get kRDF_y() 
	{
		if (!this._kRDF_y)
			this._kRDF_y = this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#y');
		return this._kRDF_y;
	},
	_kRDF_y : null,
   
	// vpeB 
	// properties
	
	get isNewTypeBrowser() 
	{
		return this.browserURI.match(/^chrome:\/\/browser\//) ? true : false ;
	},
 
	get isBrowserWindow() 
	{
		return (window.top.document.documentElement.getAttribute('windowtype') == 'navigator:browser');
	},
 
	get browserURI() 
	{
		var handler = Components.classes['@mozilla.org/commandlinehandler/general-startup;1?type=browser'].getService(Components.interfaces.nsICmdLineHandler);
		return handler.chromeUrlForTask;
	},
 
	get browser() 
	{
		if (this._browser === void(0)) {
			this._browser = document.getElementById('content');
			if (this._browser && this._browser.localName != 'tabbrowser')
				this._browser = null;
		}
		var b = this.browsers;
		return this._browser ? this._browser : b.length ? b[0] : null ;
	},
//	_browser : null,
 
	get browsers() 
	{
		return document.getElementsByTagNameNS(this.XULNS, 'tabbrowser');
	},
 
	get browserWindow() 
	{
		return this.WindowManager.getMostRecentWindow('navigator:browser');
	},
 
	get browserWindows() 
	{
		var browserWindows = [];

		var targets = this.WindowManager.getEnumerator('navigator:browser', true),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			browserWindows.push(target);
		}

//		return browserWindows;

		// reorder with z-order
		var ordered = this.browserWindowsWithZOrder;
		var results = [];
		var i, j;
		for (i in ordered)
			for (j in browserWindows)
				if (ordered[i] == browserWindows[j]) {
					results.push(browserWindows[j]);
					browserWindows.splice(j, 1);
					break;
				}

		return results.concat(browserWindows); // result + rest windows (have not shown yet)
	},
	
	get browserWindowsWithZOrder() 
	{
		var browserWindows = [];

		var targets = this.WindowManager.getZOrderDOMWindowEnumerator('navigator:browser', true),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			browserWindows.push(target);
		}

		return browserWindows;
	},
  
	get BookmarksDS() 
	{
		if (!this._BookmarksDS) {
			this._BookmarksDS = this.RDF.GetDataSource('rdf:bookmarks');
			try {
				this._BookmarksDS = this._BookmarksDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
				this._BookmarksDS = this._BookmarksDS.QueryInterface(Components.interfaces.nsIBookmarksService);
			}
			catch(e) {
				alert(e);
			}
		}
		return this._BookmarksDS;
	},
	_BookmarksDS : null,
 
	get BookmarksDatabase() 
	{
		if (!this._BookmarksDatabase) {
			this._BookmarksDatabase = Components.classes['@mozilla.org/rdf/datasource;1?name=composite-datasource'].createInstance(Components.interfaces.nsIRDFCompositeDataSource);

			this._BookmarksDatabase.AddDataSource(this.BookmarksDS);
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:files'));
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:localsearch'));
			this._BookmarksDatabase.AddDataSource(this.RDF.GetDataSource('rdf:internetsearch'));
		}
		return this._BookmarksDatabase;
	},
	_BookmarksDatabase : null,
 
	get datasource() 
	{
		if (!this._datasource) {
			// get ProfileDirectory
			const DIR = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
			var dir = DIR.get('ProfD', Components.interfaces.nsILocalFile);


			// get URI
			var tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
			tempLocalFile.initWithPath(dir.path);

			var uri;
			try {
				uri = this.IOService.newFileURI(tempLocalFile).spec;
			}
			catch(e) { // [[interchangeability for Mozilla 1.1]]
				uri = this.IOService.getURLSpecFromFile(tempLocalFile);
			}

			if (!uri.match(/\/$/)) uri += '/';
			uri += 'tabextensions.rdf';


			// if the file doesn't exist, create it.
			try {
				var fileHandler = this.IOService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
				tempLocalFile = fileHandler.getFileFromURLSpec(uri);
			}
			catch(e) { // [[interchangeability for Mozilla 1.1]]
				try {
					tempLocalFile = this.IOService.getFileFromURLSpec(uri);
				}
				catch(ex) { // [[interchangeability for Mozilla 1.0.x]]
					tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
					this.IOService.initFileFromURLSpec(tempLocalFile, uri);
				}
			}

			if (!tempLocalFile.exists()) {
				var newURI = Components.classes['@mozilla.org/network/standard-url;1'].createInstance(Components.interfaces.nsIURI);
				newURI.spec = 'chrome://tabextensions/content/tabextensions.rdf';

				var PERSIST = Components.classes['@mozilla.org/embedding/browser/nsWebBrowserPersist;1'].createInstance(Components.interfaces.nsIWebBrowserPersist);
				if (PERSIST.saveURI.arity == 3) // old implementation
					PERSIST.saveURI(newURI, null, tempLocalFile);
				else
					PERSIST.saveURI(newURI, null, null, null, null, tempLocalFile);
			}


			// create datasource object
			this._datasource = this.RDF.GetDataSource(uri);
		}
		return this._datasource;
	},
	_datasource : null,
	
	get bookmarksData() 
	{
		if (!this._bookmarksData)
			this._bookmarksData = new pRDFData('Bookmarks', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', '%itemID%');
		return this._bookmarksData;
	},
	_bookmarksData : null,
 
	get iconData() 
	{
		if (!this._iconData)
			this._iconData = new pRDFData('RelatedIcons', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');
		return this._iconData;
	},
	_iconData : null,
 
	get JSWindowOpenExceptions() 
	{
		if (!this._JSWindowOpenExceptions)
			this._JSWindowOpenExceptions = new pRDFData('JSWindowOpenExceptions', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');
		return this._JSWindowOpenExceptions;
	},
	_JSWindowOpenExceptions : null,
 
	get tabHistory() 
	{
		if (!this._tabHistory)
			this._tabHistory = new pRDFData('TabsHistory', this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#');
		return this._tabHistory;
	},
	_tabHistory : null,
 
	get tabHistoryQuitRoot() 
	{
		if (!this._tabHistoryQuitRoot)
			this._tabHistoryQuitRoot = new pRDFData('TabsHistoryQuit', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
		return this._tabHistoryQuitRoot;
	},
	_tabHistoryQuitRoot : null,
	
	get tabHistoryQuit() 
	{
		if (!this._tabHistoryQuit)
			this._tabHistoryQuit = new pRDFData('TabsHistoryQuit:window-'+Math.floor(Math.random() * 100000), this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
		return this._tabHistoryQuit;
	},
	set tabHistoryQuit(aValue)
	{
		this._tabHistoryQuit = aValue;
	},
	_tabHistoryQuit : null,
  
	get tabsBackupRoot() 
	{
		if (!this._tabsBackupRoot)
			this._tabsBackupRoot = new pRDFData('TabsBackup', this.datasource.URI, 'bag', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
		return this._tabsBackupRoot;
	},
	_tabsBackupRoot : null,
	
	get tabsBackup() 
	{
		if (!this._tabsBackup)
			this._tabsBackup = new pRDFData('TabsBackup:window-'+Math.floor(Math.random() * 100000), this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
		return this._tabsBackup;
	},
	set tabsBackup(aValue)
	{
		this._tabsBackup = aValue;
	},
	_tabsBackup : null,
  
	get storedTabSetsRoot() 
	{
		if (!this._storedTabSetsRoot)
			this._storedTabSetsRoot = new pRDFData('StoredTabSets', this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
		return this._storedTabSetsRoot;
	},
	set storedTabSetsRoot(aValue)
	{
		this._storedTabSetsRoot = aValue;
	},
	_storedTabSetsRoot : null,
	
	storedTabSets : [], 
   
	get strbundle() 
	{
		if (!this._strbundle) {
			const STRBUNDLE = Components.classes['@mozilla.org/intl/stringbundle;1'].getService(Components.interfaces.nsIStringBundleService);
			this._strbundle = STRBUNDLE.createBundle('chrome://tabextensions/locale/tabextensions.properties');
		}
		return this._strbundle;
	},
	_strbundle : null,
  
	// preferences 
	
	get winHookMode() 
	{
		return this.getPref('browser.tabs.extensions.window_hook_mode');
	},
 
	get preventSameURLTab() 
	{
		return this.getPref('browser.tabs.extensions.prevent_same_uri_tab');
	},
 
	get isGroupMode() 
	{
		return this.getPref('browser.tabs.extensions.group.enabled');
	},
 
	get emulateMiddleButtonByControlKey() 
	{
		return this.getPref('browser.tabs.extensions.emulate_middle_click');
	},
 
	get shouldResutoreLastVisitedTabs() 
	{
		return (
			this.isBrowserWindow &&
			(
				(
					(
						this.browserWindows.length == 1 ||
						this.getPref('browser.windows.loadOnNewWindow') < 0
					) &&
					this.getPref('browser.startup.page') == 2
				) ||
				(
					this.browserWindows.length > 1 &&
					this.getPref('browser.windows.loadOnNewWindow') == 2
				)
			) &&
			this.getPref('browser.tabs.extensions.restore_last_visited_tabs')
		);
	},
 
	get shoulBackupTabs() 
	{
		return (this.isBrowserWindow && this.getPref('browser.tabs.extensions.backup_tabs'));
	},
 
	get bookmarkGroupBehavior() 
	{
		var groupBehavior = this.getPref('browser.tabs.extensions.bookmarkgroup_behavior');
		/*
			0: append to current tabset
			1: insert to current group
			10: replace all tabs
			11: replace current group
			20: replace current tab when only one tab is open
				(normally append to current tabset)
			21: replace current tab when only one tab is open
				(normally insert to current group)
		*/

		if (!this.isGroupMode)
			if (groupBehavior == 1)
				groupBehavior = 0;
			else if (groupBehavior == 11)
				groupBehavior = 10;
			else if (groupBehavior == 21)
				groupBehavior = 20;

		switch (groupBehavior)
		{
			case 0:
			case 1:
			case 10:
			case 11:
			case 20:
			case 21:
				break;

			default:
				groupBehavior = 0;
				break;
		}

		return groupBehavior;
	},
 
	get opentabforBookmarks() 
	{
		return this.getPref('browser.tabs.opentabfor.bookmarks');
	},
	
	get opentabforAnyBookmark() 
	{
		return this.getPref('browser.tabs.opentabfor.anybookmark');
	},
  
	get opentabforHistory() 
	{
		return this.getPref('browser.tabs.opentabfor.history');
	},
	
	get opentabforAnyHistory() 
	{
		return this.getPref('browser.tabs.opentabfor.anyhistory');
	},
  
	get opentabforJS() 
	{
		return this.getPref('browser.tabs.opentabfor.windowopen');
	},
 
	get opentabforPlatformNative() 
	{
		return this.getPref('browser.tabs.opentabfor.native_apps');
	},
 
	get loadInBackground() 
	{
		return this.getPref('browser.tabs.loadInBackground');
	},
	
	get loadInBackgroundBookmarks() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundBookmarks');
	},
 
	get loadInBackgroundHistory() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundHistory');
	},
 
	get loadInBackgroundLocationBar() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundLocationBar');
	},
 
	get loadInBackgroundJS() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundJS');
	},
 
	get loadInBackgroundNative() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundNative');
	},
 
	get loadInBackgroundWindow() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundWindow');
	},
 
	get loadInBackgroundWindowNative() 
	{
		return this.getPref('browser.tabs.extensions.loadInBackgroundWindowNative');
	},
 
	get shouldSaveBookmarksStatus() 
	{
		return this.getPref('browser.tabs.extensions.bookmarks.save_status');
	},
 
	get shouldSaveBookmarksPermissions() 
	{
		return this.getPref('browser.tabs.extensions.bookmarks.save_permissions');
	},
   
	// XPConnect 
	
	get Prefs() 
	{
		if (!this._Prefs) {
			this._Prefs = Components.classes['@mozilla.org/preferences;1'].getService(Components.interfaces.nsIPrefBranch);
		}
		return this._Prefs;
	},
	_Prefs : null,
	
	getPref : function(aPrefstring) 
	{
		try {
			var type = this.Prefs.getPrefType(aPrefstring);
			switch (type)
			{
				case this.Prefs.PREF_STRING:
					return this.Prefs.getComplexValue(aPrefstring, this.knsISupportsString).data;
					break;
				case this.Prefs.PREF_INT:
					return this.Prefs.getIntPref(aPrefstring);
					break;
				default:
					return this.Prefs.getBoolPref(aPrefstring);
					break;
			}
		}
		catch(e) {
		}

		return null;
	},
 
	setPref : function(aPrefstring, aNewValue) 
	{
		var type;
		try {
			type = typeof aNewValue;
		}
		catch(e) {
			type = null;
		}

		switch (type)
		{
			case 'string':
				var string = ('@mozilla.org/supports-wstring;1' in Components.classes) ?
						Components.classes['@mozilla.org/supports-wstring;1'].createInstance(this.knsISupportsString) :
						Components.classes['@mozilla.org/supports-string;1'].createInstance(this.knsISupportsString) ;
				string.data = aNewValue;
				this.Prefs.setComplexValue(aPrefstring, this.knsISupportsString, string);
				break;
			case 'number':
				this.Prefs.setIntPref(aPrefstring, parseInt(aNewValue));
				break;
			default:
				this.Prefs.setBoolPref(aPrefstring, aNewValue);
				break;
		}
		return true;
	},
 
	clearPref : function(aPrefstring) 
	{
		try {
			this.Prefs.clearUserPref(aPrefstring);
		}
		catch(e) {
		}

		return;
	},
  
	get RDF() 
	{
		if (!this._RDF) {
			this._RDF = Components.classes['@mozilla.org/rdf/rdf-service;1'].getService(Components.interfaces.nsIRDFService);
		}
		return this._RDF;
	},
	_RDF : null,
 
	get WindowManager() 
	{
		if (!this._WindowManager) {
			this._WindowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
		}
		return this._WindowManager;
	},
	_WindowManager : null,
 
	get IOService() 
	{
		if (!this._IOService) {
			this._IOService = Components.classes['@mozilla.org/network/io-service;1'].getService(Components.interfaces.nsIIOService);
		}
		return this._IOService;
	},
	_IOService : null,
 
	get GlobalHistory() 
	{
		if (!this._GlobalHistory) {
			this._GlobalHistory = Components.classes['@mozilla.org/browser/global-history;1'].getService(Components.interfaces.nsIGlobalHistory);
		}
		return this._GlobalHistory;
	},
	_GlobalHistory : null,
 
	get PromptService() 
	{
		if (!this.mPromptService)
			this.mPromptService = Components.classes['@mozilla.org/embedcomp/prompt-service;1'].getService(Components.interfaces.nsIPromptService);
		return this.mPromptService;
	},
	mPromptService : null,
 
	get Clipboard() 
	{
		if (!this._Clipboard) {
			this._Clipboard = Components.classes['@mozilla.org/widget/clipboard;1'].getService(Components.interfaces.nsIClipboard);
		}
		return this._Clipboard;
	},
	_Clipboard : null,
 
	get WalletService() 
	{
		if (!this._WalletService &&
			'nsIWalletService' in Components.interfaces) {
			this._WalletService = Components.classes['@mozilla.org/wallet/wallet-service;1'].getService(Components.interfaces.nsIWalletService);
		}
		return this._WalletService;
	},
	_WalletService : null,
 
	get ObserverService() 
	{
		if (!this._ObserverService) {
			this._ObserverService = Components.classes['@mozilla.org/observer-service;1'].getService(Components.interfaces.nsIObserverService);
		}
		return this._ObserverService;
	},
	_ObserverService : null,
   
	// ėp\bh 
	// methods for common use
	
	getInnerTextOf : function(aNode) 
	{
		if (!aNode || !aNode.firstChild) return '';
		var node = aNode.firstChild;

		var depth = 1,
			ret   = [];

		traceTree:
		while (node && depth > 0) {
			if (node.hasChildNodes()) {
				node = node.firstChild;
				depth++;
			} else {
				if (node.nodeType == Node.TEXT_NODE)
					ret.push(node.nodeValue);
				else if (node.alt)
					ret.push(node.alt);

				while (!node.nextSibling) {
					node = node.parentNode;
					depth--;
					if (!node) break traceTree;
				}
				node = node.nextSibling;
			}
		}
		return ret.join('');
	},
 
	// URI񂩂nsURĨIuWFNg𐶐 
	makeURIFromSpec : function(aURI)
	{
		try {
			var newURI;
			aURI = aURI || '';
			if (aURI && aURI.match(/^file:/)) {
				var tempLocalFile;
				try {
					var fileHandler = this.IOService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
					tempLocalFile = fileHandler.getFileFromURLSpec(aURI);
				}
				catch(ex) { // [[interchangeability for Mozilla 1.1]]
					try {
						tempLocalFile = this.IOService.getFileFromURLSpec(aURI);
					}
					catch(ex) { // [[interchangeability for Mozilla 1.0.x]]
						tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
						this.IOService.initFileFromURLSpec(tempLocalFile, aURI);
					}
				}
				newURI = this.IOService.newFileURI(tempLocalFile); // we can use this instance with the nsIFileURL interface.
			}
			else {
				newURI = Components.classes['@mozilla.org/network/standard-url;1'].createInstance(Components.interfaces.nsIURI);
				newURI.spec = aURI;
			}

			return newURI;
		}
		catch(e){
		}
		return null;
	},
 
	getURIFromClipboard : function() 
	{
		try {
			// get string from clipboard
			var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
			trans.addDataFlavor('text/unicode');
			try {
				this.Clipboard.getData(trans, this.Clipboard.kSelectionClipboard);
			}
			catch(ex) {
				this.Clipboard.getData(trans, this.Clipboard.kGlobalClipboard);
			}

			var data       = {},
				dataLength = {};
			trans.getTransferData('text/unicode', data, dataLength);

			if (!data) return null;

			data = data.value.QueryInterface(this.knsISupportsString);
			var str = data.data.substring(0, dataLength.value / 2);


			// is the string an URI?
			var uris = str.match(/^\s*(([-+a-z0-9.]+:\/\/|[-a-z0-9]+(\.[-a-z0-9]+)+)[-_.!~*'()a-z0-9;\/?:\@&=+\$,%#]+)\s*$/i);
			if (!uris) return null;

			for (var i in uris)
			{
				if (typeof uris[i] != 'string') uris[i] = uris[i][0];
				if (uris[i].match(/^(\w+:\/\/|urn:|www[0-9]*\.)/)/* ||
					uris[i].match(/[-a-z0-9.]\.(com|org|net|edu|gov|mil|(co|or|ne|ed|ac|ad|go|mi)\.[a-z]{2})/i)*/)
					return uris[i]
							.replace(/^(www[0-9]*\.)/, 'http://$1')
							.replace(/^h?t?t?p:\/\//, 'http://')
							.replace(/^h?t?t?ps:\/\//, 'https://');
			}

			return null;
		}
		catch(e) {
		}
	},
 
	// bookmarks 
	
	get isNewTypeBookmarks() 
	{
		var type   = this.RDF.GetResource('http://www.w3.org/1999/02/22-rdf-syntax-ns#type');
		var folder = this.RDF.GetResource('http://home.netscape.com/NC-rdf#Folder');
		var roots  = this.BookmarksDS.GetSources(type, folder, true);
		roots.getNext();
		return roots.hasMoreElements();
	},
 
	isBookmarked : function(aIDOrURI) 
	{
		if (!aIDOrURI) return false;
		if (aIDOrURI.match(/^rdf:/)) return true;

		try {
			if ('IsBookmarked' in this.BookmarksDS) // NS7
				return this.BookmarksDS.IsBookmarked(aIDOrURI);
			else
				return this.BookmarksDS.isBookmarked(aIDOrURI);
		}
		catch(e) {
		}

		return false;
	},
 
	// get bookmark resources from URI 
	getBookmarkResourcesFromURI : function(aURIOrID)
	{
		// old implementation
		var res = this.RDF.GetResource(aURIOrID);
		if (this.BookmarksDS.GetTarget(res, this.kNC_URL, true))
			return [res];

		var resources = this.BookmarksDS.GetSources(this.kNC_URL, this.RDF.GetLiteral(aURIOrID), true);
		var ret = [];
		while (resources.hasMoreElements())
			ret.push(resources.getNext().QueryInterface(this.knsIRDFResource));

		return ret;
	},
 
	getURIForBookmark : function(aID) 
	{
		if (!aID.match(/^rdf:/)) return aID;

		var uriRes = this.BookmarksDS.GetTarget(this.RDF.GetResource(aID), this.kNC_URL, true);
		try {
			if (uriRes) {
				uriRes = uriRes.QueryInterface(this.knsIRDFLiteral);
				if (uriRes && uriRes.Value)
					return uriRes.Value;
			}
		}
		catch(e) {
		}

		return null;
	},
 
	// ubN}[NɋL^ꂽt@𓾂it@̋Uj 
	// get the referrer for a bookmark (to camouflage referrer)
	getReferrerForBookmark : function(aID)
	{
		if (!this.isBookmarked(aID)) return null;
		try {
			return this.makeURIFromSpec(this.bookmarksData.getData(this.RDF.GetResource(aID), 'ReferrerURI'));
		}
		catch(e) {
		}
		return null;
	},
 
	getFixedLabelForBookmark : function(aID) 
	{
		if (!this.isBookmarked(aID)) return null;
		try {
			if (this.getPref('browser.tabs.extensions.bookmarks.use_fixed_label') ||
				this.bookmarksData.getData(this.RDF.GetResource(aID), 'UseFixedLabel') == 'true')
				return this.getNameForBookmark(aID);
		}
		catch(e) {
		}
		return null;
	},
 
	getNameForBookmark : function(aID) 
	{
		try {
			return this.BookmarksDS.GetTarget(this.RDF.GetResource(aID), this.kNC_NAME, true).QueryInterface(this.knsIRDFLiteral).Value;
		}
		catch(e) {
		}

		return null;
	},
 
	setNameForBookmark : function(aNewName, aID) 
	{
		if (!this.isBookmarked(aID))
			return;

		var res     = this.RDF.GetResource(aID);
		var oldName = this.getNameForBookmark(aID);

		if (aNewName === void(0)) {
			var history = this.RDF.GetDataSource('rdf:history');
			aNewName = history.GetTarget(this.RDF.GetResource(aID), this.kNC_NAME, true);
			aNewName = aNewName ? aNewName.QueryInterface(this.knsIRDFLiteral).Value : null ;
			if (!aNewName) aNewName = aURI;
		}

		if ((!oldName && !aNewName) || oldName == aNewName) return;

		if (oldName && !aNewName)
			this.BookmarksDS.Unassert(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(oldName)
			);
		else if (!oldName && aNewName)
			this.BookmarksDS.Assert(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(aNewName),
				true
			);
		else
			this.BookmarksDS.Change(
				res,
				this.kNC_NAME,
				this.RDF.GetLiteral(oldName),
				this.RDF.GetLiteral(aNewName)
			);

		try {
			this.BookmarksDS.Flush();
		}
		catch(e) {
		}
	},
 
	// ubN}[NɋL^ꂽACR𓾂 
	// get the icon for a bookmark
	getIconForBookmark : function(aURI, aOnlyUserDefined)
	{
		if (!aURI) return '';

		aURI = this.getURIForBookmark(aURI);
		if (!aURI) return;

		var icon;

		if (!this.isBookmarked(aURI)) {
			// get icon from icon data
			var dir = aURI.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '').split('/');

			while(dir.length && !icon)
			{
				icon = this.iconData.getData(dir.join('/')+'/', 'IconURI');
				if (icon)
					break;
				else
					dir.splice(dir.length-1, 1);
			}

			if (!icon) return '';
		}

		if (!icon) icon = this.iconData.getData(aURI, 'IconURI');

		if (!icon && !aOnlyUserDefined) {
			try {
				var res = this.getBookmarkResourcesFromURI(aURI);
				for (var i in res)
				{
					icon = this.BookmarksDatabase.GetTarget(
							res[i],
							this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
							true
						);
					icon = (icon) ? icon.QueryInterface(this.knsIRDFLiteral).Value : '' ;
					if (icon) break;
				}
			}
			catch(e) {
				icon = '';
			}
		}
		return icon;
	},
 
	// ubN}[NɋL^ꂽACR[U[`̃ACRŏ㏑ 
	// override bookmark's icon by user's icon
	setIconForBookmark : function(aURI, aIconURI)
	{
		aURI = this.getURIForBookmark(aURI);
		if (!aURI || !this.isBookmarked(aURI)) return;

		if (aIconURI) this.iconData.setData(aURI, 'IconURI', aIconURI);

		var icon = aIconURI || this.iconData.getData(aURI, 'IconURI');

		// add entry to icon data
		var dir = aURI.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '')+'/';
		if (icon)
			this.iconData.setData(dir, 'IconURI', icon);
		else if (this.iconData.getData(dir, 'IconURI'))
			this.iconData.removeData(dir);

		// update bookmarks
		try {
			var res = this.getBookmarkResourcesFromURI(aURI);
			var oldIcon;
			for (var i in res)
			{
				oldIcon = this.BookmarksDatabase.GetTarget(
						res[i],
						this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
						true
					);
				if (oldIcon) break;
			}
			if (
				!oldIcon ||
				oldIcon.QueryInterface(this.knsIRDFLiteral).Value != icon
				)
				this.BookmarksDS.updateBookmarkIcon(aURI, icon);
		}
		catch(e) {
/*
			try {
				this.BookmarksDS.Assert(
					res,
					this.RDF.GetResource('http://home.netscape.com/NC-rdf#Icon'),
					this.RDF.GetLiteral(icon),
					true
				);
			}
			catch(ex) {
			}
*/
		}
	},
 
	// ubN}[NɋL^ꂽŒA[hȂǂ̏Ԃǂݍ 
	// load stored data of the bookmark
	readBookmarkStatusToTabInfo : function(aID, aInfo)
	{
		if (!this.isBookmarked(aID)) return;
		var res = this.RDF.GetResource(aID);

		if (this.getPref('browser.tabs.extensions.bookmarks.use_fixed_label') ||
			this.bookmarksData.getData(res, 'UseFixedLabel') == 'true')
			aInfo.useFixedLabel = true;
		if (this.bookmarksData.getData(res, 'Locked') == 'true')
			aInfo.locked = true;
		if (this.bookmarksData.getData(res, 'ReferrerBlocked') == 'true')
			aInfo.referrerBlocked = true;
		if (this.bookmarksData.getData(res, 'AutoReload') == 'true') {
			aInfo.autoreloadInterval = Number(this.bookmarksData.getData(res, 'AutoReloadInterval') || 0);
		}

		var forbidFlags = ['Plugins', 'Javascript', 'MetaRedirects', 'Subframes', 'Images'];
		for (var i in forbidFlags)
			if (i != 'Subframes' ||
				this.getPref('browser.frames.enabled')) {
				aInfo['allow'+forbidFlags[i]] = (this.bookmarksData.getData(res, 'Forbid'+forbidFlags[i]) != 'true');
			}
			else { // for subframes
				aInfo['allow'+forbidFlags[i]] = (this.bookmarksData.getData(res, 'Forbid'+forbidFlags[i]) == 'false');
			}

//		var icon = this.bookmarksData.getData(res, 'IconURI');
//		if (icon)
//			flags.push('icon='+icon);

		var referrer = this.bookmarksData.getData(res, 'ReferrerURI');
		if (referrer)
			aInfo.referrerURI = this.makeURIFromSpec(referrer);
	},
  
	// R_CAOŃACRI 
	chooseIcon : function()
	{
		const nsIFilePicker = Components.interfaces.nsIFilePicker;
		const FP = Components.classes['@mozilla.org/filepicker;1'].createInstance(nsIFilePicker);

		title = this.strbundle.GetStringFromName('bookmarksProperty_chooseIcon');

		FP.init(window, title, nsIFilePicker.modeOpen);

		FP.appendFilter(this.strbundle.GetStringFromName('bookmarksProperty_chooseIconFilterLabel'), '*.ico;*.icon');
		FP.appendFilters(nsIFilePicker.filterImages);
//		FP.appendFilters(nsIFilePicker.filterAll);
		FP.show();

		var icon;
		try {
			icon = FP.file.QueryInterface(Components.interfaces.nsILocalFile);
		}
		catch(e) {
			return '';
		}

		try {
			icon = this.IOService.newFileURI(icon).spec;
		}
		catch(e) { // [[interchangeability for Mozilla 1.1]]
			icon = this.IOService.getURLSpecFromFile(icon);
		}

		return icon || '' ;
	},
 
	shouldSendReferrerWithLinkClick : function() 
	{
		var linkNode = TabbrowserService.getLastActiveLink();
		if (!linkNode ||
			!TabbrowserService.browsers.length ||
			linkNode.ownerDocument.defaultView.top.document == window.document)
			return true;

		var d = linkNode.ownerDocument.defaultView.top.document,
			b = TabbrowserService.browser,
			t = b.mCurrentTab;

		for (var i in b.mTabs)
			if (b.mTabs[i].mBrowser.contentDocument == d)
				t = b.mTabs[i];

		return !t.mTabInfo.referrerBlocked;
	},
 
	// ŌɃNbNꂽN𓾂 
	getLastActiveLink : function()
	{
		var target = gContextMenu ? gContextMenu.target : null ;
		if (!target)
			return target;
		else
			return findParentNode(target, 'a') ||
				findParentNode(target, 'area') ||
				findParentNode(target, 'link') ||
//				findParentNode(target, 'q') ||
//				findParentNode(target, 'blockquote') ||
//				findParentNode(target, 'ins') ||
//				findParentNode(target, 'del') ||
				null ;
	},
 
	// NKɂ 
	makeLinkVisited : function(aURI, aNode)
	{
		try {
			if (!aNode || this.GlobalHistory.isVisited(aURI) ||
				!aURI.match(/^(https?|ftp|file|resource|chrome|gopher):/)) return;

			this.GlobalHistory.addPage(aURI);
			var oldHref = aNode.href;
			aNode.href = '';
			aNode.href = oldHref;
		}
		catch(e) {
		}
	},
 
	// t@ubJ[ւURIǂׁAłΒuURIAłȂnullA 
	// if the uri contains referrer blocker, this returns the real uri. if not, returns null.
	getRealURI : function(aURI)
	{
		var regexp = new RegExp('^('+this.referrerBlockers.join('|')+')');
		var accessFromReferrerBlocker = aURI.match(regexp);
		if (accessFromReferrerBlocker &&
			this.getPref('browser.tabs.extensions.bypass_referrerblocker')) {
			aURI = aURI.replace(regexp, '');
			if (!aURI.match(/http:\/\//)) aURI = 'http://'+aURI;
			return aURI;
		}
		else return null;
	},
 
	// ^ꂽÕt[ԂiċAj 
	// get a frame from name (reflexive)
	getFrameByName : function(aFrames, aName)
	{
		var frame = null;
		for (var i = 0; i < aFrames.length; i++)
		{
			if (aFrames[i].name == aName) return aFrames[i];
			if (aFrames[i].frames.length) {
				frame = this.getFrameByName(aFrames[i].frames, aName);
				if (frame) break;
			}
		}
		return frame;
	},
 
	// ZLeB̃`FbN 
	uriSecurityCheck : function(aURI, aSourceURI)
	{
		const nsIScriptSecurityManager = Components.interfaces.nsIScriptSecurityManager;
		var secMan = Components.classes['@mozilla.org/scriptsecuritymanager;1'].getService(nsIScriptSecurityManager);
		try {
			secMan.checkLoadURIStr(aSourceURI, aURI, nsIScriptSecurityManager.STANDARD);
		}
		catch (e) {
			throw 'Load of '+aURI+' denied.';
		}
	},
 
	stopEvent : function(aEvent) 
	{
		aEvent.stopPropagation();
		aEvent.preventCapture();
		aEvent.preventDefault();
		aEvent.preventBubble();
	},
 
	// popup menupopup in the menubar by id 
	popupMenu : function(aID)
	{
		var node = document.getElementById(aID);
		if (!node) return;

		var x = window.screenX+20,
			y = window.screenY+40;

		node.autoPosition = true;
		node.showPopup(node.parentNode, x, y, 'popup', null, null);

		if (node.popupBoxObject.screenX != x ||
			node.popupBoxObject.screenY != y)
			node.moveTo(x, y);
	},
  
	//  
	init : function()
	{
		var nullPointer;
		nullPointer = this.bookmarksData;
		nullPointer = this.iconData;
		nullPointer = this.JSWindowOpenExceptions;
		nullPointer = this.tabHistory;
		nullPointer = this.tabHistoryQuitRoot;
		nullPointer = this.tabsBackupRoot;
		nullPointer = this.storedTabSetsRoot;
		delete nullPointer;

		this.loadDefaultPrefs();
		this.updateGeneralFunctions();

		// Catch up changing of prefs
		this.addPrefListener(gTSGeneralPrefListener);
		if (this.isBrowserWindow) {
			this.addPrefListener(gTSTabHistoryQuitPrefListener);
			this.addPrefListener(gTSTabsBackupPrefListener);
			this.addPrefListener(gTWindowModePrefListener);
			this.addPrefListener(gTSOpenTabForWindowOpenPrefListener);
			this.addPrefListener(gTSObserveClipboardPrefListener);

			if (navigator.platform.indexOf('Linux') < 0) {
				window.addEventListener('dragover', this.onTabbarDragOver, true);
				window.addEventListener('dragdrop', this.onTabbarDrop, true);
			}

//			this.ObserverService.addObserver(gTSDomWindowOpenObserver, 'domwindowopened', false);
		}
		if (this.browser) {
			this.addPrefListener(gTSCloseBoxPrefListener);
			this.addPrefListener(gTSLastTabClosingPrefListener);
			this.addPrefListener(gTSTabsAutoHidePrefListener);
			this.addPrefListener(gTSIconOverlayInTabsPrefListener);
			this.addPrefListener(gTSShowTabbarInBottomPrefListener);
			this.addPrefListener(gTSGroupModePrefListener);
			this.addPrefListener(gTSTabsWidthPrefListener);
			this.addPrefListener(gTSTabScrollbarPrefListener);

			window.addEventListener('resize', this.onWindowResize, false);
		}

		this.updateTabBrowser();

		if (this.isBrowserWindow) {
			gTSTabHistoryQuitPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabsBackupPrefListener.observe(null, 'nsPref:changed', null);
			gTWindowModePrefListener.observe(null, 'nsPref:changed', null);
			gTSObserveClipboardPrefListener.observe(null, 'nsPref:changed', null);
		}
		if (this.browser) {
			gTSShowTabbarInBottomPrefListener.observe(null, 'nsPref:changed', null);
			gTSIconOverlayInTabsPrefListener.observe(null, 'nsPref:changed', null);
			gTSCloseBoxPrefListener.observe(null, 'nsPref:changed', null);
			gTSLastTabClosingPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);
			gTSTabScrollbarPrefListener.observe(null, 'nsPref:changed', null);
		}


		this.BookmarksDS.AddObserver(gTSBookmarksObserver);

		if (!this.isNewTypeBrowser) {
			window.addEventListener('close', this.onWindowClose, false);
		}

		var isLastVisited = false;
		try {
			isLastVisited = ('arguments' in window) ? window.arguments.length == 1 && window.arguments[0] == this.GlobalHistory.QueryInterface(Components.interfaces.nsIBrowserHistory).lastPageVisited : false ;
		}
		catch(e) {
		}
		window.setTimeout('TabbrowserService.initWithDelay('+isLastVisited+');', 1); // Lately Mozilla gets the last visited URI as the first argument.


		// initialize global "undo close tab" cache and clipbard history
		var targets = this.WindowManager.getEnumerator(null, true),
			target;
		while (targets.hasMoreElements())
		{
			target = targets.getNext().QueryInterface(Components.interfaces.nsIDOMWindowInternal);
			if (!target.gTSGlobalUndoRemoveTabCache) continue;

			window.gTSGlobalUndoRemoveTabCache = target.gTSGlobalUndoRemoveTabCache;
			window.gTSObserveClipboardLastURI = target.gTSObserveClipboardLastURI;
			break;
		}
		if (!window.gTSGlobalUndoRemoveTabCache)
			window.gTSGlobalUndoRemoveTabCache = [];
		if (!window.gTSObserveClipboardLastURI)
			window.gTSObserveClipboardLastURI = { value : null };


		this.initialized = true;
	},
	
	// fBC̏ 
	initWithDelay : function(aArgumentIsLastVisited)
	{
		this.readBookmarkStatusToTabInfo('about:blank', {});


		this.convertOldData();

		// clear garbages
		if (this.getPref('browser.tabs.extensions.auto_cleanUp')) {
			var count = this.getPref('browser.tabs.extensions.auto_cleanUp_count');
			if (count > 9) {
				if ('cleanUp' in this.bookmarksData)
					this.bookmarksData.cleanUp(true);
				else
					this.cleanUpData();

				this.setPref('browser.tabs.extensions.auto_cleanUp_count', 0);
			}
			else {
				this.setPref('browser.tabs.extensions.auto_cleanUp_count', count+1);
			}
		}


		// reset labels
		gTSTabsWidthPrefListener.observe(null, 'nsPref:changed', null);

		// reset icons
		var icons = this.iconData,
			uri,
			icon;
		for (var i = 0; i < icons.length; i++)
			try {
				this.BookmarksDS.updateBookmarkIcon(unescape(icons.item(i).Value.match(/[^:]+$/)), icons.getData(icons.item(i), 'IconURI'));
			}
			catch(e) {
			}

		if (this.isBrowserWindow) {
			this.initStoredTabSets();
			this.initClosedTabsHistory();

			try {
				this.ObserverService.addObserver(gTSStoredTabSetsListener, 'tabextensions:storedTabSetsModified', false);
			}
			catch(e) {
			}
			window.addEventListener('XULTabbrowserUndoCacheAdded', this.onXULTabbrowserUndoCacheModified, true);
			window.addEventListener('XULTabbrowserUndoCacheRemoved', this.onXULTabbrowserUndoCacheModified, true);
		}

		// NIvVœnꂽURIJEBhEǂ
		this.startWithOpenURLRequest = (
			('arguments' in window) &&
			window.arguments.length &&
			window.arguments[0] &&
			!aArgumentIsLastVisited
		);

		// restore tabs
		this.restoreLastTabsOrVisited(aArgumentIsLastVisited);

		// sometimes, menuitems in "chevron" are shown as personal toolbar buttons, like "buttons are doubled".
		// this rebuilding is a fix for this problem.
		if (document.getElementById('bookmarks-chevron'))
			document.getElementById('bookmarks-chevron').builder.rebuild();
		if (document.getElementById('bookmarks-ptf'))
			document.getElementById('bookmarks-ptf').builder.rebuild();
	},
	
	// convert data for the old bookmark implementation to the new one 
	convertOldData : function()
	{
		if (!this.isNewTypeBookmarks) return;

		var bookmarks = this.bookmarksData,
			icons     = this.iconData,
			props     = [
				'UseFixedLabel',
				'Locked',
				'ReferrerBlocked',
				'AutoReload',
				'AutoReloadInterval',
				'ForbidPlugins',
				'ForbidJavascript',
				'ForbidMetaRedirects',
				'ForbidSubframes',
				'ForbidImages',
				'ReferrerURI'
			],
			item,
			res,
			value,
			i, j, k;

		for (i = bookmarks.length-1; i > -1; i--)
		{
			item = bookmarks.item(i);
			if (!item || item.Value.match(/^rdf:/)) continue;

			if (value = bookmarks.getData(item, 'IconURI'))
				icons.setData(item.Value.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '')+'/', 'IconURI', value);

			res = this.getBookmarkResourcesFromURI(item.Value);
			for (j in res)
				for (k in props)
					if (value = bookmarks.getData(item, props[k]))
						bookmarks.setData(res[j], props[k], value);

			bookmarks.removeData(item);
			bookmarks.removeResource(item);
		}
	},
 
	// clear all of garbages in the datasource 
	cleanUpData : function()
	{
		var resources = this.datasource.GetAllResources();
		var resource;
		var names, name, value;
		while (resources.hasMoreElements())
		{
			try {
				resource = resources.getNext().QueryInterface(this.knsIRDFResource);

				if (resource.Value.match(/:root$/) ||
					this.datasource.ArcLabelsIn(resource).hasMoreElements())
					continue;

				names = this.datasource.ArcLabelsOut(resource);
				while (names.hasMoreElements())
				{
					try {
						name = names.getNext().QueryInterface(this.knsIRDFResource);
						value = dsource.GetTarget(resource, name, true);
						this.datasource.Unassert(resource, name, value);
					}
					catch(ex) {
					}
				}
			}
			catch(e) {
			}
		}
		this.datasource.Flush();
	},
 
	// ŌɊJĂ^uJ 
	// open last visited tabs with startup
	restoreLastTabsOrVisited : function(aArgumentIsLastVisited)
	{
try {
		var nav = this.browserWindows;
		if (
			(
				this.shouldResutoreLastVisitedTabs ||
				this.shoulBackupTabs
			) &&
			nav.length == 1 &&
			nav[0] == window &&
			(// NIvVœnꂽURID
				!('arguments' in window) ||
				!window.arguments.length ||
				!window.arguments[0] ||
				aArgumentIsLastVisited
			)
			) {
			var shouldRestoreBackup = (this.tabsBackupRoot.length > this.browserWindows.length);
			if (shouldRestoreBackup) {
				shouldRestoreBackup = this.shoulBackupTabs;
				if (!this.getPref('browser.tabs.extensions.backup_tabs_confirm_hidden')) {
					var check  = { value: false };

					shouldRestoreBackup = this.PromptService.confirmEx(
							window,
							this.strbundle.GetStringFromName('message_restore_tabs_title'),
							this.strbundle.GetStringFromName('message_restore_tabs_text'),
							(
								(this.PromptService.BUTTON_TITLE_YES * this.PromptService.BUTTON_POS_0) +
								(this.PromptService.BUTTON_TITLE_NO * this.PromptService.BUTTON_POS_1)
							),
							null, null, null,
							this.strbundle.GetStringFromName('message_never_show_dialog'),
							check
						) == 0;

					// save pressed button
					if (check.value) {
						this.setPref('browser.tabs.extensions.backup_tabs_confirm_hidden', check.value);
						this.setPref('browser.tabs.extensions.backup_tabs', shouldRestoreBackup);
					}

					// clear stored data
					if (!shouldRestoreBackup) {
						var history = this.tabsBackupRoot;

						var res,
							id,
							entries = [];
						for (var i = 0; i < history.length; i++)
						{
							id = history.item(i).Value.match(/TabsBackup:window-\d+/)[0];

							if (id == this.tabsBackup.id) continue;

							entries[i] = new pRDFData(id, this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
						}

						if (entries.length)
							window.setTimeout(
								function(aEntries)
								{
									for (var i in aEntries) {
										aEntries[i].clearData();
										TabbrowserService.tabsBackupRoot.removeData(aEntries[i].containerNode);
									}
								},
								0,
								entries
							);
					}
				}
			}
			if (this.shouldResutoreLastVisitedTabs || shouldRestoreBackup)
				this.restoreAllTabs(
					shouldRestoreBackup ? this.tabsBackupRoot :
					this.tabHistoryQuitRoot.length > 1 ? this.tabHistoryQuitRoot :
					this.tabHistory
				);
		}
		else if ( // ŋ߃ANeBuuEUEBhE^uRs[
			this.shouldResutoreLastVisitedTabs &&
			this.getPref('browser.tabs.extensions.copy_recent_tabs') &&
			nav.length > 1
			) {
			this.copyTabsFrom(nav[1]);
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.initWithDelay()"\n\n'+e);
}
	},
  
	// W̊֐̏㏑ 
	updateGeneralFunctions : function()
	{
		var i,
			nodes;

		// Link Click
		if ('contentAreaClick' in window) {
			window.__tabextensions__contentAreaClick = window.contentAreaClick;
			window.contentAreaClick = this.contentAreaClick;
		}
		if ('handleLinkClick' in window) {
			window.__tabextensions__handleLinkClick = window.handleLinkClick;
			window.handleLinkClick = this.handleLinkClick;
		}
		// Mail&News (1.4 or later)
		if ('messagePaneOnClick' in window) {
			document.getElementById('messagepane').removeEventListener('click', messagePaneOnClick, true);
			window.__tabextensions__messagePaneOnClick = window.messagePaneOnClick;
			window.messagePaneOnClick = this.messagePaneOnClick;
			document.getElementById('messagepane').addEventListener('click', window.messagePaneOnClick, true);
		}


		// Toolbar Items
		if (this.isNewTypeBrowser) {
			nodes = document.getElementsByTagName('toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].__tabextensions__insertItem = nodes[i].insertItem;
				nodes[i].insertItem = this.insertItem;
				nodes[i].addEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
			}
		}


		// Location Bar
		if ('BrowserLoadURL' in window) {
			window.__tabextensions__BrowserLoadURL = window.BrowserLoadURL;
			window.BrowserLoadURL = this.BrowserLoadURL;
/*
			if (this.isNewTypeBrowser)
				gTSToolbarItemsInsertedEventListener(null, 'urlbar-container');
			else
				document.getElementById('urlbar').setAttribute('ontextentered', 'return TabbrowserService.handleURLBarCommand(param);');
*/
		}


		// Bookmarks
		window.OpenBookmarkURL = this.openBookmarkURL;
		window.OpenBookmarkGroupFromResource = this.openBookmarkGroup;
		window.BrowserOpenTab = this.BrowserOpenTab;
		if (window.BrowserCloseTabOrWindow) {
			window.BrowserCloseTabOrWindow = this.BrowserCloseTabOrWindow;
		}
		if ('BookmarksUtils' in window) {
			BookmarksUtils.__tabextensions__addBookmark = BookmarksUtils.addBookmark;
			BookmarksUtils.addBookmark = this.addBookmark;
			BookmarksUtils.__tabextensions__createBookmark = BookmarksUtils.createBookmark;
			BookmarksUtils.createBookmark = this.createBookmark;
		}
		if ('BookmarksMenu' in window) {
			BookmarksMenu.__tabextensions__loadBookmark = BookmarksMenu.loadBookmark;
			BookmarksMenu.loadBookmark = this.loadBookmark;
			BookmarksMenu.__tabextensions__loadBookmarkMiddleClick = BookmarksMenu.loadBookmarkMiddleClick;
			BookmarksMenu.loadBookmarkMiddleClick = this.loadBookmarkMiddleClick;
		}
		if ('BookmarksCommand' in window) {
			BookmarksCommand.__tabextensions__openBookmark = BookmarksCommand.openBookmark;
			BookmarksCommand.openBookmark = this.BookmarksCommandOpenBookmark;
			BookmarksCommand.__tabextensions__createContextMenu = BookmarksCommand.createContextMenu;
			BookmarksCommand.createContextMenu = this.BookmarksCommandCreateContextMenu;
		}

		if (this.isNewTypeBrowser) { // Phoenix/Firebird or Mozilla 1.5 or later
			if ('BookmarksCommand' in window)
				BookmarksCommand.openGroupBookmark = this.openGroupBookmark;

			nodes = document.getElementsByTagName('bookmarks-toolbar');
			for (i = 0; i < nodes.length; i++) {
				nodes[i].toolbar.setAttribute('oncommand', 'TabbrowserService.openBookmarkURL(event.originalTarget, this.database, event, this);');
				nodes[i].toolbar.setAttribute('onclick', 'TabbrowserService.openBookmarkURL(event.originalTarget, this.database, event, this);');
			}

			if (this.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith;
			}

			if ('ctrlNumberTabSelection' in window)
				window.ctrlNumberTabSelection = this.ctrlNumberTabSelection;
		}
		else {
			if (this.isBrowserWindow) {
				window.__tabextensions__openNewTabWith = window.openNewTabWith;
				window.openNewTabWith = this.openNewTabWith_old;

				window.__tabextensions__openNewWindowWith = window.openNewWindowWith;
				window.openNewWindowWith = this.openNewWindowWith;
			}
		}

		nodes = document.getElementsByTagNameNS(this.XULNS, 'bookmarks-tree');
		for (i = 0; i < nodes.length; i++)
		{
			if ('openItemClick' in nodes[i]) {
				nodes[i].__tabextensions__openItemKey  = nodes[i].openItemKey;
				nodes[i].__tabextensions__openItemClick = nodes[i].openItemClick;
			}
			nodes[i].openItemKey   = this.openBookmarkItemClickOrKey;
			nodes[i].openItemClick = this.openBookmarkItemClickOrKey;

			// old implementation
			nodes[i].__tabextensions__openItem = nodes[i].openItem;
			nodes[i].openItem = (this.isNewTypeBrowser) ? this.openBookmarkItemClickOrKey : this.openBookmarkItem ; // Phoenix/Firebird or Mozilla 1.5 or later

			if (!nodes[i].tree.getAttribute('onclick'))
				nodes[i].tree.setAttribute('onclick', 'if (event.button != 1) return; '+nodes[i].tree.getAttribute('ondblclick'));

			nodes[i].validOpenClickConditions = this.validOpenClickConditions;
		}


		// Context Menu
		if ('nsContextMenu' in window) {
			nsContextMenu.prototype.__tabextensions__initItems = nsContextMenu.prototype.initItems;
			nsContextMenu.prototype.initItems = this.initItems;
		}


		// JavaScript "window.open()"
		if (window.open && this.isBrowserWindow) {
			window.__tabextensions__open = window.open;
			window.open = eval(this.newWindowOpen.toSource());
//			Window.prototype.__tabextensions__open = Window.prototype.open;
//			Window.prototype.open = eval(this.newWindowOpen.toSource());
			window.openBrowserTab = this.openBrowserTab;
			window.shouldOpenBrowserTab = this.shouldOpenBrowserTab;
			if (window.openDialog) {
				window.__tabextensions__openDialog = window.openDialog;
				window.openDialog = this.openDialog;
			}
		}


		// History
		if ('gHistoryTree' in window && !this.isNewTypeBrowser) {
			if ('OpenURL' in window) {
				window.__tabextensions__OpenURL = window.OpenURL;
				window.OpenURL = this.OpenURL;
			}
			if ('historyOnClick' in window) {
				window.__tabextensions__historyOnClick = window.historyOnClick;
				window.historyOnClick = this.historyOnClick;
			}
		}
		if ('gotoHistoryIndex' in window) {
//			window.__tabextensions__gotoHistoryIndex = window.gotoHistoryIndex;
			window.gotoHistoryIndex = this.gotoHistoryIndex;

			if (navigator.platform.indexOf('Mac') < 0) {
				var buttons = {
						back    : null,
						forward : null
					};

				nodes = document.getElementsByAttribute('oncommand', 'gotoHistoryIndex(event);');
				for (i = 0; i < nodes.length; i++)
				{
					nodes[i].addEventListener('click', gotoHistoryIndex, true);
					if (nodes[i].id == 'back-button')
						buttons.back = nodes[i];
					else if (nodes[i].id == 'forward-button')
						buttons.forward = nodes[i];
				}

				// back and forward buttons
				if (this.isNewTypeBrowser) {
					gTSToolbarItemsInsertedEventListener(null, 'back-button');
					gTSToolbarItemsInsertedEventListener(null, 'forward-button');
				}
				else {
					for (i in buttons) {
						if (buttons[i]) continue;

						buttons[i] = document.getElementById(i+'-button');
						if (buttons[i])
							buttons[i].addEventListener('click', gotoHistoryIndex, true);
					}
				}
			}
		}


		window.__tabextensions__goQuitApplication = window.goQuitApplication;
		window.goQuitApplication = this.goQuitApplication;


		// kill original confirming
		if ('WindowIsClosing' in window) {
			window.WindowIsClosing = function() { return true; };
		}
		if ('BrowserTryToCloseWindow' in window) {
			window.BrowserTryToCloseWindow = function() { return true; };
		}
	},
 
	// tabbrowser̍XV 
	updateTabBrowser : function()
	{
		var b = this.browsers;
		for (var i = 0; i < b.length; i++)
		{
			// failsafe
			b[i].mPanelContainer.selectedIndex = 0;
			this.updateMethods(b[i]);
			this.updateContextMenu(b[i]); // Add new menuitems
			this.supportMovableTabs(b[i]);
			this.updateTabContainer(b[i]);

			// for Phoenix/Firebird or Mozilla 1.5 or later
			// Phonix fails to execute "constructor" of tabs. why?
			b[i].mTabContainer.selectedIndex = 0;
			b[i].mTabs[0].setAttribute('first-tab', 'true');
			b[i].mTabs[b[i].mTabs.length-1].setAttribute('last-tab', 'true');

			b[i].addTabProgressListenerInternal(b[i].mCurrentTab);

			// reset tabbrowserReadyState
			b[i].addEventListener('close', this.onTabbrowserWindowClose, true);
			// failsafe
			b[i].addEventListener('unload', this.onTabbrowserWindowUnload, true);

			b[i].addEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
			b[i].addEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
			b[i].addEventListener('XULTabbrowserTabAdded', this.onXULTabbrowserTabAdded, false);
			b[i].addEventListener('XULTabbrowserTabRemoved', this.onXULTabbrowserTabRemoved, false);
			b[i].addEventListener('XULTabbrowserTabReordered', this.onXULTabbrowserTabReordered, false);
//			b[i].addEventListener('XULTabbrowserTabGroupModified', this.onXULTabbrowserTabGroupModified, false);
			b[i].addEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
			b[i].addEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
			b[i].addEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
			// open tabs in other windows if "addTab" is canceled
			b[i].addEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);

			b[i].addEventListener('mouseup', this.onMouseEvent, true);
			b[i].addEventListener('mousedownup', this.onMouseEvent, true);
			b[i].addEventListener('click', this.onMouseEvent, true);
			b[i].addEventListener('dblclick', this.onMouseEvent, true);
		}
	},
	
	// \bh̏㏑ 
	updateMethods : function(aTabBrowser)
	{
		aTabBrowser.__tabextensions__updatePopupMenu = aTabBrowser.updatePopupMenu;
		aTabBrowser.updatePopupMenu = this.updatePopupMenu;
		aTabBrowser.__tabextensions__addTab = aTabBrowser.addTab;
		aTabBrowser.addTab = this.addTab;
		aTabBrowser.__tabextensions__removeTab = aTabBrowser.removeTab;
		aTabBrowser.removeTab = this.removeTab;

		aTabBrowser.replaceGroup = this.replaceGroup;

		aTabBrowser.getBrowserForTab = this.getBrowserForTab;
		aTabBrowser.onTabClick       = this.onTabClick;

		aTabBrowser.__tabextensions__buildFavIconString = aTabBrowser.buildFavIconString;
		aTabBrowser.buildFavIconString = this.buildFavIconString;
		aTabBrowser.__tabextensions__loadFavIcon = aTabBrowser.loadFavIcon;
		aTabBrowser.loadFavIcon = this.loadFavIcon;

		var popups = aTabBrowser.mStrip.getElementsByAttribute('onpopupshowing', '*');
		for (var i = 0; i < popups.length; i++)
			if (popups[i].localName == 'menupopup') {
				popups[i].setAttribute('onpopupshowing', 'this.parentNode.parentNode.parentNode.updatePopupMenu(this, event);');
				popups[i].mTabBrowser = aTabBrowser;
			}

		// for Netscape 7
		aTabBrowser.newTab = this.BrowserOpenTab;


		aTabBrowser.bookmarksManager = {
			isBookmarked : function(aURI)
			{
				return TabbrowserService.isBookmarked(aURI);
			},
			getName : function(aID)
			{
				return TabbrowserService.getNameForBookmark(aID);
			},
			setName : function(aNewName, aID)
			{
				TabbrowserService.setNameForBookmark(aNewName, aID);
			},
			getIcon : function(aURI, aOnlyUserDefined)
			{
				return TabbrowserService.getIconForBookmark(aURI, aOnlyUserDefined);
			},
			setIcon : function(aURI, aIconURI)
			{
				TabbrowserService.setIconForBookmark(aURI, aIconURI);
			},
			edit : function(aID)
			{
				if (!aID || !this.isBookmarked(aID)) return;

				if (TabbrowserService.isNewTypeBrowser) // Phoenix/Firebird or Mozilla 1.5 or later
					window.openDialog('chrome://browser/content/bookmarks/bookmarksProperties.xul', '', 'centerscreen,chrome,resizable=no', aID);
				else
					window.openDialog('chrome://communicator/content/bookmarks/bm-props.xul', '', 'centerscreen,chrome,dialog=no,resizable=no,dependent', aID);
			},
			bookmarkTabGroup : function(aTab, aShouldBookmarkAllTabs)
			{
				TabbrowserService.bookmarkTabGroup(aTab, aShouldBookmarkAllTabs);
			}
		};
	},
 
	// j[ڂ̒ǉ 
	updateContextMenu : function(aTabBrowser)
	{
	try {
		var i;
		var mpopup = aTabBrowser.mTabContainer.previousSibling;


		/*
			1: name menuitems
			2: create "removeOther" item if it doesn't exist
			3: name menuseparators
			4: insert/append extra items and separators
		*/


		// 1: name menuitems
		var ds;
		try {
			ds = this.RDF.GetDataSourceBlocking('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		catch(ex) {
			ds = this.RDF.GetDataSource('chrome://tabextensions/content/tabsContextMenuItems.rdf');
		}
		if (!ds.GetAllResources().hasMoreElements()) {
			dump('ERROR: tabextensions fails to initialize tab\'s context menu.\n');
			return;
		}

		var label,
			res,
			id,
			namedItems = [];
		for (i = 0; i < mpopup.childNodes.length; i++)
		{
			label = mpopup.childNodes[i].getAttribute('label');
			if (!label) continue;

			res = ds.GetSource(
					this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Label'),
					this.RDF.GetLiteral(label),
					true
				);
			if (!res) continue;

			id = ds.GetTarget(
					res,
					this.RDF.GetResource('http://white.sakura.ne.jp/~piro/rdf#Id'),
					true
				);
			if (!id) continue;

			id = id.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;

			mpopup.childNodes[i].setAttribute('tabid', 'tab-item-'+id);
			namedItems[id] = mpopup.childNodes[i];
		}

		// 2: create "removeOther" and "bookmarkGroup" item
		if (!('removeOther' in namedItems)) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-remove']);
			this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_removeOther', null,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabsButInternal(b.mContextTab);',
					'tabid', 'tab-item-removeOther',
					'tbattr', 'tabbrowser-multiple'
				]
			);
		}
		if (!('bookmarkGroup' in namedItems)) {
			this.insertNewItemBefore(
				mpopup, 'menuitem',
				'label_bookmarkGroup', namedItems.reloadTab,
				[
					'oncommand', 'var b = this.parentNode.mTabBrowser; b.bookmarksManager.bookmarkTabGroup(b.mContextTab, !b.tabGroupsAvailable);',
					'tabid',     'tab-item-bookmarkGroup',
					'tbattr',    'tabbrowser-multiple',
					'accesskey', this.strbundle.GetStringFromName('label_bookmarkGroup_accesskey')
				]
			);
			this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems.reloadTab, ['tabid', 'tab-sep-bookmarkGroup']);
		}

		// 3: name menuseparators
		var separators = [
				'removeOther',   'remove',
				'newTab',        'new',
				'bookmarkGroup', 'bookmarkGroup',
				'removeTab',     'removeOneTab',
				'reloadAll',     'reload' // for old context menu
			];
		for (i = 0; i < separators.length; i += 2)
		{
			if (
				!(separators[i] in namedItems) ||
				!namedItems[separators[i]] ||
				!('nextSibling' in namedItems[separators[i]]) ||
				!namedItems[separators[i]].nextSibling ||
				namedItems[separators[i]].nextSibling.localName != 'menuseparator'
				)
				continue;

			namedItems[separators[i]].nextSibling.setAttribute('tabid', 'tab-sep-'+separators[i+1]);
		}

		if (namedItems['removeTab'].nextSibling) {
			// In old versions, Mozilla Firebird doesn't have "Close Other Tabs", so the item is generated and put after the "Close Tab".
			if (namedItems['removeTab'].nextSibling.getAttribute('tabid') == 'tab-item-removeOther')
				this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-removeOneTab']);
		}
		else if (namedItems['removeOther'].nextSibling.getAttribute('tabid') == 'tab-sep-remove') { // for new context menu of Mozilla Firebird (later 2003/8/8)
			// In this version, "Close Other Tabs" is previous to the "Close Tab" (a separator is in between them), and, "Close Other Tabs" is just next to the "Reload All".
			namedItems['removeOther'].nextSibling.setAttribute('tabid', 'tab-sep-removeOneTab');
			this.insertNewItemBefore(mpopup, 'menuseparator', null, namedItems['removeOther'], ['tabid', 'tab-sep-remove']);
		}



		// 4: insert/append extra items and separators

		var ref = mpopup.getElementsByAttribute('tabid', 'tab-sep-reload').length ? mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0] : null ;
		if (!ref) {
			this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-reload']);
		}

		// ^üړ
		// move tab to left/right
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveLeft', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, -1);',
				'tabid', 'tab-item-moveLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_moveRight', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.moveTabBy(b.mContextTab, 1);',
				'tabid', 'tab-item-moveRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-move']);

		// ^u̕
		// duplicate tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTab(b.mContextTab);',
				'tabid', 'tab-item-duplicateTab'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_duplicateTabInWindow', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.duplicateTabInWindow(b.mContextTab);',
				'tabid', 'tab-item-duplicateInWindow'
			]
		);

		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setFixedLabelFor', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.setFixedLabelFor(b.mContextTab);',
				'tabid', 'tab-item-setFixedLabelFor'
			]
		);

		// ^ǔŒ
		// lock tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleTabLocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTab'
			]
		);

		// t@̃ubN
		// block referrer from tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlocked', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlocked(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrer'
			]
		);

		// [h
		// auto-reload
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReload', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleTabAutoReload(b.mContextTab);',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreload'
			]
		);


		// ̑̋@\
		var advanced = this.insertNewItemBefore(mpopup, 'menu', 'label_allow', ref, ['tabid', 'tab-item-allow']);
		this.insertNewItemBefore(advanced, 'menupopup');
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowPlugins', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowPlugins\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowPlugins'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowJavascript', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowJavascript\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowJavascript'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowMetaRedirects', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowMetaRedirects\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowMetaRedirects'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowSubframes', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowSubframes\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowSubframes'
			]
		);
		this.insertNewItemBefore(
			advanced.firstChild, 'menuitem',
			'label_allowImages', null,
			[
				'oncommand', 'var b = this.parentNode.parentNode.parentNode.mTabBrowser; b.toggleDocShellPropertyFor(b.mContextTab, \'allowImages\');',
				'type', 'checkbox',
				'tabid', 'tab-item-allowImages'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-advanced']);


		// SẴ^uւ̑
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabLockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleAllTabsLocked();',
				'type', 'checkbox',
				'tabid', 'tab-item-lockTabAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleReferrerBlockedAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.toggleReferrerBlockedForAllTabs();',
				'type', 'checkbox',
				'tabid', 'tab-item-blockReferrerAll'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_toggleTabAutoReloadAll', ref,
			[
				'oncommand', 'this.parentNode.hidePopup(); var b = this.parentNode.mTabBrowser; b.toggleAllTabsAutoReload();',
				'type', 'checkbox',
				'tabid', 'tab-item-autoreloadAll'
			]
		);
		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-forAll']);


		// O[v
		// close group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeTabGroup', mpopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0].nextSibling,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeTabGroup(b.mContextTab);',
				'tabid', 'tab-item-removeTabGroup'
			]
		);

//		ref = mpopup.lastChild;
		ref = mpopup.getElementsByAttribute('tabid', 'tab-item-removeOther')[0];

		// /E
		// close left/right tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeLeft', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeLeftTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeLeft'
			]
		);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeRight', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeRightTabsFrom(b.mContextTab);',
				'tabid', 'tab-item-removeRight'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeLR']);

		// close all tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_removeAll', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.removeAllTabs();',
//				'tbattr', 'tabbrowser-multiple',
				'tabid', 'tab-item-removeAll'
			]
		);

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-removeAll']);


		ref = ref.nextSibling; // ReLXgj[łnull

		this.insertNewItemBefore(mpopup, 'menuseparator', null, ref, ['tabid', 'tab-sep-undo']);

		// u^uv蒼
		// undo close tab
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_undoRemoveTab', ref,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.undoRemoveTab();',
				'tabid', 'tab-item-undoRemoveTab'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-group']);

		// ^uׂ̕
		// sort tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_sortTabsByGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.sortTabsByGroup();',
				'tabid', 'tab-item-sortTabsByGroup'
			]
		);

		// O[ṽnCCg\
		// highlight group of tabs
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_highlightGroup', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.highlightGroupFromTab(b.mContextTab);',
				'tabid', 'tab-item-highlightGroup'
			]
		);

		// O[v̐Fݒ
		// set group color
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_setGroupColorFor', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.setGroupColorFor(b.mContextTab);',
				'tabid', 'tab-item-setGroupColorFor'
			]
		);


		// ubN}[N̕ҏW
		// edit bookmark from tab
		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-bookmark']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editBookmark', null,
			[
				'oncommand', 'var b = this.parentNode.mTabBrowser; b.editBookmarkFromTab(b.mContextTab);',
				'tabid', 'tab-item-editBookmark'
			]
		);


		this.insertNewItemBefore(mpopup, 'menuseparator', null, null, ['tabid', 'tab-sep-editmenu']);
		this.insertNewItemBefore(
			mpopup, 'menuitem',
			'label_editMenu', null,
			[
				'oncommand', 'this.parentNode.hidePopup(); window.openDialog(\'chrome://tabextensions/content/contextMenuEdit.xul\', \'\', \'chrome,modal,resizable=no\');',
				'tabid', 'tab-item-editMenu'
			]
		);
	}
	catch(ex){
		alert(ex);
	}
	},
	
	// ڂ̒ǉ 
	insertNewItemBefore : function(aMPopup, aLocalName, aLabelID, aRefNode, aAttrArray)
	{
		var newItem = document.createElementNS(this.XULNS, aLocalName);
		if (aRefNode)
			aMPopup.insertBefore(newItem, aRefNode)
		else
			aMPopup.appendChild(newItem);

		if (aLabelID)
			newItem.setAttribute('label', this.strbundle.GetStringFromName(aLabelID));
		if (aAttrArray)
			for (var i = 0; i < aAttrArray.length; i += 2)
				newItem.setAttribute(aAttrArray[i], aAttrArray[i+1]);

		return newItem;
	},
  
	// ^üړ 
	supportMovableTabs : function(aTabBrowser)
	{
		// initialize the order of tabs, "new tab" and "close tab" button.
		/* Content of tabs:
			Mozilla 1.1+
				<xul:stack/>
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>
			Netscape 7.0
				<xul:stack/>
				<children/>
				<xul:stack flex="1"/>
			Mozilla 1.0
				<xul:spacer class="tabs-left"/>
				<children/>
				<xul:stack flex="1"/>
			Phoenix/Firebird or Mozilla 1.5 or later
				<xul:hbox flex="1" style="min-width: 1px;">
					<children/> (<xul:tab/>)
					<xul:spacer class="tabs-right" flex="1"/>
				</xul:hbox>
				<xul:stack/>
		*/
		var anonyElem  = document.getAnonymousNodes(aTabBrowser.mTabContainer);
		for (i = 0; i < anonyElem.length; i++)
		{
			anonyElem[i].ordinal = i;
			if (anonyElem[i].localName == 'hbox') {
				aTabBrowser.mTabContainerInnerBox = anonyElem[i];
				anonyElem[i].firstChild.ordinal = 0;
				anonyElem[i].lastChild.ordinal = 9999999;
			}
		}
		anonyElem[anonyElem.length-1].ordinal = 9999999;
		if (!aTabBrowser.mTabContainerInnerBox)
			aTabBrowser.mTabContainerInnerBox = aTabBrowser.mTabContainer;

		aTabBrowser.mTabContainerInnerBox.setAttribute('tabs-scrollBox', true);


		// for Phoenix/Firebird or Mozilla 1.5 or later
		// hbvʒu}[J[̏
		// initialize the marker for indicating dropped position of tabs
		if (!aTabBrowser.mMarker &&
			aTabBrowser.mTabContainerInnerBox != aTabBrowser.mTabContainer) {
			document.addBinding(aTabBrowser.mTabContainerInnerBox, 'chrome://tabextensions/content/tabextensions.xml#dummy'); // first binding is ignored...why? This is a dummy to avoid this problem.
			window.setTimeout(
				function(aTabBrowser)
				{
					document.addBinding(aTabBrowser.mTabContainerInnerBox, 'chrome://tabextensions/content/tabextensions.xml#tabs-extra');
				},
				0,
				aTabBrowser
			);
		}


		var container = aTabBrowser.mTabContainer;
		var tabs = container.childNodes;
		for (var i = 0; i < tabs.length; i++)
		{
			aTabBrowser.mTabs.push(tabs[i]);
			tabs[i].ordinal = i;
		}
		// add properties and methods without XBL
		container.mTabBrowser        = aTabBrowser;
		container.advanceSelectedTab = this.advanceSelectedTab;


		// Add methods
		aTabBrowser.getDropPosition = this.getTabDropPosition;

		container.setAttribute('ondraggesture', 'nsDragAndDrop.startDrag(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragStart = this.onTabDragStart;

		container.setAttribute('ondragexit', 'nsDragAndDrop.dragExit(event, this.parentNode.parentNode.parentNode); event.stopPropagation();');
		aTabBrowser.onDragExit = this.onTabDragExit;

		aTabBrowser.__tabextensions__onDrop = aTabBrowser.onDrop;
		aTabBrowser.onDrop = this.onTabDrop;

		aTabBrowser.__tabextensions__onDragOver = aTabBrowser.onDragOver;
		aTabBrowser.onDragOver = this.onTabDragOver;

		aTabBrowser.__tabextensions__getSupportedFlavours = aTabBrowser.getSupportedFlavours;
		aTabBrowser.getSupportedFlavours = this.getTabsSupportedFlavours;
	},
 
	// tabs̃Abvf[g 
	updateTabContainer : function(aTabBrowser)
	{
		var container = aTabBrowser.mTabContainer;

//		container.advanceSelectedTab = this.advanceSelectedTab;

		// Behavior of tabs with middle-click or double click
		aTabBrowser.onTabClick = this.onTabClick;
		container.setAttribute('ondblclick', 'var b = this.parentNode.parentNode.parentNode; b.updateScrollbarFromEvent(event); if (event.button == 0) b.onTabClick(event, \'double\');');
		container.setAttribute('onclick', 'var b = this.parentNode.parentNode.parentNode; b.updateScrollbarFromEvent(event); if (event.button == 1 || (event.button == 0 && (event.ctrlKey || event.metaKey))) b.onTabClick(event, \'middle\'); else if (event.button == 3) b.onTabClick(event, \'4th\'); else if (event.button == 4) b.onTabClick(event, \'5th\');');
	},
  
	// ƎCxg̕ߑ 
	
	onTabbrowserWindowClose : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
	
	onTabbrowserWindowUnload : function(aEvent) 
	{
		var t = aEvent.originalTarget || aEvent.target;
		if (t) {
			var doc = t.ownerDocument || t;
			doc.tabbrowserReadyState = 'loading';
		}
	},
  
	onTabbarDragOver : function(aEvent) 
	{
		// browser crashes if the event is dispatched from sidebar panels and so on.
//		dump('DRAGOVER:'+aEvent.originalTarget.ownerDocument.defaultView.location.href+'\n');
		if (aEvent.originalTarget.ownerDocument.defaultView != window.top &&
			aEvent.originalTarget.ownerDocument.defaultView != _content)
			return;
		nsDragAndDrop.dragOver(aEvent, TabbrowserServiceTabbarDNDObserver);
	},
 
	onTabbarDrop : function(aEvent) 
	{
		if (aEvent.originalTarget.ownerDocument.defaultView != window.top &&
			aEvent.originalTarget.ownerDocument.defaultView != _content)
			return;
		nsDragAndDrop.drop(aEvent, TabbrowserServiceTabbarDNDObserver);
	},
 
	onXULTabbrowserTabLoading : function(aEvent) 
	{
		TabbrowserService.onTabLoading(aEvent.targetTab, aEvent.targetView, !aEvent.targetFollowFrames);
	},
 
	onXULTabbrowserTabLoad : function(aEvent) 
	{
		TabbrowserService.onTabLoadFinish(aEvent.targetView, aEvent.targetTab);
		if (TabbrowserService.shoulBackupTabs)
			TabbrowserService.saveTabAt(aEvent.targetTabIndex, TabbrowserService.tabsBackup);

		if (TabbrowserService.getPref('browser.tabs.extensions.tabs_width_type') == 1)
			TabbrowserService.browser.onTabsModified();
	},
 
	onXULTabbrowserTabAdded : function(aEvent) 
	{
		if (TabbrowserService.shoulBackupTabs)
			TabbrowserService.saveTabAt(aEvent.targetTabIndex, TabbrowserService.tabsBackup);
	},
 
	onXULTabbrowserTabRemoved : function(aEvent) 
	{
		// remove the entry from the history
		if (TabbrowserService.shoulBackupTabs) {
			var res = TabbrowserService.tabsBackup.getResource(aEvent.targetTabId);
			TabbrowserService.removeSHEntriesFrom(res, TabbrowserService.tabsBackup);
			TabbrowserService.tabsBackup.removeData(res);
		}
	},
 
	onXULTabbrowserTabReordered : function(aEvent) 
	{
		// move the entry for the tab
		if (TabbrowserService.shoulBackupTabs)
			TabbrowserService.tabsBackup.moveElementTo(aEvent.targetTabId, aEvent.targetTabIndex);
	},
 
	onXULTabbrowserTabGroupModified : function(aEvent) 
	{
		if (TabbrowserService.shoulBackupTabs)
			TabbrowserService.saveTabAt(aEvent.targetTabIndex, TabbrowserService.tabsBackup);
	},
 
	onXULTabbrowserTabStatusChange : function(aEvent) 
	{
		if (
			aEvent.targetURI != 'ANY' &&
			(
				TabbrowserService.shouldSaveBookmarksStatus ||
				aEvent.targetStatus == 'fixedLabel'
			)
			)
			TabbrowserService.saveBookmarkStatus(aEvent.target, aEvent.targetTab, aEvent.targetStatus);
	},
 
	onXULTabbrowserTabDrop : function(aEvent) 
	{
		TabbrowserService.onTabDropInternal(aEvent);
	},
 
	onXULTabbrowserURIDrop : function(aEvent) 
	{
		// Make dragged links visited
		var links = TabbrowserService.getSelectionLinks();
		if (links.length == 1 &&
			links[0].uri == aEvent.targetURI)
			TabbrowserService.makeLinkVisited(links[0].uri, links[0].node);
	},
 
	onXULTabbrowserAddTabCanceled : function(aEvent) 
	{
		var TS = TabbrowserService;
		var useOverflow = (TS.getPref('browser.tabs.extensions.limit.overflow') && TS.winHookMode != 2);

		if (!useOverflow) {
			window.defaultStatus = TS.strbundle.GetStringFromName('status_tabs_rejected');
			return;
		}
		else {
			// ɃuEUEBhEꍇAɃ^uJ
			// If navigator windows exists, open tab there.
			var referrer = aEvent.targetReferrerURI ? TS.makeURIFromSpec(aEvent.targetReferrerURI) : null ;
			var max = TS.getPref('browser.tabs.extensions.limit.number');

			var info,
				b = TS.browserWindows;
			for (var i = 0; i < b.length; i++)
			{
				if (b[i].TabbrowserService.browser &&
					b[i].TabbrowserService.browser.mTabs &&
					b[i].TabbrowserService.browser.mTabs.length < max &&
					b[i] != window) {
					b[i].focus();
					return b[i].TabbrowserService.browser.addTabInternal(
						aEvent.targetURI,
						referrer,
						aEvent.targetTabInfo
					);
				}
			}

			// ɃuEUEBhEȂA邢́ÃEBhESĐς܂Ń^uJĂꍇAVKɃEBhEJ
			// If other navigators have fully tabs, then open new navigator window.
//dump('over:'+aURI+'\n');
			TS.overflowingTabsManager.addTab(
				aEvent.targetURI,
				referrer,
				aEvent.targetTabInfo
			);
		}
	},
 
	// edit the global "undo close tab" cache when the cache in this window has been modified 
	onXULTabbrowserUndoCacheModified : function(aEvent)
	{
		if (!aEvent.targetTabInfo) return;

		if (aEvent.type == 'XULTabbrowserUndoCacheAdded') {
			window.gTSGlobalUndoRemoveTabCache.push(aEvent.targetTabInfo);

			var max = Math.max(TabbrowserService.getPref('browser.tabs.extensions.undo_cache'), 0);
			var global_max = max * (TabbrowserService.browserWindows.length+1);

			if (window.gTSGlobalUndoRemoveTabCache.length <= global_max)
				return;

			window.gTSGlobalUndoRemoveTabCache.splice(0, window.gTSGlobalUndoRemoveTabCache.length-global_max);
		}
		else {
			for (var i in window.gTSGlobalUndoRemoveTabCache)
				if (window.gTSGlobalUndoRemoveTabCache[i] &&
					window.gTSGlobalUndoRemoveTabCache[i].id == aEvent.targetTabInfo.id) {
					window.gTSGlobalUndoRemoveTabCache.splice(i, 1);
					break;
				}
		}
	},
 
	onMouseEvent : function(aEvent) 
	{
		(aEvent.originalTarget.ownerDocument ? aEvent.originalTarget.ownerDocument : aEvent.originalTarget ).defaultView.tabbrowserLastEvent = (new Date()).getTime();
//		TabbrowserService.stopEvent(aEvent);
	},
  
	addPrefListener : function(aObserver) 
	{
		var domains = ('domains' in aObserver) ? aObserver.domains : [aObserver.domain] ;
		try {
			var pbi = this.Prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			for (var i = 0; i < domains.length; i++)
				pbi.addObserver(domains[i], aObserver, false);
		}
		catch(e) {
		}
	},
 
	removePrefListener : function(aObserver) 
	{
		var domains = ('domains' in aObserver) ? aObserver.domains : [aObserver.domain] ;
		try {
			var pbi = this.Prefs.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
			for (var i = 0; i < domains.length; i++)
				pbi.removeObserver(domains[i], aObserver, false);
		}
		catch(e) {
		}
	},
	
	// replace "window.open" and other functions to custom versions. 
	onTabLoading : function(aRelatedTab, aWindow, aShouldNotFollowFrames)
	{
		if (aWindow == aWindow.top &&
			!('__tabextensions__initialized' in aWindow)) {
			// ACRw肳ĂꍇÃACRD悷B
			// URIACRw肳ꂽubN}[NURI艺ʂ̃fBNgłȂꍇAACRZbgB
			var icon = this.getIconForBookmark(aRelatedTab.mTabInfo.loadingURI, true);
			if (icon) {
				window.setTimeout(
					function(aTab, aURI)
					{
						aTab.setAttribute('image', aURI);
						// y[WJ_ŃACȐ񂪏㏑Ă܂Ă̂ŁAēx㏑
					},
					0,
					aRelatedTab, icon
				);
				this.setIconForBookmark(aRelatedTab.mTabInfo.loadingURI);
			}
		}

		if ('frames' in aWindow && !aShouldNotFollowFrames) {
			for (var i = 0; i < aWindow.frames.length; i++)
				this.onTabLoading(aRelatedTab, aWindow.frames[i]);
		}

		if ('__tabextensions__initialized' in aWindow || !aWindow.open) return;

		// override "window.open"
		if (!('__tabextensions__open' in aWindow.Window.prototype)) {
			aWindow.Window.prototype.__tabextensions__open = aWindow.Window.prototype.open;
		}
		aWindow.eval('Window.prototype.open = '+this.newWindowOpen.toSource());

		if (!('__tabextensions__setTimeout' in aWindow.Window.prototype)) {
			aWindow.Window.prototype.__tabextensions__setTimeout = aWindow.Window.prototype.setTimeout;
		}
		aWindow.eval('Window.prototype.setTimeout = '+this.newWindowSetTimeout.toSource());
		aWindow.eval('Window.prototype.setInterval = '+this.newWindowSetInterval.toSource());

		aWindow.openBrowserTab       = this.openBrowserTab;
		aWindow.shouldOpenBrowserTab = this.shouldOpenBrowserTab;

/*
		if (aRelatedTab.mTabInfo.openedAutomatically) {
			aWindow.resizeTo = function() {};
			aWindow.resizeBy = function() {};
			aWindow.moveBy   = function() {};
			aWindow.moveTo   = function() {};
		}
*/

		aWindow.tabbrowserLastEvent = (new Date()).getTime();
		aWindow.lastTimeoutIsAfterLoaded = true;

		aWindow.__tabextensions__initialized = true;
	},

	onTabLoadFinish : function(aWindow, aRelatedTab)
	{
		if ('frames' in aWindow) {
			for (var i = 0; i < aWindow.frames.length; i++)
				this.onTabLoadFinish(aWindow.frames[i], aRelatedTab);
		}

		if (!('__tabextensions__initialized' in aWindow))
			this.onTabLoading(aRelatedTab, aWindow, true);
	},
  
	loadDefaultPrefs : function() 
	{
		const DIR = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
		var dir = DIR.get('UChrm', Components.interfaces.nsILocalFile);

		var tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
		tempLocalFile.initWithPath(dir.path);

		var uri;
		try {
			uri = this.IOService.newFileURI(tempLocalFile).spec;
		}
		catch(e) { // [[interchangeability for Mozilla 1.1]]
			uri = this.IOService.getURLSpecFromFile(tempLocalFile);
		}

		if (!uri.match(/\/$/)) uri += '/';
		uri += 'tabextensions.js';

		try {
			var fileHandler = this.IOService.getProtocolHandler('file').QueryInterface(Components.interfaces.nsIFileProtocolHandler);
			tempLocalFile = fileHandler.getFileFromURLSpec(uri);
		}
		catch(e) { // [[interchangeability for Mozilla 1.1]]
			try {
				tempLocalFile = this.IOService.getFileFromURLSpec(uri);
			}
			catch(ex) { // [[interchangeability for Mozilla 1.0.x]]
				tempLocalFile = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
				this.IOService.initFileFromURLSpec(tempLocalFile, uri);
			}
		}

		if (!tempLocalFile.exists()) return;


		var defPref = '';

		var stream = Components.classes['@mozilla.org/network/file-input-stream;1'].createInstance(Components.interfaces.nsIFileInputStream);
		try {
			stream.init(tempLocalFile, 1, 0, false); // open as "read only"

			var scriptableStream = Components.classes['@mozilla.org/scriptableinputstream;1'].createInstance(Components.interfaces.nsIScriptableInputStream);
			scriptableStream.init(stream);

			var fileSize = scriptableStream.available();
			var fileContents = scriptableStream.read(fileSize);

			scriptableStream.close();
			stream.close();

			defPref = fileContents;
		}
		catch(e) {
			return;
		}

		var prefs = [];

		const DEFPrefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getDefaultBranch(null);
		function pref(aPrefstring, aValue) {
			switch (typeof aValue)
			{
				case 'string':
					var string = ('@mozilla.org/supports-wstring;1' in Components.classes) ?
							Components.classes['@mozilla.org/supports-wstring;1'].createInstance(this.knsISupportsString) :
							Components.classes['@mozilla.org/supports-string;1'].createInstance(this.knsISupportsString);
					string.data = aValue ;
					DEFPrefs.setComplexValue(aPrefstring, this.knsISupportsString, string);
					break;
				case 'number':
					DEFPrefs.setIntPref(aPrefstring, parseInt(aValue));
					break;
				default:
					DEFPrefs.setBoolPref(aPrefstring, aValue);
					break;
			}
			prefs.push(aPrefstring);
		}

		eval(defPref);

		var nullPointer;
		for (var i in prefs)
			nullPointer = this.getPref(prefs[i]);
	},
  
	// \bh̒u 
	// replace existing methods
	
	// tabbrowser 
	
	getBrowserForTab : function(aTab) 
	{
		if (aTab.localName == 'tabs') aTab = this.mCurrentTab;

		if (aTab == this.mCurrentTab)
			return this.mCurrentBrowser;

		var t = this.mTabContainer.childNodes;
		var b = this.mPanelContainer.childNodes;
		for (var i = 0; i < t.length; i++)
			if (aTab == t[i]) return b[i];

		return null;
	},
 
	// |bvAbvj[̍XV 
	updatePopupMenu : function(aPopup, aEvent)
	{
		// if the popup is a submenu, return
		if (aEvent.originalTarget != aPopup) return;

		var tab         = document.popupNode || this.mCurrentTab;
		if (tab.localName != 'tab') tab = this.mCurrentTab;

		var b           = tab.mBrowser;

		var tabs        = this.mTabs;
		var index       = Number(tab.ordinal);
		var OnRightEdge = (index == tabs.length-1);
		var OnLeftEdge  = (index == 0);

		var isGroupMode = this.tabGroupsAvailable;
		var isSingleWindow = this.mWinHookMode == 2;

		var item;
		var count;
		var i;


		item = aPopup.getElementsByAttribute('tabid', 'tab-item-lockTab')[0];
		item.setAttribute('checked', tab.getAttribute('tab-locked'));
		item.setAttribute('hidden', this.mPrefs.getBoolPref('browser.tabs.opentabfor.anylink') ? true : false );
		item = aPopup.getElementsByAttribute('tabid', 'tab-item-lockTabAll')[0];
		item.setAttribute('checked', tab.getAttribute('tab-locked'));
		item.setAttribute('hidden', tabs.length == 1);
/*
		if (tabs.length > 1) {
			count = 0;
			for (i in tabs) if (tabs[i].getAttribute('tab-locked')) count++;
			item.setAttribute('checkbox-mixed', count != tabs.length);
		}
*/

		aPopup.getElementsByAttribute('tabid', 'tab-item-blockReferrer')[0]
			.setAttribute('checked', tab.getAttribute('tab-referrerblocked'));
		item = aPopup.getElementsByAttribute('tabid', 'tab-item-blockReferrerAll')[0];
		item.setAttribute('checked', tab.getAttribute('tab-referrerblocked'));
		item.setAttribute('hidden', tabs.length == 1);
/*
		if (tabs.length > 1) {
			count = 0;
			for (i in tabs) if (tabs[i].getAttribute('tab-referrerblocked')) count++;
			item.setAttribute('checkbox-mixed', count != tabs.length);
		}
*/

		aPopup.getElementsByAttribute('tabid', 'tab-item-duplicateInWindow')[0]
			.setAttribute('hidden', isSingleWindow);
		aPopup.getElementsByAttribute('tabid', 'tab-item-duplicateTab')[0]
			.setAttribute('hidden', this.mPrefs.getBoolPref('browser.tabs.extensions.prevent_same_uri_tab') || false);

		aPopup.getElementsByAttribute('tabid', 'tab-item-autoreload')[0]
			.setAttribute('checked', tab.getAttribute('tab-autoreload'));
		item = aPopup.getElementsByAttribute('tabid', 'tab-item-autoreloadAll')[0];
		item.setAttribute('checked', tab.getAttribute('tab-autoreload'));
		item.setAttribute('hidden', tabs.length == 1);
/*
		if (tabs.length > 1) {
			count = 0;
			for (i in tabs) if (tabs[i].getAttribute('tab-autoreload')) count++;
			item.setAttribute('checkbox-mixed', count != tabs.length);
		}
*/

		aPopup.getElementsByAttribute('tabid', 'tab-item-removeRight')[0]
			.setAttribute('hidden', OnRightEdge);
		aPopup.getElementsByAttribute('tabid', 'tab-item-removeLeft')[0]
			.setAttribute('hidden', OnLeftEdge);

		aPopup.getElementsByAttribute('tabid', 'tab-item-moveRight')[0]
			.setAttribute('hidden', OnRightEdge);
		aPopup.getElementsByAttribute('tabid', 'tab-item-moveLeft')[0]
			.setAttribute('hidden', OnLeftEdge);


		var undoRemoveTab = aPopup.getElementsByAttribute('tabid', 'tab-item-moveLeft')[0];
		undoRemoveTab.setAttribute('hidden', this.mUndoRemoveTabCache == 0);
		undoRemoveTab.setAttribute('disabled', !this.mRemovedTabInfoList.length);

		aPopup.getElementsByAttribute('tabid', 'tab-item-removeTabGroup')[0]
			.setAttribute('hidden', !isGroupMode);

 		aPopup.getElementsByAttribute('tabid', 'tab-item-editBookmark')[0]
			.setAttribute('hidden', (this.bookmarksManager ? !this.bookmarksManager.isBookmarked(tab.mTabInfo.bookmarkID) : true ));

		aPopup.getElementsByAttribute('tabid', 'tab-item-sortTabsByGroup')[0]
			.setAttribute('hidden', !isGroupMode);
		aPopup.getElementsByAttribute('tabid', 'tab-item-sortTabsByGroup')[0]
			.setAttribute('disabled', tabs.length == 1);
		aPopup.getElementsByAttribute('tabid', 'tab-item-highlightGroup')[0]
			.setAttribute('hidden', !isGroupMode);
//		aPopup.getElementsByAttribute('tabid', 'tab-item-setGroupColorFor')[0]
//			.setAttribute('hidden', !isGroupMode);

		// advanced
		aPopup.getElementsByAttribute('tabid', 'tab-item-allowPlugins')[0]
			.setAttribute('checked', b.docShell.allowPlugins);
		aPopup.getElementsByAttribute('tabid', 'tab-item-allowJavascript')[0]
			.setAttribute('checked', b.docShell.allowJavascript);
		aPopup.getElementsByAttribute('tabid', 'tab-item-allowMetaRedirects')[0]
			.setAttribute('checked', b.docShell.allowMetaRedirects);
		aPopup.getElementsByAttribute('tabid', 'tab-item-allowSubframes')[0]
			.setAttribute('checked', b.docShell.allowSubframes);
		aPopup.getElementsByAttribute('tabid', 'tab-item-allowImages')[0]
			.setAttribute('checked', b.docShell.allowImages);


		this.__tabextensions__updatePopupMenu(aPopup);


		var unloadable = (this.mPrefs.getIntPref('browser.tabs.extensions.last_tab_closing') == 1);
		aPopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0]
			.setAttribute('disabled', !unloadable && tabs.length == 1);
		aPopup.getElementsByAttribute('tabid', 'tab-item-bookmarkGroup')[0]
			.setAttribute('disabled', !(tab.parentTab || tab.childTabs.length || !this.tabGroupsAvailable));
//		aPopup.getElementsByAttribute('tabid', 'tab-item-removeTab')[0]
//			.setAttribute('hidden', !unloadable && tabs.length == 1);
		aPopup.getElementsByAttribute('tabid', 'tab-item-removeTabGroup')[0]
			.setAttribute('disabled', !tab.childTabs.length || (!unloadable && tabs.length == 1));
		aPopup.getElementsByAttribute('tabid', 'tab-item-editMenu')[0]
			.setAttribute('hidden', document.popupNode.localName == 'tab');

		this.showHidePopupMenuItems(aPopup);
	},
 
	// ACR̎擾 
	buildFavIconString : function(aURI)
	{
		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;
		return icon || this.__tabextensions__buildFavIconString(aURI) ;
	},

	loadFavIcon : function(aURI, aAttr, aNode)
	{
		this.__tabextensions__loadFavIcon(aURI, aAttr, aNode);

		var icon = this.bookmarksManager ? this.bookmarksManager.getIcon(aURI.spec, true) : null ;

		if (icon) {
			window.setTimeout(
				function(aNode, aAttr, aURI)
				{
					aNode.setAttribute(aAttr, aURI);
				},
				0,
				aNode, aAttr, icon
			);
			this.bookmarksManager.setIcon(aURI.spec);
		}
	},
 
	addTab : function(aURI, aReferrerURI) 
	{
		return this.addTabInternal(aURI, aReferrerURI);
	},
	
	/*
		𒴂̃^uVEBhEŊJ߂̃IuWFNgB
		nꂽURIۑĂAVEBhEŃy[Wǂݍޏł̂҂ĂACɃ^uœǂݍށB

		If too many URIs are handled to "addTab", then it handle them to this object.
		This object stores those URIs/referrers, opens a new browser window, and, starts to load each URI after getting ready the browser.
	*/
	overflowingTabsManager : 
	{
		shouldOpenedInfo : [],
		timer            : null,
		active           : false,
		shouldLoadURI    : false,

		addTab : function(aURI, aReferrerURI, aInfo)
		{
			aInfo.uri      = aURI;
			aInfo.referrer = aReferrerURI || null ;
			this.shouldOpenedInfo.push(aInfo);
//dump('add:'+this.shouldOpenedInfo[this.shouldOpenedInfo.length-1].uri+'\n');

			if (this.active) return;

			var w = window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', 'about:blank');
			this.souldLoadURI = true;
			this.timer = window.setInterval(this.pourTabsTo, 200, w);
			this.active = true;
		},

		pourTabsTo : function(aWindow)
		{
			var manager = TabbrowserService.overflowingTabsManager;

			// 1: If all of overflowed tabs are opened, timer is cleared.
			// 2: If the window for overflowed tabs is closed, we have to clear timer.
			if (!manager.shouldOpenedInfo.length ||
				(aWindow && ('closed' in aWindow && aWindow.closed))) {
				manager.stop();
				return;
			}

			if (!('TabbrowserService' in aWindow) ||
				!aWindow.TabbrowserService.initialized ||
				!aWindow.TabbrowserService.isBrowserWindow) return;

			var info = manager.shouldOpenedInfo[0];
			manager.shouldOpenedInfo.splice(0, 1);

			if (!info || !info.uri || !info.uri.toString()) return;


			// first tab is loaded with "loadURI"
			aWindow.TabbrowserService.browser.loadURI(info.uri, info.referrer);
			var t = aWindow.TabbrowserService.browser.mCurrentTab;
			aWindow.TabbrowserService.browser.initTabWithTabInfo(t, info);
			t.mTabInfo.loadingURI = info.uri;
			manager.shouldLoadURI = false;

			var handedInfo;
			while (manager.shouldOpenedInfo.length)
			{
				info = manager.shouldOpenedInfo[0];
				manager.shouldOpenedInfo.splice(0, 1);
				if (!info || !info.uri || !info.uri.toString()) continue;

				info.parentTab = ('parentTab' in info && info.parentTab) ? t : null ;

				aWindow.TabbrowserService.browser.addTabInternal(
					info.uri,
					info.referrer,
					info
				);
			}

			manager.stop();
		},

		stop : function()
		{
			window.clearInterval(this.timer);
			this.shouldOpenedInfo = [];
			this.active           = false;
			this.souldLoadURI     = false;
		}
	},
  
	removeTab : function(aTab) 
	{
		this.removeTabInternal(aTab);
	},
 
	// ^ũtH[JXړ 
/*	// Focus a tab by an order
	advanceSelectedTab : function(aDir)
	{
		var startTab   = this.selectedItem;
		var tabs       = this.parentNode.parentNode.parentNode.mTabs;

		var next = tabs[Number(startTab.ordinal)+aDir];

		while (next != startTab && (!next || next.getAttribute('hidden')))
		{
			if (next && next.getAttribute('hidden'))
				next = tabs[Number(next.ordinal)+aDir];
			if (!next)
				next = (aDir > 0) ? tabs[0] : tabs[tabs.length-1];
		}

		if (next && next != startTab) {
			this.selectedItem = next;
			next.focus();
			document.commandDispatcher.advanceFocusIntoSubtree(next);
		}
	},*/
 
	// ^uD&D 
	// drag and drop of tabs
	
	// onDragStart 
	onTabDragStart : function(aEvent, aTransferData, aDragAction)
	{
		this.updateScrollbarFromEvent(aEvent);

		var tab = this.getTabFromChild(aEvent.originalTarget);

		// dragging tabbar
		if (!tab) {
			if (!aEvent.originalTarget.localName.match(/^(scrollbar(button)?|slider|thumb)$/)) {
				if (!this.mPrefs.getBoolPref('browser.tabs.extensions.show_tabs_in_bottom.onDrag') ||
					navigator.platform.indexOf('Linux') > -1)
					return;

				this.setAttribute('tabbar-moving', true);

				aTransferData.data = new TransferData();
				aTransferData.data.addDataForFlavour('tabbrowser/tabbar', '[tab-bar]');
			}
			return;
		}

		this.mDraggedTab = tab;

		var uri = tab.mBrowser.currentURI.spec;

		aTransferData.data = new TransferData();
		aTransferData.data.addDataForFlavour('tabbrowser/tab',
			'order='+tab.ordinal+'\n'+ // current order of the tab.
			'dragId='+tab.tabId+'\n'+ // browser ID. If tab is dropped to other window, the browser opens new tab.
			'uri='+uri);

		aTransferData.data.addDataForFlavour('text/x-moz-url', uri+'\n'+(tab.mTabInfo.fixedLabel || tab.label));
		aTransferData.data.addDataForFlavour('text/html', '<a href="'+uri+'">'+tab.label+'</a>');
		aTransferData.data.addDataForFlavour('text/unicode', uri);
	},
 
	// onDrop 
	onTabDrop : function(aEvent, aTransferData, aSession)
	{
		var event;
		if (aTransferData.flavour.contentType == 'text/x-moz-url') {
			event = document.createEvent('Events');
			event.initEvent('XULTabbrowserURIDrop', false, true);
			event.targetURI = aTransferData.data.split('\n')[0];
			this.dispatchEvent(event);
		}

		if (aTransferData.flavour.contentType != 'tabbrowser/tab') {
			this.__tabextensions__onDrop(aEvent, aTransferData, aSession);
			return;
		}

		if (this.mMarker) {
			this.mMarker.setAttribute('hidden', 'true');
			this.mMarker.mTarget = null;
		}

		var toTab   = aEvent.target,
			fromTab = this.mDraggedTab,
			data    = aTransferData.data.split('\n'),
//			order   = data[0].match(/\d+$/)[0],
			dragId  = data[1].match(/[^=]+$/)[0],
			uri     = data[2].replace(/^uri=/, '');

		// ^ũhbvʒu𒲂ׂ
		// get the dropped position of the tab
		var pos = this.getDropPosition(aEvent);
		if (pos == this.DROP_ON_MARKER) {
			toTab = this.mMarker.mTarget;
			if (toTab.ordinal == this.mMarker.ordinal)
				pos = this.DROP_BEFORE;
			else
				pos = this.DROP_AFTER;
		}

		var toIndex;
		if (toTab.localName == 'tab') {
			toIndex = Number(toTab.ordinal);
		}
		else {
			var box = this.mTabs[this.mTabs.length-1].boxObject;
			if (aEvent.screenX >= box.screenX+box.width) {
				toIndex = this.mTabs.length-1;
				pos = this.DROP_AFTER;
			}
			else {
				toIndex = 0;
				pos = this.DROP_BEFORE;
			}
		}

		if (!toTab.localName != 'tab') toTab = this.mTabs[toIndex];


		event = document.createEvent('Events');
		event.initEvent('XULTabbrowserTabDrop', false, true);
		event.targetURI          = uri;
		event.targetFromTab      = fromTab;
		event.targetFromID       = dragId;
		event.targetToTab        = toTab;
		event.targetToIndex      = toIndex;
		event.targetDropPosition = pos;

		event.originalShiftKey   = aEvent.shiftKey;
		event.originalAltKey     = aEvent.altKey;
		event.originalMetaKey    = aEvent.metaKey;
		event.originalCtrlKey    = aEvent.ctrlKey;
		event.targetDropTarget   = aEvent.target;
		event.targetDropOriginalTarget = 'originalTtarget' in aEvent ? aEvent.originalTtarget : null ;
		this.dispatchEvent(event);

		this.mDraggedTab = null;
	},
	
	onTabDropInternal : function(aEvent) 
	{
		var fromTab = aEvent.targetFromTab,
			fromId  = aEvent.targetFromID,
			toTab   = aEvent.targetToTab,
			toIndex = aEvent.targetToIndex,
			uri     = aEvent.targetURI,
			pos     = aEvent.targetDropPosition,
			i;

		var b = aEvent.target; // tabbrowser

		// When the tab is dragged from another window...
		if (!fromTab || fromTab.tabId != fromId) {

			// when dropped to an existing tab
			if (pos == b.DROP_ON &&
				toTab.mTabInfo.loadingURI &&
				toTab.mTabInfo.loadingURI != 'about:blank' &&
				aEvent.targetDropTarget.localName == 'tab' &&
				(!b.tabGroupsAvailable || aEvent.originalShiftKey)) {
				toTab.mBrowser.loadURI(uri);
				return;
			}

			if (this.getPref('browser.tabs.extensions.dragdrop.only_load_uri')) { // old implementation
				fromTab = b.addTab(uri);
			}
			else {
				var w = this.browserWindows;
				var browser, tab;
				for (i in w) // find the window the tab is dragged from
				{
					browser = w[i].TabbrowserService.browser;
					tab     = browser.getTabByTabId(fromId);
					if (tab) break;
				}
				if (tab) {
					var info = browser.getTabInfo(tab);
					browser.removeTabInternal(tab, 'preventUndo=yes');
					fromTab = b.addTabWithTabInfo(info);
				}
				else
					fromTab = b.addTab(uri);
			}

			// if the tab is dropped to the blank tab, remove it
			if (
				pos == b.DROP_ON ||
				b.mTabs.length < 3 // if there was only one tab since the tab was dropped
				) {
				var targetTab = (b.mTabs.length < 3) ? b.mTabs[0] : toTab ;
				if (targetTab.isReallyBlank) {
					b.removeTabInternal(targetTab, 'preventUndo=yes');
					if (toTab == targetTab) toTab = null;
				}
			}
		}

		// O[vւ̒ǉ insert to the group
		var isSimpleEdit = this.getPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		if (toTab &&
			pos == b.DROP_ON &&
			(
				b.tabGroupsAvailable &&
				(
					aEvent.originalCtrlKey ||
					aEvent.originalMetaKey ||
					(
						!aEvent.originalCtrlKey &&
						!aEvent.originalMetaKey &&
						isSimpleEdit
					)
				)
			)) {
			b.moveTabToGroupEdge(fromTab, toTab);
			fromTab.parentTab = toTab;
		}
		else {
			if (toIndex > Number(fromTab.ordinal))
				toIndex += (pos < 0 ? -1 : 0 );
			else if (!isSimpleEdit || toIndex < Number(fromTab.ordinal))
				toIndex += (pos > 0 ? 1 : 0 );

			if (toIndex >= 0 && toIndex < b.mTabs.length)
				b.moveTabTo(fromTab, toIndex);


			// ^uȊȌꏊɃhbvꍇAO[v𔲂
			// if the tab is dropped from groups, detach it from the group.
			if (aEvent.targetDropTarget.localName != 'tab' &&
				fromTab.parentTab &&
				(
					!aEvent.targetDropOriginalTarget ||
					aEvent.targetDropOriginalTarget != b.mMarker
				)
				) {
				fromTab.parentTab = null;

				// q̃^u^ủEɍĔzu
				// move child tabs to right of the tab
				var tabs = b.gatherChildTabsOf(fromTab);
				for (i in tabs)
					b.moveTabTo(tabs[i], Number(fromTab.ordinal)+1);
			}
		}
	},
  
	// onDragOver 
	onTabDragOver : function(aEvent, aFlavour, aSession)
	{
		this.updateScrollbarFromEvent(aEvent);

		this.__tabextensions__onDragOver(aEvent, aFlavour, aSession);

		var XferDataSet = nsTransferable.get(
				this.getSupportedFlavours(),
				nsDragAndDrop.getDragData,
				true
			);
		var XferData = XferDataSet.first.first;
		if (XferData.flavour.contentType == 'tabbrowser/tabbar') {
			var current = aEvent.originalTarget;
			while (current.parentNode &&
					current != this.mTabContainer &&
					current != this)
				current = current.parentNode;

			if (current == this.mTabContainer)
				this.setAttribute('tabbar-moving', true);

			return;
		}
		else if (XferData.flavour.contentType != 'tabbrowser/tab') return;


		// auto scroll
		if (this.mScrollbar) {
			var cx       = aEvent.clientX;
			var boxWidth = this.mTabContainerInnerBox.boxObject.width;
			var wait     = 80;
			if (cx > 0 && cx < 40) {
				if (cx < 10)
					wait = 10;
				else if (cx < 25)
					wait = 40;
				this.scrollTabbarBy(-10, wait);
			}
			else if (cx > boxWidth-40 && cx < boxWidth) {
				if (cx > boxWidth-10)
					wait = 10;
				else if (cx > boxWidth-25)
					wait = 40;
				this.scrollTabbarBy(10, wait);
			}
		}


		// if dragged on the marker, do nothing
		if (aEvent.originalTarget &&
			aEvent.originalTarget == this.mMarker) return;

		this.mCurrentDragOverTab = (aEvent.target.localName == 'tab') ? aEvent.target : null ;
		if (!this.mCurrentDragOverTab) return;

		var tab = this.mCurrentDragOverTab;


		// hbOJn^ȕł͕\ςȂ
		// Ignore the tab dragged from.
		if (this.mDraggedTab == aEvent.target) {
			if (this.mMarker) {
				this.mMarker.setAttribute('hidden', 'true');
				this.mMarker.mTarget = null;
			}
			tab.removeAttribute('dragover-at');
			return;
		}


		// rightleft̔
		// Which is the position the tab dropped, left or right?
		var pos = this.getDropPosition(aEvent);
//		dump('drop position: '+pos+'\n');
		if (pos == this.DROP_BEFORE) {
			if (this.mMarker) {
				this.mMarker.setAttribute('ordinal', Number(tab.ordinal));
				this.mMarker.removeAttribute('hidden');
				this.mMarker.mTarget = tab;
				tab.removeAttribute('dragover-at');
			}
			else {
				tab.setAttribute('dragover-at', 'before');
			}
		}
		else if (pos == this.DROP_AFTER) {
			if (this.mMarker) {
				this.mMarker.setAttribute('ordinal', Number(tab.ordinal)+1);
				this.mMarker.removeAttribute('hidden');
				this.mMarker.mTarget = this.mTabs[Number(tab.ordinal)+1];
				tab.removeAttribute('dragover-at');
			}
			else {
				tab.setAttribute('dragover-at', 'after');
			}
		}
		else {
			if (this.mDraggedTab &&
				!this.canAttachTabTo(this.mDraggedTab, tab)) {
				aSession.canDrop = false;
			}
			if (this.mMarker) {
				this.mMarker.setAttribute('hidden', 'true');
				this.mMarker.mTarget = null;
			}

			tab.setAttribute('dragover-at', 'this');
		}
	},

	getTabDropPosition : function(aEvent)
	{
		var isSimpleEdit = false;
		try {
			isSimpleEdit = this.mPrefs.getBoolPref('browser.tabs.extensions.group.edit_simple_dragdrop');
		}
		catch(e) {
		}

		var box = aEvent.target.boxObject.QueryInterface(Components.interfaces.nsIBoxObject);
		var regionCount = (
					this.tabGroupsAvailable &&
					(
						aEvent.ctrlKey ||
						aEvent.metaKey ||
						(
							!aEvent.ctrlKey &&
							!aEvent.metaKey &&
							isSimpleEdit
						)
					)
				) ? 3 : 2 ;
		// This is a number of position. "2" is "Left/Right", "3" is "Left/Middle/Right".

		var measure          = (box.width / regionCount),
			coordValue       = box.x,
			clientCoordValue = aEvent.clientX;

		if (this.mScrollbar) // see "updateScrollbarFromEvent" in tabextensions.xml
			coordValue -= Number(this.mScrollbar.getAttribute('curpos'));

		// if dragged on the marker...
		if (aEvent.originalTarget &&
			aEvent.originalTarget == this.mMarker)
			return this.DROP_ON_MARKER;
		else if (clientCoordValue < (coordValue + measure))
			return this.DROP_BEFORE;
		else if (!this.tabGroupsAvailable ||
				clientCoordValue >= (coordValue + (regionCount-1)*measure))
			return this.DROP_AFTER;
		else
			return this.DROP_ON;
	},
 
	// onDragExit 
	onTabDragExit : function(aEvent, aSession)
	{
		var XferDataSet = nsTransferable.get(
				this.getSupportedFlavours(),
				nsDragAndDrop.getDragData,
				true
			);
		var XferData = XferDataSet.first.first;
		if (XferData.flavour.contentType == 'tabbrowser/tabbar') {
			this.removeAttribute('tabbar-moving');
			return;
		}
		else if (XferData.flavour.contentType != 'tabbrowser/tab') return;

		if (this.mMarker) {
			this.mMarker.setAttribute('hidden', 'true');
			this.mMarker.mTarget = null;
		}
		if (this.mCurrentDragOverTab)
			this.mCurrentDragOverTab.removeAttribute('dragover-at');
	},
 
	// Supported Flavours 
	getTabsSupportedFlavours : function ()
	{
		var flavours = this.__tabextensions__getSupportedFlavours();

		var flavour;

		flavour = new Flavour('tabbrowser/tabbar');
		flavours.flavours.unshift(flavour);
		flavours.flavourTable[flavour.contentType] = flavour;

		flavour = new Flavour('tabbrowser/tab');
		flavours.flavours.unshift(flavour);
		flavours.flavourTable[flavour.contentType] = flavour;

		return flavours;
	},
  
	// ^uE^uo[_uNbNENbN̓ 
	// behavior of clicking on the the tabbar or tabs
	onTabClick : function(aEvent, aType)
	{
		var ignoreMiddleClick = false;
		try {
			ignoreMiddleClick = this.mPrefs.getBoolPref('middlemouse.contentLoadURL');
		}
		catch(e) {
		}
		if (aType == 'middle' && ignoreMiddleClick) return;

		// in scrollbars
		if (aEvent.originalTarget.localName &&
			aEvent.originalTarget.localName.match(/^(scrollbar(button)?|slider|thumb)$/)) return;

		var tab    = aEvent.target,
			action = 0,
			pref   = '';

		switch (tab.localName)
		{
			case 'tab':
				switch (aType)
				{
					case 'double':
						pref = 'ondblclick';
						break;

					case 'middle':
						pref = 'onmiddleclick';
						break;

					case '4th':
						pref = 'on4thclick';
						break;

					case '5th':
						pref = 'on5thclick';
						break;

					default:
						break;
				}
				break;

			default:
				tab = this.mCurrentTab;
				switch (aType)
				{
					case 'double':
						pref = 'tabbar_ondblclick';
						break;

					case 'middle':
						pref = 'tabbar_onmiddleclick';
						break;

					case '4th':
						pref = 'tabbar_on4thclick';
						break;

					case '5th':
						pref = 'tabbar_on5thclick';
						break;

					default:
						break;
				}
				break;
		}

		if (pref) {
			try {
				action = this.mPrefs.getIntPref('browser.tabs.extensions.'+pref);
			}
			catch(e) {
			}
		}

		switch (action)
		{
			case 0:
			default:
				break;

			case 1:
				BrowserOpenTab();
				break;
			case 2:
				this.reloadTab(tab);
				break;
			case 3:
				this.reloadAllTabs();
				break;
			case 4:
				this.removeTabInternal(tab);
				break;
			case 5:
				this.removeAllTabsButInternal(tab);
				break;
			case 6:
				if (this.tabGroupsAvailable)
					this.bookmarksManager.bookmarkTabGroup(tab);
				else if ('addGroupmarkAs' in window)
					addGroupmarkAs();
				else
					this.bookmarksManager.bookmarkTabGroup(tab, true);
				break;

			case 101:
				this.duplicateTab(tab);
				break;
			case 102:
				this.toggleTabLocked(tab);
				break;
			case 103:
				this.toggleTabAutoReload(tab);
				break;
			case 104:
				this.removeLeftTabsFrom(tab);
				break;
			case 105:
				this.removeRightTabsFrom(tab);
				break;
			case 106:
				this.duplicateTabInWindow(tab);
				break;
			case 107:
				this.moveTabBy(tab, -1);
				break;
			case 108:
				this.moveTabBy(tab, 1);
				break;
			case 109:
				this.removeTabGroup(tab);
				break;
			case 110:
				this.sortTabsByGroup();
				break;
			case 111:
				this.highlightGroupFromTab(tab);
				break;
			case 112:
				this.setGroupColorFor(tab);
				break;
			case 113:
				this.undoRemoveTab();
				break;
			case 114:
				this.editBookmarkFromTab(tab);
				break;
			case 115:
				this.toggleReferrerBlocked(tab);
				break;
			case 116:
				window.openDialog('chrome://tabextensions/content/contextMenuEdit.xul', '', 'chrome,modal,resizable=no');
				break;
			case 117:
				this.removeAllTabs();
				break;
			case 118:
				this.setFixedLabelFor(tab);
				break;

			case 200:
				this.toggleDocShellPropertyFor(tab, 'allowPlugins');
				break;
			case 201:
				this.toggleDocShellPropertyFor(tab, 'allowJavascript');
				break;
			case 202:
				this.toggleDocShellPropertyFor(tab, 'allowMetaRedirects');
				break;
			case 203:
				this.toggleDocShellPropertyFor(tab, 'allowSubframes');
				break;
			case 204:
				this.toggleDocShellPropertyFor(tab, 'allowImages');
				break;

			case 300:
				this.toggleAllTabsLocked();
				break;
			case 301:
				this.toggleReferrerBlockedForAllTabs();
				break;
			case 302:
				this.toggleAllTabsAutoReload();
				break;
		}

		aEvent.preventDefault();
		aEvent.preventBubble();
		aEvent.preventCapture();
		aEvent.stopPropagation();
	},
 
	// for "tabs" 
	advanceSelectedTab : function(aDir, aWithSelectionHistory)
	{
		var b          = this.mTabBrowser;
		var startTab   = this.selectedItem;
		var tabs;
		var next;

		if (aWithSelectionHistory) {
			tabs = b.mSelectionHistory;

			if (b.mSelectionHistoryIndex+aDir < 0 ||
				b.mSelectionHistoryIndex+aDir > tabs.length-1)
				return;

			next = tabs[b.mSelectionHistoryIndex+aDir];

			b.mSelectionHistoryIndex += aDir;

			b.mIsAdvancingSelectedTabWithSelectionHistory = true;
		}
		else {
			tabs = b.mTabs;
			next = tabs[Number(startTab.ordinal)+aDir];

			while (next != startTab && (!next || next.getAttribute('hidden')))
			{
				if (next && next.getAttribute('hidden'))
					next = tabs[Number(next.ordinal)+aDir];
				if (!next)
					next = (aDir > 0) ? tabs[0] : tabs[tabs.length-1];
			}
		}

		if (next && next != startTab) {
			this.selectedItem = next;
			next.focus();
			document.commandDispatcher.advanceFocusIntoSubtree(next);
		}

		if (b.mIsAdvancingSelectedTabWithSelectionHistory)
			b.mIsAdvancingSelectedTabWithSelectionHistory = false;
	},
 
	replaceGroup : function(aGroupInfo) 
	{
		var oldTabsInfo = [];
		var i;

		for (i in this.mTabs)
			oldTabsInfo.push(this.getTabInfo(this.mTabs[i]));

		var t = this.removeAllTabsButInternal(this.addTab('about:blank'), 'preventUndo=yes');

		for (i = 0; i < aGroupInfo.length; i++)
		{
			if ('SHEntries' in aGroupInfo[i])
				this.addTabWithTabInfo(aGroupInfo[i]);
			else {
				var referrerURI = 'referrerURI' in aGroupInfo[i] ? data.referrerURI : null ;
				this.addTab(aGroupInfo[i].URI, aGroupInfo[i]);
			}
		}

		if (aGroupInfo.length)
			this.removeTabInternal(t, 'preventUndo=yes');

		return oldTabsInfo;
	},
  
	// ReLXgj[ 
	// updating nsContextMenu
	
	initItems : function() 
	{
		this.__tabextensions__initItems();

		var TS = TabbrowserService;

		var onLinks              = false,
			onLinksWithoutMailto = false,
			isSingleWindow       = false,
			tab                  = null,
			tabs                 = [];

		var showOpenInActiveTab = TS.getPref('browser.tabs.extensions.showNewActiveTabItem') && TS.getPref('browser.tabs.loadInBackground');
		var showOpenAllLinksInTabs = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInTabs');
		var showOpenAllLinksInGroup = TS.getPref('browser.tabs.extensions.show_context.openAllLinksInGroup');
		var showBookmarkAllLinksAsGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkAllLinksAsGroup');
		var showBookmarkTabGroup = TS.getPref('browser.tabs.extensions.show_context.bookmarkTabGroup');

		if (showOpenAllLinksInTabs ||
			showOpenAllLinksInGroup ||
			showBookmarkAllLinksAsGroup) {
			try {
				var links = TS.getSelectionLinks();
				onLinks = (links.length > 1);

				for (var i = links.length-1; i > -1; i--)
					if (links[i].uri.match(/^mailto:/))
						links.splice(1, 1);
				onLinksWithoutMailto = (links.length > 1);

				isSingleWindow = TS.winHookMode == 2;

				tab  = (TS.browser) ? TS.browser.mCurrentTab : null ;
				if (tab) {
					if (!tab.childTabs.length && tab.parentTab) tab = tab.parentTab;
					tabs = TS.browser.gatherChildTabsOf(tab);
					tabs.unshift(tab);
				}
			}
			catch(e) {
				alert(e);
			}
		}


		this.showItem('context-openlink', (this.onSaveableLink || ( this.inDirList && this.onLink )) && !isSingleWindow);

		this.showItem('context-openLinkInNewActiveTab', this.onLink && showOpenInActiveTab);

		this.showItem('context-openAllLinksInTabs', onLinks && showOpenAllLinksInTabs);
		this.showItem('context-openAllLinksInGroup', onLinks && showOpenAllLinksInGroup && TS.isGroupMode);
		this.showItem('context-sep-open', (onLinks && (showOpenAllLinksInTabs || showOpenAllLinksInGroup)) || this.onSaveableLink || ( this.inDirList && this.onLink ) );

		this.showItem('context-bookmarkAllLinksAsGroup', onLinksWithoutMailto && showBookmarkAllLinksAsGroup);
		this.showItem('context-bookmarkTabGroup', this.tabGroupsAvailable && !(this.isTextSelected || this.onTextInput) && tabs.length > 1 && showBookmarkTabGroup);
	},
  
	// Toolbars (Phoenix/Firebird or Mozilla 1.5 or later) 
	
	insertItem : function(aId, aBeforeElt, aWrapper, aBeforePermanent) 
	{
		var ret = this.__tabextensions__insertItem(aId, aBeforeElt, aWrapper, aBeforePermanent);

		// dispatch "TSToolbarItemInserted" event
		var event = document.createEvent('Events');
		event.initEvent('TSToolbarItemInserted', false, true);
		event.targetItem = ret ? ret : null ;
		this.dispatchEvent(event);

		return ret;
	},
  
	// Bookmarks 
	
	openBookmark : function(aID, aEvent, aOpenType) 
	{
try{
		if (// Ignored bookmark uris:
			!aID || // no URI, or functions
			aID.match(/bookmarks-button|BookmarksMenu|NC:PersonalToolbarFolder|innermostBox|(PT_)?bookmarks_groupmark|exBookmarks|bookmarks-menu|bookmarks-ptf|bookmarks-chevron|PersonalToolbar/i) || // Not a bookmark *item*
			// innermostBox is in NS7/Moz1.0. NC:Personal... is in 1.1.
			(aEvent && aEvent.type == 'click' && aEvent.button > 1) // right click or others
			) {
			return false;
		}

		var uri      = aID;
		var resource = null;
		try {
			resource = this.RDF.GetResource(uri);
		}
		catch(e) {
			return false;
		}

		// for bookmark groups
		var isFolder = this.isBookmarkFolder(resource);
		var isGroup  = (aOpenType == 'folder-as-group' && isFolder) || this.isBookmarkGroup(resource);
		var shouldOpenAsGroup = (aOpenType == 'folder-as-group') || this.shouldOpenBookmarkGroup(resource);
//dump('GROUP: '+isGroup+', Folder: '+isFolder+'\n');
		if (!isGroup && !isFolder) {
			try { // for IE favorites, etc.
				var target = this.BookmarksDS.GetTarget(
						resource,
						this.kNC_URL,
						true
					);
				if (!target) return false;
				target = target.QueryInterface(this.knsIRDFLiteral).Value;
				if (target) uri = target;
			}
			catch (e) {
				return false;
			}
		}


		var usetab       = this.opentabforBookmarks,
			usetab_force = this.opentabforAnyBookmark;

		var w = this.browserWindow;
		var b = w ? w.TabbrowserService.browser : null ;

		var middleClick = aEvent &&
					(
						(aEvent.type == 'click' && aEvent.button == 1) ||
						(
							(
								(aEvent.type == 'click' && aEvent.button == 0) ||
								aEvent.type == 'command'
							) &&
							(
								aEvent.ctrlKey || aEvent.metaKey
							)
						)
					);

		var openIn = 'current';
		if (aOpenType && aOpenType != 'folder-as-group')
			openIn = aOpenType;
		else {
			if (
				/*!uri.match(/^NC:/) &&*/ !uri.match(/^javascript:/i) &&
				(usetab_force || (usetab && middleClick))
				) {
				// VK^uJŁAubN}[NJĂ悢ꍇ
				// Open the bookmark in new tabs
				// O
				// Exception
				if (
					usetab_force &&
					(
						middleClick || // ɐVK^uŊJݒ̎́At]
						(
							b &&
							b.mCurrentBrowser.currentURI.spec == 'about:blank'// &&
	//						this.getPref('browser.tabs.opentabfor.anybookmark_but')
						)
					)
					)
					openIn = 'current';
				else
					openIn = 'tab';
			}
			else if (!aEvent || aEvent.type == 'command' || aEvent.button == 0)
				// VK^uJȂŁAubN}[NJĂ悢ꍇ
				// Open the bookmark in the current tab
				openIn = 'current';
/*
if (aEvent)
	alert([
		'type  : '+aEvent.type,
		'key   : '+aEvent.keyCode,
		'ctrl  : '+aEvent.ctrlKey,
		'shift : '+aEvent.shiftKey,
		'alt   : '+aEvent.altKey,
		'meta  : '+aEvent.metaKey
	].join('\n'));
*/
			if (openIn == 'tab' && aEvent && aEvent.shiftKey)
				openIn = 'window';

			if (openIn == 'current' && aEvent && aEvent.altKey)
				openIn = 'properties';

			if (openIn == 'window' && this.winHookMode == 2)
				openIn = 'tab';
		}

		if (!w && openIn != 'properties')
			openIn = 'window';


		// load stored data for the bookmark
		var referrer   = this.getReferrerForBookmark(aID) || null ;
		var info       = {
				uri        : uri,
				fixedLabel : this.getFixedLabelForBookmark(aID),
				bookmarkID : aID
			};

		if (this.getPref('browser.tabs.extensions.show_link_text_as_label')) {
			info.fixedLabelAutoDestroy = true;
			if (!info.fixedLabel)
				info.fixedLabel = this.getNameForBookmark(aID);

			info.fixedLabel = this.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, info.fixedLabel || '').replace(/\s+/g, ' ');
		}

		if (this.shouldSaveBookmarksStatus)
			this.readBookmarkStatusToTabInfo(aID, info);

		var reloadTab = null;
		if (this.preventSameURLTab) {
			var tabs = b.mTabs;
			for (var i in tabs)
				if (tabs[i].mTabInfo.loadingURI == uri) {
					reloadTab = tabs[i];
					break;
				}
		}


		switch (openIn)
		{
			case 'current':
			default:
				// web panels (Mozilla Firebird)
				if (
					'BookmarksCommand' in window &&
					this.BookmarksDS.GetTarget(
						resource,
						this.kNC_WebPanel,
						true
					) &&
					'openWebPanel' in BookmarksCommand
					) {
					BookmarksCommand.openWebPanel(resource, this.BookmarksDS);
					return true;
				}

				if (shouldOpenAsGroup)
					if (isGroup || (usetab_force && middleClick)) {
						this.openBookmarkGroup(resource, this.BookmarksDatabase);
						return true;
					}
					else
						return false;
				else if (isFolder)
					return false;

				if (reloadTab) {
					b.selectedTab = reloadTab;
					reloadTab.mBrowser.reload();
					reloadTab.mBrowser.contentDocument.defaultView.focus();
					break;
				}

				b.mCurrentBrowser.loadURI(uri, referrer);
				b.initTabWithTabInfo(b.mCurrentTab, info);

				if (w == window || !this.loadInBackgroundWindow) {
					w.focus();
					w.setTimeout('_content.focus();', 0);
				}

				break;

			case 'tab':
			case 'newactivetab':
				if (shouldOpenAsGroup) {
					this.openBookmarkGroup(resource, this.BookmarksDatabase);
					return true;
				}
				else if (isFolder)
					return false;

				var newTab;
				if (reloadTab) {
					reloadTab.mBrowser.reload();
					newTab = reloadTab;
				}
				else {
					newTab = b.addTabInternal(
							uri,
							referrer,
							info
						);
				}
				var loadInBackground = this.loadInBackgroundBookmarks;
				if (!loadInBackground || openIn == 'newactivetab')
					b.selectedTab = newTab;

				if (w == window || !this.loadInBackgroundWindow) {
					w.focus();
					w.setTimeout('_content.focus();', 0);
				}

				break;

			case 'window':
				if (shouldOpenAsGroup)
					return false;
				else if (isFolder)
					return false;
				else
					window.openDialog(
						this.browserURI,
						'_blank',
						'chrome,all,dialog=no',
						uri,
						null,
						referrer,
						info
					).addEventListener(
						'load',
						function()
						{
							var b = TabbrowserService.browser;
							b.initTabWithTabInfo(b.mCurrentTab, window.arguments[3]);
						},
						false
					);
				break;

			case 'properties':
				if (this.isNewTypeBrowser) // Phoenix/Firebird or Mozilla 1.5 or later
					window.openDialog('chrome://browser/content/bookmarks/bookmarksProperties.xul', '', 'centerscreen,chrome,resizable=no', uri);
				else
					window.openDialog('chrome://communicator/content/bookmarks/bm-props.xul', '', 'centerscreen,chrome,dialog=no,resizable=no,dependent', uri);
				break;
		}

		return true;
}
catch(e) {
		if (this.debug) alert('FAILED TO OPEN A BOOKMARK:\n\n'+e);
		return false;
}
	},
	
	// ubN}[NtH_ǂׂ 
	// is the bookmark item only a folder?
	isBookmarkFolder : function(aResource)
	{
		try {
			var type = this.BookmarksDatabase.GetTarget(
					aResource,
					this.RDF.GetResource('http://www.w3.org/1999/02/22-rdf-syntax-ns#type'),
					true
				);
			if (type) {
				type = type.QueryInterface(this.knsIRDFResource).Value;
				return (type == 'http://home.netscape.com/NC-rdf#Folder');
			}
		}
		catch(e) {
		}

		return false;
	},
 
	// ubN}[NO[vǂׂ 
	// is the bookmark item a group?
	isBookmarkGroup : function(aResource)
	{
		try {
			var isGroupLiteral = this.BookmarksDatabase.GetTarget(
					aResource,
					this.RDF.GetResource('http://home.netscape.com/NC-rdf#FolderGroup'),
					true
				);
			if (isGroupLiteral) {
				isGroupLiteral = isGroupLiteral.QueryInterface(this.knsIRDFLiteral).Value;
				return (isGroupLiteral == 'true');
			}
		}
		catch(e) {
		}

		return false;
	},
 
	shouldOpenBookmarkGroup : function(aResource) 
	{
		var folderAsGroup = this.getPref('browser.tabs.opentabfor.bookmarks_folder_as_group');
		return (folderAsGroup) ? this.isBookmarkFolder(aResource) : this.isBookmarkGroup(aResource) ;
	},
  
	// ubN}[NJ 
	openBookmarkURL : function(aNode, aDataSource, aEvent, aRoot)
	{
		var TS   = TabbrowserService,
			type = (aEvent ? aEvent.type : 'command' ),
			node = aNode;
		var url  = (node) ? node.id :
					(aEvent) ? aEvent.target.id :
					null ;

		if (url == 'openintabs-menuitem') { // "Open in Tabs" in folders
			if (
				aEvent &&
				(type != 'click' || aEvent.button == 0)
				)
				TS.openBookmark(aEvent.target.parentNode.parentNode.id, aEvent, 'folder-as-group');

			return;
		}


		if (navigator.platform.indexOf('Mac') < 0 &&
			TS.emulateMiddleButtonByControlKey) {
			// oncommandŔCxg̏onclicǩɉ
			// If user ctrl-clicks a bookmark, "oncommand" and "onclick" are dispatched at same time and the bookmark will be opened twice. This function ignore "oncommand" event dispatched with "onclick".
			if (aEvent && aEvent.target) {
				var time = (new Date()).getTime();
				if (type == 'command') {
					TS.lastSent_bookmarks_command = time;
					window.setTimeout(TS.openBookmarkURL, 20, node, TS.BookmarksDatabase, null, null);
	//				dump('command->, at '+TS.lastSent_bookmarks_command+'\n');
				}
				else {
					TS.lastSent_bookmarks_click = time;
					var clickEvent = {
							type     : 'click',
							button   : aEvent.button,
							ctrlKey  : aEvent.ctrlKey,
							metaKey  : aEvent.metaKey,
							altKey   : aEvent.altKey,
							shiftKey : aEvent.shiftKey,
							target   : null
						};
					window.setTimeout(TS.openBookmarkURL, 10, node, TS.BookmarksDatabase, clickEvent, null);
	//				dump('click->, at '+TS.lastSent_bookmarks_click+'\n');
				}
				return;
				// ̉@߂ĎƂ́Aoncommand > onclick ̏ɔĂBƂ낪A̍炩Aonclick > oncommand ̏ɕύXĂBł́AɁuonclick > 񂵂ɂꂽoncommandv̏ŏs߂ɁA_~[̃CxgIuWFNggonclickx点Č񂵂ɂĂB
			}
			// Ctrl-clickoncommand̕]vȓ삪sĂ܂̂h߁Aonclick  oncommand قړi݂2b܂Łcc܂ZƐVK^uJŎԎĂ邤ɎԂ߂Ă܂jɔꍇA oncommand 𖳎Boncommand݂̂ꍇ́Â܂܏𑱂B
			// ȂẢ@́Aonclick̂قɔĂȂΈӖȂBoncommand̃Cxg񂵂ɂ̂͂̂߁B
			if (Math.abs(TS.lastSent_bookmarks_command - TS.lastSent_bookmarks_click) < 2000 &&
				type == 'command') {
	//			dump('-->command:rejected, delayed '+Math.abs(TS.lastSent_bookmarks_command-TS.lastSent_bookmarks_click)+' sec\n');
				return;
			}

	//		dump('-->'+type+', at '+TS['lastSent_bookmarks_'+type]+'\n');
		}
		else if (
				aEvent && type == 'click' &&
				(aEvent.button != 1 || !TS.opentabforBookmarks)
				) return;

		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}

		if (!TS.openBookmark(url, aEvent)) return;

		if (!node) return;
		var parent = node.parentNode;
		while (parent && parent != aRoot)
		{
			if ('hidePopup' in parent)
				parent.hidePopup();
			else if ('closePopup' in parent)
				parent.closePopup();

			parent = parent.parentNode;
		}
	},
 
	// ubN}[NO[vJ 
	openBookmarkGroup : function(aResourceOrID, aDataSource, aRDF, aCalled) // aRDF is ignored
	{
try {
		var TS = TabbrowserService;
		var w  = TS.browserWindow;

		var containerRes;
		try {
			containerRes = aResourceOrID.QueryInterface(TS.knsIRDFResource);
		}
		catch(e) {
			if (typeof aResourceOrID == 'string')
				containerRes = TS.RDF.GetResource(aResourceOrID);
			else
				return;
		}

		if (!aDataSource) aDataSource = TS.BookmarksDS;


		var RDFC   = Components.classes['@mozilla.org/rdf/container;1'].getService(Components.interfaces.nsIRDFContainer);
		RDFC.Init(aDataSource, containerRes);

		var items = RDFC.GetElements(),
			item,
			uri,
			referrer;
		var b = w ? w.TabbrowserService.browser : null ;
		var nextIndex = b ? b.mTabs.length : 0 ; // ɃANeBuɂ^u̔ԍ
		var rootTab = b ? b.mTabs[0] : null ;

		var isGroupMode = TS.isGroupMode;
		var shouldOpenAsGroup = isGroupMode && TS.getPref('browser.tabs.extensions.group.open_bookmarkgroup_as_group');

		var shouldResutoreStatus = TS.shouldSaveBookmarksStatus;
		var loadInBackground = TS.loadInBackgroundBookmarks;
		var groupBehavior = TS.bookmarkGroupBehavior;
		var preventSame = TS.preventSameURLTab;

		if (isGroupMode)
			rootTab = b.mCurrentTab.parentTab || b.mCurrentTab;

		// SẴ^uNAꍇ
		// Clear all tabs before opening a bookmark-group
		if ((groupBehavior == 10 || groupBehavior == 11) && !aCalled) {
			if (b) {
				var shouldMakeBackLog = false,
					removedTabsInfo   = [];
				if ('replaceGroup' in b)
					for (var i in b.mTabs)
						removedTabsInfo.push(b.getTabInfo(b.mTabs[i]));

				if (isGroupMode && groupBehavior == 11) {
					var children = b.gatherChildTabsOf(rootTab);
					if (children.length) {
						for (var i = children.length-1; i > -1; i--)
							b.removeTabInternal(children[i]);
					}
					else {
						rootTab = b.removeAllTabsButInternal(b.addTab('about:blank'), 'preventUndo=yes');
						shouldMakeBackLog = true;
					}
				}
				else {
					rootTab = b.removeAllTabsButInternal(b.addTab('about:blank'), 'preventUndo=yes');
					shouldMakeBackLog = true;
				}

				if (shouldMakeBackLog && 'replaceGroup' in b) {
					b.backBrowserGroup    = removedTabsInfo;
					b.forwardBrowserGroup = [];
				}
			}

			loadInBackground = false;
		}


		var t,
			info,
			parentTab,
			i,
			reloaded;

		var shouldShowTempLabel = TS.getPref('browser.tabs.extensions.show_link_text_as_label');

		for (var index = 0; items.hasMoreElements(); ++index)
		{
			item = items.getNext().QueryInterface(TS.knsIRDFResource);

			// ċAőSẴubN}[NJ
			// open all bookmarks in the folder reflexively
			if (TS.shouldOpenBookmarkGroup(item) &&
				TS.getPref('browser.tabs.extensions.bookmarks.open_child_folders')) {
				TS.openBookmarkGroup(item, aDataSource, null, true);
				continue;
			}

			uri = aDataSource.GetTarget(item, TS.kNC_URL, true);
			if (!uri) continue;
			uri = uri.QueryInterface(TS.knsIRDFLiteral).Value;
//			dump('Open Bookmark Group: '+uri+'\n');


			if (isGroupMode) {
				if (!index) { // first item
					if (groupBehavior || shouldOpenAsGroup)
						parentTab = (groupBehavior == 1 || (groupBehavior == 21 && rootTab.childTabs.length)) ? rootTab : null ;
					else
						parentTab = null;
				}
				else if ( // exception
						(
						groupBehavior == 10 || groupBehavior == 11 ||
						((groupBehavior == 20 || groupBehavior == 21) && !rootTab.childTabs.length)
						) &&
						!shouldOpenAsGroup
					) {
					parentTab = null;
				}
				else if (groupBehavior || shouldOpenAsGroup)
					parentTab = rootTab;
			}

			info = {
				uri        : uri,
				parentTab  : parentTab,
				bookmarkID : item.Value,
				inGroup    : true,
				fixedLabel            : (shouldShowTempLabel ? TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, TS.getNameForBookmark(item.Value) || '').replace(/\s+/g, ' ') : TS.getFixedLabelForBookmark(item.Value) ),
				fixedLabelAutoDestroy : shouldShowTempLabel
//				openIn     : 3
			};

			if (shouldResutoreStatus)
				TS.readBookmarkStatusToTabInfo(item.Value, info);

			referrer = TS.getReferrerForBookmark(item.Value);


			reloaded = false;
			if (preventSame) {
				for (i = 0; i < b.mTabs.length; i++)
					if (b.mTabs[i].mTabInfo.loadingURI == uri) {
						b.mTabs[i].mBrowser.reload();
						t = b.mTabs[i];
						reloaded = true;
					}
			}

			if (!reloaded) {
				if (!w || !b) {
					info.parentTab = info.parentTab ? true : false ;
					TS.overflowingTabsManager.addTab(uri, referrer, info);
					t = null;
				}
				else if (!index && !aCalled && (
						(groupBehavior == 10 || groupBehavior == 11) || // when the group replaces existing tabs
						( // if the tab is "about:blank", load the first bookmark in the tab
							b.mCurrentBrowser.currentURI.spec == 'about:blank' &&
							TS.getPref('browser.tabs.extensions.open_first_in_current')
						) ||
						( // when the group replaces existing tab when only one tab is open
							(groupBehavior == 20 || groupBehavior == 21) &&
							(b.mTabs.length == 1 || !rootTab.childTabs.length)
						)
					)) {
					nextIndex = rootTab.ordinal;

					rootTab.mBrowser.loadURI(uri, referrer);
					b.initTabWithTabInfo(rootTab, info);
					if (parentTab || shouldOpenAsGroup)
						rootTab.parentTab = parentTab;

					t = rootTab;
				}
				else {
					t = b.addTabInternal(
						uri,
						referrer,
						info
					);
				}
			}

			if (!index) {
				switch (this.getPref('browser.tabs.extensions.open_tab_in_link'))
				{
					case 1:
						info.openIn = 0;
						break;
					case 2:
					default:
						info.openIn = 3;
						break;
				}

				if (isGroupMode) {
					// ŏ̃^uV[g^uɂ
					// set new root tab
					if (shouldOpenAsGroup)
						rootTab = t || true ; // "true" is for overflowed tabs

					if (t &&
						(groupBehavior || shouldOpenAsGroup) &&
						!t.parentTab)
						t.removeAttribute('tab-group-color');
				}
			}

			index++;
		}

		// ubN}[NO[vsȏꍇAȂB
		// Invalid bookmark-group is ignored.
		if (!index) return;

		// ubN}[NO[v̍ŏ̃^uI
		// Select the first tab of group.
		if (b && !loadInBackground && !aCalled)
			b.selectedTab = b.mTabs[nextIndex];

		if (w == window || !TS.loadInBackgroundWindow) {
//			w.focus();
//			w.setTimeout('_content.focus();', 0);
			b.focus();
		}

		return;
}
catch(e) {
		if (this.debug) alert('FAILED TO OPEN A BOOKMARK GROUP:\n\n'+e);
		return;
}
	},
 
	// in Bookmarks Tree 
	openBookmarkItem : function(aEvent, aInNewWindow, aOpenGroups)
	{
		var groupRes      = this.rdf.GetResource(this.NC_NS + 'FolderGroup');
		var groupTarget   = this.db.GetTarget(this.currentRes, groupRes, true);

		var TS = TabbrowserService;

		var browserWindow = TS.browserWindow;

		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		try {
			var usetab       = TS.opentabforBookmarks;
			var usetab_force = TS.opentabforAnyBookmark;
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);

			// ubN}[N^uŊJȊO
			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // ReLXgj[uJvuVKEBhEŊJvI "Open" or "Open in New Window" selected in the context menu
						(groupTarget && (!aOpenGroups || aEvent.detail > 1)) ||
						(!groupTarget && this.treeBoxObject.view.isContainer(this.treeBoxObject.selection.currentIndex)) || // ReiJꍇ clicking folders
						aEvent.altKey || // vpeBJꍇ open property
						aInNewWindow // IɐVKEBhEŊJꍇ open in window compulsory
					);

			// ^uŊJ̏ꍇ
			// action to open the bookmark in new tab
			var openTabAction = ((usetab && !usetab_force && middleclick) || (usetab && middleclick && usetab_force && TS.shouldOpenBookmarkGroup(this.currentRes)));
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(usetab_force && !middleclick &&
						!TS.shouldOpenBookmarkGroup(this.currentRes) &&
							(
							browserWindow.TabbrowserService.browser.mCurrentBrowser.currentURI.spec != 'about:blank'// ||
//							!TS.getPref('browser.tabs.opentabfor.anybookmark_but')
							)
						)
					);

			// tH_O[vƂĊJ
			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(this.currentRes))
				return TS.openBookmarkGroup(this.currentRes, this.db);

			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TS.isBookmarkFolder(this.currentRes) ||
				!aEvent // from the context menu
				)
				return this.__tabextensions__openItem(aEvent, aInNewWindow, aOpenGroups);

			var urlValue = db.GetTarget(this.currentRes, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TS.openBookmark(urlValue, aEvent, (otherAction || !openTabAction) ? 'current' : 'tab');
		}
		catch(e) {
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
	
	validOpenClickConditions : function(aEvent) 
	{
		if (
			aEvent.button > 1 ||
			aEvent.originalTarget.localName != 'treechildren' ||
			(aEvent.button == 1 && !TabbrowserService.opentabforBookmarks)
			)
			return false;

		var row = {};
		var col = {};
		var obj = {};
		this.treeBoxObject.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
		if (row.value == -1 || obj.value == 'twisty')
			return false;

		return true;
	},
  
	// in Bookmarks Tree (new implementation, Phoenix/Firebird or Mozilla 1.5 or later) 
	openBookmarkItemClickOrKey : function(aEvent, aClickCount)
	{
		var TS = TabbrowserService;

		if (
			(aEvent && !this.validOpenClickConditions(aEvent)) ||
			(aClickCount != this.clickCount && aEvent && aEvent.button != 1)
			)
			return false;

		var browserWindow = TS.browserWindow;
		var rdf = TS.RDF;
		var db  = TS.BookmarksDatabase;

		// for new implementation
		var sel = this._selection;
		var res = sel ? rdf.GetResource(sel.item[0].Value) : this.currentRes ;

		try {
			var usetab       = TS.opentabforBookmarks;
			var usetab_force = TS.opentabforAnyBookmark;
			var middleclick  = aEvent && (
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					);

			// ubN}[N^uŊJȊO
			// actions not to open the bookmark in new tab
			var otherAction = (
						!aEvent || // ReLXgj[uJvuVKEBhEŊJvI "Open" or "Open in New Window" selected in the context menu
//						aEvent.detail > 1 ||
						(sel && sel.type[0] != 'Bookmark') || // new implementation
						(this.treeBoxObject.view.isContainer(this.treeBoxObject.selection.currentIndex)) || // old implementation: ReiJꍇ clicking folders
						aEvent.altKey // vpeBJꍇ open property
					);

			// ^uŊJ̏ꍇ
			// action to open the bookmark in new tab
			var openTabAction = ((usetab && !usetab_force && middleclick) || (usetab && middleclick && usetab_force && TS.shouldOpenBookmarkGroup(res)));
			if (browserWindow)
				openTabAction = (
						openTabAction ||
						(usetab_force && !middleclick &&
						!TS.shouldOpenBookmarkGroup(res) &&
							(
							browserWindow.TabbrowserService.browser.mCurrentBrowser.currentURI.spec != 'about:blank'// ||
//							!TS.getPref('browser.tabs.opentabfor.anybookmark_but')
							)
						)
					);


			// tH_O[vƂĊJ
			// open the folder as a group
			if (openTabAction &&
				TS.shouldOpenBookmarkGroup(res))
				return TS.openBookmarkGroup(res, db);


			if ((otherAction || !openTabAction) &&
				aEvent && aEvent.type.match(/click/) && aEvent.button > 1) {
				aEvent.preventBubble();
				return true;
			}


			if (
				TabbrowserService.isBookmarkFolder(res) ||
				!aEvent // from the context menu
				) {
				return ('__tabextensions__openItemClick' in this) ? (aEvent ? this.__tabextensions__openItemClick(aEvent, aClickCount) : this.__tabextensions__openItemKey() ) : this.__tabextensions__openItem(aEvent, aClickCount) ;
			}

			var urlValue = db.GetTarget(res, TS.kNC_URL, true);
			if (!urlValue) return false;

			urlValue = urlValue.QueryInterface(TS.knsIRDFLiteral).Value;
			if (!urlValue || urlValue.substring(0,3) == 'NC:') return false;

			if (!browserWindow)
				return window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', urlValue, null, null);

			TabbrowserService.openBookmark((sel ? sel.item[0].Value : urlValue ), aEvent, (otherAction || !openTabAction) ? 'current' : 'tab');
		}
		catch(e) {
//			alert(e); // In some environments, "Type Error: this.getBrowserForTab(aTab).currentURI has no properties" error appears (but works fine). Why?
		}

		if (aEvent) aEvent.preventBubble();
		return true;
	},
 
	// Phoenix/Firebird or Mozilla 1.5 or laterŃubN}[NO[vJ 
	// open bookmark groups in Phoenix/Firebird or Mozilla 1.5 or later
	openGroupBookmark : function(aURI, aTargetBrowser)
	{
		var TS = TabbrowserService;
		var resource = TS.RDF.GetResource(aURI);

		if (aTargetBrowser == 'window') {
			var w = window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', null, null, null, resource);
			w.addEventListener(
				'load',
				function(aEvent)
				{
					aEvent.target.TabbrowserService.openBookmarkGroup(aEvent.target.arguments[3]);
				},
				false
			);
		}
		else
			TS.openBookmarkGroup(resource, TS.BookmarksDS);
	},
 
	// BookmarksUtils 
	
	addBookmark : function(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel) 
	{
		// use fixed label instead of the title
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browsers : [] ;
		for (var i = 0; i < b.length; i++)
			if (b[i].mCurrentTab &&
				b[i].mCurrentTab.mTabInfo.loadingURI == aURI &&
				b[i].mCurrentTab.mTabInfo.fixedLabel)
				aTitle = b[i].mCurrentTab.mTabInfo.fixedLabel;

		this.__tabextensions__addBookmark(aURI, aTitle, aCharset, aShowDialogOrIsWebPanel);
	},
 
	createBookmark : function(aName, aURI, aCharSet, aDefaultName) 
	{
		// use fixed label instead of the title (for drag'n'drop)
		var nav = TabbrowserService.browserWindow;
		var b   = nav ? nav.TabbrowserService.browsers : [] ;
		var i, j;
		for (i = 0; i < b.length; i++)
			for (i = 0; i < b.length; i++)
				if (b[i].mCurrentTab &&
					b[i].mCurrentTab.mTabInfo.loadingURI == aURI &&
					b[i].mCurrentTab.mTabInfo.fixedLabel &&
					b[i].mCurrentTab.mTabInfo.fixedLabel == aDefaultName)
					aName = b[i].mCurrentTab.mTabInfo.fixedLabel;

		return this.__tabextensions__createBookmark(aName, aURI, aCharSet, aDefaultName);
	},
  
	// BookmarksMenu 
	
	loadBookmark : function(aEvent, aTarget, aDatabase) 
	{
		TabbrowserService.openBookmarkURL(aTarget, aDatabase, aEvent, aEvent.currentTarget);
	},
 
	loadBookmarkMiddleClick : function(aEvent, aDatabase) 
	{
		TabbrowserService.openBookmarkURL(aEvent.target, aDatabase, aEvent, aEvent.currentTarget);
	},

  
	// BookmarksCommand 
	
	BookmarksCommandOpenBookmark : function(aSelection, aOpenType, aDataSource) 
	{
		if (!aOpenType) return;

		var type;
		for (var i = 0; i < aSelection.length; i++)
		{
			type = aSelection.type[i];
			if (!type || type == 'Bookmark')
				TabbrowserService.openBookmark(aSelection.item[i].Value, null, aOpenType, aDataSource);
			else if (type.match(/^(FolderGroup|Folder|PersonalToolbarFolder)$/))
				TabbrowserService.openBookmarkGroup(aSelection.item[i].Value, aDataSource);
		}
	},
 
	BookmarksCommandCreateContextMenu : function(aEvent, aSelection) 
	{
		this.__tabextensions__createContextMenu(aEvent, aSelection);

		var TS    = TabbrowserService,
			popup = aEvent.target;

		var newTabItem = popup.getElementsByAttribute('command', 'cmd_bm_openinnewtab');
		if (!newTabItem.length ||
			!TS.getPref('browser.tabs.extensions.showNewActiveTabItem') ||
			!TS.getPref('browser.tabs.extensions.loadInBackgroundBookmarks'))
			return;

		var node = popup.insertBefore(document.createElement('menuitem'), newTabItem[0].nextSibling);
		node.setAttribute('label', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_label'));
		node.setAttribute('accesskey', TS.strbundle.GetStringFromName('openBookmarkInNewActiveTab_accesskey'));
		node.setAttribute('oncommand', 'TabbrowserService.openBookmark((\'BookmarksMenu\' in window ? BookmarksMenu._selection.item[0].Value : this.parentNode.parentNode._selection.item[0].Value ), null, \'newactivetab\');');
	},
   
	// History 
	
	gotoHistoryIndex : function(aEvent, aIndex, aNode) 
	{
		var index = aIndex || aEvent.target.getAttribute('index');
		if (!index) return false;

		var TS   = TabbrowserService,
			node = aNode || aEvent.target;

		if (TS.emulateMiddleButtonByControlKey) {
			if (aEvent && aEvent.target) {
				var time = (new Date()).getTime();
				var dummyEvent = {
						type     : 'click',
						button   : aEvent.button,
						ctrlKey  : aEvent.ctrlKey,
						metaKey  : aEvent.metaKey,
						altKey   : aEvent.altKey,
						shiftKey : aEvent.shiftKey,
						target   : null
					};
				if (aEvent.type == 'command') {
					TS.lastSent_history_command = time;
					dummyEvent.type   = 'command';
					dummyEvent.button = 0;
					window.setTimeout(TS.gotoHistoryIndex, 20, dummyEvent, index, node);
				}
				else {
					TS.lastSent_history_click = time;
					dummyEvent.type = 'click';
					window.setTimeout(TS.gotoHistoryIndex, 10, dummyEvent, index, node);
				}
				return false;
			}
			if (Math.abs(TS.lastSent_history_command - TS.lastSent_history_click) < 2000 &&
				aEvent.type == 'command') {
				return false;
			}
		}
		else if (
				aEvent.type == 'click' &&
				(aEvent.button != 1 || !TS.opentabforHistory)
				) return false;


		// Mozilla for MacOS has a bug...it handles a wrong event from the menubar.
		if (navigator.platform.indexOf('Mac') > -1 &&
			aEvent.ctrlKey &&
			aEvent.altKey &&
			aEvent.metaKey) {
			aEvent = {
				type     : aEvent.type,
				button   : aEvent.button,
				ctrlKey  : false,
				metaKey  : false,
				altKey   : false,
				shiftKey : false,
				target   : aEvent.target
			};
		}


		try {
			var b = TS.browser;

			if (index == 'back')
				b.goBackGroup();
			else if (index == 'forward')
				b.goForwardGroup();
			else if (
				TS.opentabforAnyHistory ||
				(
					TS.opentabforHistory &&
					(
						aEvent.button == 1 ||
						(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
					)
				)
				) {
				var SH = null;
				try {
					SH = b.sessionHistory;
				}
				catch(ex) {
					return false;
				}

				var entry = SH.getEntryAtIndex(index, false);
				if (!entry) return false;

				entry = entry.QueryInterface(Components.interfaces.nsISHEntry);
				var t = b.addTab(entry.URI.spec, entry.referrerURI);

				if (!TS.loadInBackgroundHistory)
					b.selectedTab = t;
			}
			else
				b.webNavigation.gotoIndex(index);
		}
		catch(e) {
			return false;
		}


		if (node) {
			var parent = node;
			while (parent)
			{
				if ('hidePopup' in parent)
					parent.hidePopup();
				else if ('closePopup' in parent)
					parent.closePopup();

				parent = parent.parentNode;
			}
		}
		return true;
	},
 
	OpenURL : function(aInNewWindowOrTab) 
	{
		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = gHistoryTree.treeBoxObject.view.selection.count;
		if (
			TS.browserWindow &&
			(
				(
					aInNewWindowOrTab &&
					TabbrowserService.opentabforHistory
				) ||
				(
					TabbrowserService.opentabforAnyHistory &&
					TS.browserWindow.TabbrowserService.browser.currentURI.spec != 'about:blank'
				)
			) &&
			count == 1 &&
			!isContainer(gHistoryTree, currentIndex)) {
			var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
			var uri     = builder.getResourceAtIndex(currentIndex).Value;
			var t = TS.browserWindow.TabbrowserService.browser.addTab(uri);
			if (TS.loadInBackgroundHistory)
				TS.browserWindow.TabbrowserService.browser.selectedTab = t;

			if (!TS.loadInBackgroundWindow)
				TS.browserWindow.focus();

			return true;
		}

		return __tabextensions__OpenURL(aInNewWindowOrTab);
	},
 
	historyOnClick : function(aEvent) 
	{
		var TS = TabbrowserService;

		var currentIndex = gHistoryTree.currentIndex;
		var count        = gHistoryTree.treeBoxObject.view.selection.count;
		if (
			aEvent.button == 1 &&
			TabbrowserService.opentabforHistory &&
			count == 1 &&
			!isContainer(gHistoryTree, currentIndex) &&
			TS.browserWindow
			) {
			var builder = gHistoryTree.builder.QueryInterface(Components.interfaces.nsIXULTreeBuilder);
			var uri     = builder.getResourceAtIndex(currentIndex).Value;
			var t = TS.browserWindow.TabbrowserService.browser.addTab(uri);
			if (TS.loadInBackgroundHistory)
				TS.browserWindow.TabbrowserService.browser.selectedTab = t;

			if (!TS.loadInBackgroundWindow)
				TS.browserWindow.focus();

			return;
		}
		__tabextensions__historyOnClick(aEvent);
	},
  
	// for link click (target attribute) 
	contentAreaClick : function(aEvent, aFieldNormalClicks)
	{
		// tabbrowser, etc. (Mozilla 1.4 or later?)
		if (aEvent.target.ownerDocument.defaultView == window) return true;

		var i;
		var TS   = TabbrowserService,
			nav  = TS.browserWindow,
			b    = (nav ? nav.TabbrowserService.browser : null ),
			node = findParentNode(aEvent.target, 'a') ||
					findParentNode(aEvent.target, 'area') ||
					findParentNode(aEvent.target, 'link') ||
					null ;

		if (!node || (aEvent.type == 'click' && aEvent.button > 1)) {
			return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);
		}

		// ignore canceled events
		var retStr = (node.onclick ? node.onclick.toSource() : node.onkeypress ? node.onkeypress.toSource() : '' ).match(/return([^;]*);?\s*\}?\)?$/);
		if (retStr && retStr[1])
			with (node) {
				if (!eval(retStr[1])) return false;
			}


		var uri      = node.href,
			name     = (node.target ? node.target.replace(/^_(self|top|parent|content|main)$/i, '') : '' ),
			realName = (node.target || ''),
			browser;

		var targetWindow = document.commandDispatcher.focusedWindow;
		if (!targetWindow || targetWindow.top == window)
			targetWindow = window._content;


		var loadInBackground      = TS.loadInBackground;
		var isSaveModifierPressed = TS.getPref('ui.key.saveLink.shift') ? aEvent.altKey : aEvent.shiftKey ;

		var fromOtherWindow = (!b || b.contentDocument.defaultView != aEvent.target.ownerDocument.defaultView.top);


		var sourceURI = ('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(targetWindow, 'location').call(targetWindow).href : targetWindow.location.href ;


		// access from ime.nu(www.2ch.net), etc....
		var realURI = TS.getRealURI(uri);
		var bypassReferrerBlocker = realURI ? true : false ;
		if (realURI) uri = realURI;

		// for web panels (Sidebar)
		var forceToLoadInBrowser = (aFieldNormalClicks && (!name || name == '_content'));


		// blocking referrer
		// Phoenix/Firebird or Mozilla 1.5 or later uses shift key for "Open Link in New Window"
		var newTypeBrowserOpenWindow = false;
		if (
			TS.isNewTypeBrowser &&
			(aEvent.type != 'click' || aEvent.button == 0) &&
			!aEvent.ctrlKey && !aEvent.metaKey &&
			isSaveModifierPressed
			)
			newTypeBrowserOpenWindow = true;

		var referrerBlocked = (b && b.mCurrentTab.mTabInfo.referrerBlocked) || bypassReferrerBlocker;

		var referrer = (!referrerBlocked) ? TS.makeURIFromSpec(targetWindow.location.href) : null ;


		if (!b) {
			TS.makeLinkVisited(uri, node);
			if (!uri.match(/^javascript:/)) {
				window.openDialog(TS.browserURI, '_blank', 'chrome,all,dialog=no', uri, null, referrer);
				TS.stopEvent(aEvent);
			}
			return true;
		}

		// prevent to open new tab
		if (TS.preventSameURLTab) {
			if (b.mCurrentTab.mTabInfo.loadingURI == uri) {
				TS.stopEvent(aEvent);
				return true;
			}
			for (i in b.mTabs)
			{
				if (b.mTabs[i].mTabInfo.loadingURI != uri) continue;

				TS.stopEvent(aEvent);
				b.selectedTab = b.mTabs[i];
				return true;
			}
		}


		// new tab flags

		var causedByMiddleClick = (
				TS.getPref('browser.tabs.opentabfor.middleclick') &&
				aEvent.type == 'click' &&
				(
					aEvent.button == 1 ||
					(aEvent.button == 0 && (aEvent.ctrlKey || aEvent.metaKey))
				)
			);

		var causedByLocked = (!fromOtherWindow && b && b.localName == 'tabbrowser' && b.mCurrentTab.mTabInfo.locked);

		var causedByAlwaysNewTab = (b && b.currentURI.spec == 'about:blank') ? false : TS.getPref('browser.tabs.opentabfor.anylink') ;

		var causedByOuterLink = TS.getPref('browser.tabs.opentabfor.outerlink');
		if (causedByOuterLink) {
			function getHost(aURI) {
				var host = aURI.split('//');
				if (host.length > 1) {
					host = host[1].split('/');
					return (host.length > 1 && host[1].match(/^~/)) ? host[0]+'/'+host[1] : host[0] ;
				}
				return null;
			}
			if (getHost(uri) == getHost(sourceURI)) {
/*
				// is the link a real outer-link?
				var max   = (uri.length+sourceURI.length)/4+1;
				var outer = false;
				for (i = 0; i < max; i++)
					if (uri[i] != sourceURI[i])
						outer = true;
				// if the uri is different from the source uri over 50%, we regard it as an outer link.

				if (!outer)
*/
					causedByOuterLink = false;
			}
		}

		var causedByTargetAttribute =
			(
				name &&
				(
					(
						TS.winHookMode > 0 ||
						TS.getPref('browser.tabs.opentabfor.linkclick')
					) &&
					!TS.getPref('browser.block.target_new_window')
				) &&
				!TS.getFrameByName(targetWindow.top.frames, name)
			);

		// reverse behavior
		if (TS.isNewTypeBrowser && newTypeBrowserOpenWindow &&
			!TS.getPref('ui.key.saveLink.shift') &&
			aEvent.shiftKey &&
			(
				causedByLocked ||
				causedByAlwaysNewTab ||
				causedByTargetAttribute ||
				causedByMiddleClick ||
				TS.winHookMode > 1
			)
			)
			newTypeBrowserOpenWindow = false;

		if (aEvent.shiftKey && !newTypeBrowserOpenWindow)
			loadInBackground = !loadInBackground;


//alert('tabextensions:LinkClick handling\n  MiddleButton:'+causedByMiddleClick+'\n  Locked:'+causedByLocked+'\n  AnyLink:'+causedByAlwaysNewTab+'\n  ByTarget:'+causedByTargetAttribute+'\n');


		// sidebar features (Firebird)
		if (
			(name == '_search' || node.getAttribute('rel') == 'sidebar') &&
			!causedByMiddleClick &&
			!aEvent.shiftKey &&
			!aEvent.ctrlKey &&
			!aEvent.altKey &&
			!aEvent.metaKey
			)
			return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);


		// If any link is opened in new tabs and the link middle-clicked, then open the link in same tab.
		if (
			!referrerBlocked &&
			(
			!uri || uri.match(/^mailto:/) ||
			( // Don't open new tab when the link aims to an existing frame
				causedByAlwaysNewTab && /*enableExceptionForAlways &&*/
				!realName && targetWindow.top != targetWindow
			) ||
			(aEvent.type == 'click' && aEvent.button > 1)
			)
			) {
			return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);
		}


		// If a tab (named by "TARGET") exists, then open the link in the tab.
		if (
			(causedByTargetAttribute && !causedByMiddleClick) ||
			( // Don't open new tab when the link aims to an existing tab/frame
				causedByAlwaysNewTab && /*enableExceptionForAlways &&*/
				name && !name.match(/^_blank$/i)
			)
			) {
			if (TS.getFrameByName(targetWindow.top.frames, name)) {
				return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);
			}

			for (i in b.mTabs)
			{
				browser = b.mTabs[i].mBrowser;
				if (b.mTabs[i].browserName != name &&
					browser.contentDocument.defaultView.name != name) continue;

				browser.loadURI(getShortcutOrURI(uri), referrer);

				browser.contentDocument.defaultView.opener = targetWindow;
				if (name && !String(name).match(/^_(self|top|parent|blank|content)$/i))
					browser.contentDocument.defaultView.name = name;

				if (!loadInBackground) b.selectedTab = b.mTabs[i];

				(nav._content ? nav._content : nav ).focus();

				TS.makeLinkVisited(uri, node);

				// add the tab to the children list
				if (b.tabGroupsAvailable && b.ownerDocument == document && // reject tabs opened by undocked sidebar and so on
					b.mTabs[i] != b.mCurrentTab) // reject current tab
					b.attachTabTo(b.mTabs[i], b.mCurrentTab, true);

				TS.stopEvent(aEvent);
				return false;
			}
		}

		if (referrerBlocked || forceToLoadInBrowser ||
			causedByLocked ||
			causedByAlwaysNewTab ||
			causedByOuterLink ||
			causedByTargetAttribute ||
			causedByMiddleClick ||
			(newTypeBrowserOpenWindow && TS.winHookMode > 0)) {

			if (
				(
					referrerBlocked ||
					forceToLoadInBrowser
				) &&
				!(
					causedByLocked ||
					causedByAlwaysNewTab ||
					causedByOuterLink ||
					causedByTargetAttribute ||
					causedByMiddleClick
				)
				) {

				if (forceToLoadInBrowser) { // web panels (Sidebar)
					loadURI(uri, referrerBlocked ? null : referrer );
					TS.makeLinkVisited(uri, node);
				}
				else if (aEvent.shiftKey || aEvent.altKey)
					handleLinkClick(aEvent, uri, node);
				else { // block referrer
					loadURI(uri);
					TS.makeLinkVisited(uri, node);
				}

				TS.stopEvent(aEvent);
				return false;
			}

			if (
				!causedByLocked &&
				(
					uri.match(/^javascript:/i) ||
					( // reverse action by middle click when the default action is "open in new tab"
						causedByAlwaysNewTab && causedByMiddleClick
					)
				)
				) {
				handleLinkClick(aEvent, uri, node);
				return true;
			}

			TS.stopEvent(aEvent);

			// If the link has "TARGET", then the tab is named.
			var info = {
					browserName : (causedByTargetAttribute ? name : null )
				};

			if (TS.getPref('browser.tabs.extensions.show_link_text_as_label')) {
				info.fixedLabel = TS.strbundle.GetStringFromName('loading_temp_label').replace(/%s/gi, TS.getInnerTextOf(node) || '').replace(/\s+/g, ' ');
				if (!TS.getPref('browser.tabs.extensions.show_link_text_as_label_permanently'))
					info.fixedLabelAutoDestroy = true;
			}

			// add the tab to the children list
			if (
				targetWindow.top.document == b.mCurrentTab.mBrowser.contentDocument &&
				b.tabGroupsAvailable &&
				b.ownerDocument == document // reject tabs opened by undocked sidebar and so on
				) {
				info.parentTab = b.mCurrentTab;
				info.openedAutomatically = causedByTargetAttribute || causedByLocked || causedByAlwaysNewTab ;

				var openIn = TS.getPref('browser.tabs.extensions.open_tab_in_link');
				if (openIn > -1)
					info.openIn = openIn;
			}

			var newTab = b.addTabInternal(uri, referrer, info);

			if (causedByTargetAttribute) {
				newTab.mBrowser.contentDocument.defaultView.opener = targetWindow;
				if (name && !String(name).match(/^_(self|top|parent|blank|content)$/i))
					newTab.mBrowser.contentDocument.defaultView.name = name;
			}

			if (!loadInBackground) b.selectedTab = newTab;

			if (!TS.loadInBackgroundWindow)
				(nav._content ? nav._content : nav ).focus();

			TS.makeLinkVisited(uri, node);

			return false;
		}

		return __tabextensions__contentAreaClick(aEvent, aFieldNormalClicks);
	},
	
	// NNbN 
	// clicking of links
	handleLinkClick : function(aEvent, aURI, aNode)
	{
		var retVal = __tabextensions__handleLinkClick(aEvent, aURI, aNode);

		var saveClick = (aEvent.button == 0 && (TabbrowserService.getPref('ui.key.saveLink.shift') ? aEvent.shiftKey : aEvent.altKey ));
		var nullClick = (aEvent.button == 0 && aEvent.altKey);

		if (aEvent.button < 2 &&
			(!retVal || (retVal && !saveClick && !nullClick)))
			TabbrowserService.makeLinkVisited(aURI, aNode);

		return retVal;
	},
 
	messagePaneOnClick : function(aEvent) 
	{
		// ignore simple click, because new browser has been opened by customized contentAreaClick().
		var uri = hrefForClickEvent(aEvent);
		if (uri &&
			uri.match(/^(https?|ftp|file|gopher|chrome|resource|about):/i) &&
			aEvent.button == 0 &&
			!aEvent.metaKey &&
			!aEvent.ctrlKey &&
			!aEvent.shiftKey &&
			!aEvent.altKey) {
			TabbrowserService.stopEvent(aEvent);
		}

		window.__tabextensions__messagePaneOnClick(aEvent);
	},
  
	// window.open()̐ 
	
	newWindowOpen : function(aURI, aName, aFlags) 
	{
		if (window.shouldOpenBrowserTab(aURI, aName))
			return window.openBrowserTab(aURI, aName);

		var TS = TabbrowserService;

		// ignore disabled flags
		var flags = aFlags;
		var features = [
				'titlebar',
				'close',
				'toolbar',
				'location',
				'directories',
				'personalbar',
				'menubar',
				'scrollbars',
				'resizable',
				'minimizable',
				'status'
			],
			regexp = new RegExp();
		for (var i in features)
			if (TS.getPref('dom.disable_window_open_feature.'+features[i])) {
				flags = flags.replace(regexp.compile(features[i]+'=(0|false|no)?,?', 'gi'), '');
				if (flags.indexOf(features[i]) < 0)
					flags = flags ? flags + ',' + features[i] : features[i] ;
			}

		var w = (aFlags !== void(0)) ? this.__tabextensions__open(aURI, aName, (this.document.defaultView.top == window.top ? flags.replace(/(alwaysLowered|alwaysRaised|titlebar|z-lock)(=(0|1|true|false|yes|no))?,?/g, '') || void(0) : flags )) :
				this.__tabextensions__open(aURI, aName) ;

		// set real opener to prevent to reopen the new window in a tab
		if (TS.browserWindow &&
			TS.browserWindow != window)
			TS.browserWindow.__tabextensions__opener = this;
		if (w)
			w.__tabextensions__opener = this;

		return w;
	},
 
	newWindowSetTimeout : function() 
	{
		var exp   = arguments[0],
			delay = arguments[1],
			args = [];
		if (arguments.length > 2)
			for (var i = 2; i < arguments.length; i++)
				args.push(arguments[i] ? arguments[i].toSource() : arguments[i] );

		var id = (args.length) ? eval('this.__tabextensions__setTimeout(exp, delay, ' + args.join(',') + ');') : this.__tabextensions__setTimeout(exp, delay) ;

		if (this.document.readyState == 'complete')
			this.lastTimeoutIsAfterLoaded = true;

		return id;
	},
 
	newWindowSetInterval : function() 
	{
		var exp   = arguments[0],
			delay = arguments[1],
			args = [];
		if (arguments.length > 2)
			for (var i = 2; i < arguments.length; i++)
				args.push(arguments[i] ? arguments[i].toSource() : arguments[i] );

		var id = (args.length) ? eval('this.__tabextensions__setInterval(exp, delay, ' + args.join(',') + ');') : this.__tabextensions__setInterval(exp, delay) ;

		if (this.document.readyState == 'complete' &&
			!('lastTimeoutIsAfterLoaded' in this))
			this.lastTimeoutIsAfterLoaded = true;

		return id;
	},
 
	openBrowserTab : function(aURI, aName, aFlags) 
	{
		var contextWindow = this.document.defaultView;
		if (!contextWindow) contextWindow = this;

		var TS        = window.TabbrowserService;
		var uri       = aURI || 'about:blank' ;
		var sourceURI = ('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(contextWindow, 'location').call(contextWindow).href : contextWindow.location.href ;
		var event;

		var i;

		if (!uri.match(/^\w+:/))
			uri = TS.makeURLAbsolute(sourceURI, uri);
//			if (uri.match(/^\//))
//				uri = sourceURI.match(/^\w+:\/\/[^\/]*/)[0]+uri;
//			else
//				uri = sourceURI.match(/^\w+:\/\/[^\/]*\/([^\/]*\/)*/)[0]+uri;

		var shouldRejectPopups = TS.getPref('dom.disable_open_during_load');
		var shouldRejectDelay = TS.getPref('dom.disable_open_click_delay') || 0 ;

		try { // for Mozilla 1.2 later
			const nsIPopupWindowManager = Components.interfaces.nsIPopupWindowManager;
			const PopupManager = Components.classes['@mozilla.org/PopupWindowManager;1'].getService(nsIPopupWindowManager);
			if (PopupManager.testPermission(TS.makeURIFromSpec(sourceURI)) != nsIPopupWindowManager.DENY_POPUP)
				shouldRejectPopups = false;
		}
		catch(e) {
		}

		if  (
			( // when should not open tab
				'shouldOpenBrowserTab' in contextWindow &&
				!contextWindow.shouldOpenBrowserTab(uri, aName)
			) ||
			( // reject popup ads
				contextWindow != window && // called from content window
				(
					(contextWindow.document.tabbrowserReadyState != 'complete' && shouldRejectPopups) ||
					(
						shouldRejectPopups &&
						(
							shouldRejectDelay ||
							!('lastTimeoutIsAfterLoaded' in contextWindow)
						) &&
						'tabbrowserLastEvent' in contextWindow &&
						((new Date()).getTime() - contextWindow.tabbrowserLastEvent) > shouldRejectDelay
					) ||
					uri == sourceURI // When it seems to be a browser-crasher, ignore command.
				)
			)
			) {
			try {
				event = document.createEvent('PopupBlockedEvents');
				event.initPopupBlockedEvent('DOMPopupBlocked', true, true, TS.makeURIFromSpec(sourceURI), TS.makeURIFromSpec(uri));
				contextWindow.top.document.dispatchEvent(event);
			}
			catch(e) {
			}
//			dump('tabextensions:window.open is rejected\n');
			return null;
		}

		TS.uriSecurityCheck(uri, sourceURI);

		var referrer = TS.makeURIFromSpec(sourceURI);
		var name = !aName ? '_blank' : aName ;

		var w = null;


		var b = TS.browser,
			browser,
			parentTab;

		// prevent to open same URI
		if (TS.preventSameURLTab) {
			if (b.mCurrentTab.mTabInfo.loadingURI == uri)
				return b.mCurrentTab.mBrowser.contentDocument.defaultView;

			for (i in b.mTabs)
			{
				if (b.mTabs[i].mTabInfo.loadingURI != uri) continue;

				b.selectedTab = b.mTabs[i];
				return b.mTabs[i].mBrowser.contentDocument.defaultView;
			}
		}

		for (i in b.mTabs)
			if (b.mTabs[i].mBrowser.contentDocument.defaultView == this.top)
				parentTab = b.mTabs[i];


		// When a tab with the name exists, open in the tab.
		for (i in b.mTabs)
		{
			browser = b.mTabs[i].mBrowser;

			if (b.mTabs[i].browserName != name &&
				browser.contentDocument.defaultView.name != name) continue;

			var realURI = TS.getRealURI(uri);
			var bypassReferrerBlocker = realURI ? true : false ;
			if (realURI) uri = realURI;

			if (b.mTabs[i].mTabInfo.referrerBlocked || bypassReferrerBlocker)
				referrer = null;

//				uri = window.getShortcutOrURI(uri);
			browser.loadURI(uri, referrer);

			if (b.tabGroupsAvailable) b.attachTabTo(b.mTabs[i], parentTab, true);

			browser.contentDocument.defaultView.opener = contextWindow;
			if (name && !String(name).match(/^_(self|top|parent|blank|content)$/i))
				browser.contentDocument.defaultView.name = name;

//			dump('tabextensions:window.open is redirected to existing tab:'+uri+'\n');

			return browser.contentDocument.defaultView;
		}

		var t = b.addTabInternal(uri, referrer, { browserName : name });
		if (!t) return null;

		if (parentTab)
			b.attachTabTo(t, parentTab, true);

		var loadInBackground = TS.loadInBackgroundJS;
		if (!loadInBackground) b.selectedTab = t;

		w = t.mBrowser.contentDocument.defaultView;

		w.opener = contextWindow;
		if (name && !String(name).match(/^_(self|top|parent|blank|content)$/i))
			w.name = name;

		try {
			event = document.createEvent('Events');
			event.initEvent('PopupWindow', true, true);
			contextWindow.top.document.dispatchEvent(event);
		}
		catch(e) {
		}

		return w;
	},
 
	shouldOpenBrowserTab : function(aURI, aName) 
	{
		var topWin = ('Components' in window && 'lookupMethod' in Components) ? Components.lookupMethod(this, 'top').call(this) : this.top ;

		var inContent = this && topWin != window.top;
//		var inContent = this.document.defaultView && this.document.defaultView.top != window.top;

		var shouldPopup = false;
		if (aURI && inContent && window.TabbrowserService.winHookMode == 0)
			shouldPopup = window.TabbrowserService.shouldPopupWindowForURI(aURI);

		return (
			(
				!inContent &&
				(!aURI || !aURI.match(/^chrome:/)) && // not-registered resources
				(
					// unrequested open in single window mode
					window.TabbrowserService.winHookMode == 2 ||
					( // unrequested open in XUL windows
						window.TabbrowserService.winHookMode == 1 &&
						window.document.documentElement.namespaceURI != window.TabbrowserService.XULNS
					)
				)
			) ||
			// window.open of content windows
			(
				inContent &&
				!TabbrowserService.getFrameByName(topWin.frames, aName) &&
				(
					(window.TabbrowserService.winHookMode == 1 && this.document.tabbrowserReadyState != 'complete') ||
					window.TabbrowserService.winHookMode == 2 ||
					(window.TabbrowserService.opentabforJS && !shouldPopup)
				)
			)
			);
	},
 
	shouldPopupWindowForURI : function(aURI) 
	{
		if (aURI) {
			var ex = this.JSWindowOpenExceptions;
			for (var i = 0; i < ex.length; i++)
				if (aURI.indexOf(ex.getData(ex.item(i), 'Rule')) > -1)
					return true;
		}

		return false;
	},
  
	// browser.tabs.opentabfor.urlbar_always 
	BrowserLoadURL : function(aEvent)
	{
		var url    = gURLBar.value;
		var usetab = TabbrowserService.getPref('browser.tabs.opentabfor.urlbar_always', false);
		var b      = TabbrowserService.browser;

		if (!usetab ||
			!aEvent ||
			url.match(/^view-source:/) ||
			b.currentURI.spec == 'about:blank')
			return window.__tabextensions__BrowserLoadURL(aEvent);

		var isNewType = TabbrowserService.isNewTypeBrowser;

		// when ctrl or meta(command on Mac) is pressed, behavior is reversed.
		if (
			(isNewType && aEvent.altKey) ||
			(!isNewType && (aEvent.ctrlKey || aEvent.metaKey))
			) {
			var eventObj = {
					target   : aEvent.target,
					shiftKey : aEvent.shiftKey,
					altKey   : aEvent.altKey,
					ctrlKey  : aEvent.ctrlKey,
					metaKey  : aEvent.metaKey
				};
			if (isNewType)
				eventObj.altKey = false;
			else if (aEvent.ctrlKey)
				eventObj.ctrlKey = false;
			else
				eventObj.metaKey = false;

			return window.__tabextensions__BrowserLoadURL(eventObj);
		}

		var newTab = b.addTab(getShortcutOrURI(url));

		var loadInBackground = TabbrowserService.loadInBackgroundLocationBar;
		if (aEvent.shiftKey) loadInBackground = !loadInBackground;

		if (!loadInBackground) b.selectedTab = newTab;

		return true;
	},

/*
	handleURLBarCommand : function(aEvent)
	{
		if ('canonizeUrl' in window) canonizeUrl(aEvent);
		try {
			if ('addToUrlbarHistory' in window) addToUrlbarHistory();
		}
		catch(e) {
		}
		TabbrowserService.BrowserLoadURL(aEvent);
	},
*/
 
	BrowserOpenTab : function() 
	{
		if (window.gInPrintPreviewMode) return;

		var TS = TabbrowserService;
		var b  = TS.browser;

		var uri;
		try {
			if (TS.getPref('browser.tabs.extensions.observe.clipboard.newTab')) {
				var clipboardURI = TS.getURIFromClipboard();
				if (clipboardURI/* &&
					window.gTSObserveClipboardLastURI.value != clipboardURI*/) {
					var exists = false;
					for (var i in b.mTabs)
					{
						if (b.mTabs[i].mTabInfo.loadingURI != clipboardURI) continue;

						exists = true;
						break;
					}
					if (!exists) {
						uri = clipboardURI;
//						window.gTSObserveClipboardLastURI.value = uri;
					}
				}
			}
		}
		catch(e) {
		}

		if (!uri) {
			// 0 = blank, 1 = home, 2 = last, -1 = inherit
			var startup = TS.getPref('browser.tabs.loadOnNewTab');
			if (startup === null) // for 1.4a or earlier
				startup = TS.getPref('browser.tabs.extensions.startup.page');

			if (startup == -1 ||
				startup == 100) /* old implementation (for 1.4a or earlier) */
				startup = (TS.isNewTypeBrowser) ? 1 : TS.getPref('browser.startup.page') ;

			uri = 'about:blank';

			var shouldReplace = false;
			var replaceURI    = null;
			switch (startup)
			{
				default:
				case 0:
					if (!TS.getPref('browser.tabs.extensions.clear_location_bar'))
						replaceURI = b.currentURI.spec;
					else
						replaceURI = '';
					break;

				case 1:
					uri = getHomePage();
					if (typeof uri != 'string')
						uri = uri[0];
					if (TS.isNewTypeBrowser && uri.match(/.\|./))
						uri = uri.split('|')[0];

					if (uri == 'about:blank' &&
						TS.getPref('browser.tabs.extensions.clear_location_bar'))
						replaceURI = '';

					break;

				case 2:
					uri = b.currentURI.spec;
					break;
			}
		}

		b.selectedTab = b.addTab(uri);

		window.setTimeout(TS.BrowserOpenTabCallBack, 0, replaceURI, uri);
	},
	BrowserOpenTabCallBack : function(aShouldBeDisplayedURI, aLoadedURI)
	{
		if (aShouldBeDisplayedURI !== null)
			gURLBar.value = aShouldBeDisplayedURI;

		var navBar = document.getElementById('nav-bar');
		if (aLoadedURI == 'about:blank' &&
			!navBar.hidden &&
			window.locationbar.visible)
			gURLBar.focus();
		else
			content.focus();
	},
 
	BrowserCloseTabOrWindow : function() 
	{
		var browser = TabbrowserService.browser;
		if (
			browser &&
			browser.localName == 'tabbrowser' &&
			(
				browser.mTabs.length > 1 ||
				(
					TabbrowserService.getPref('browser.tabs.extensions.last_tab_closing') == 1 &&
					!browser.mCurrentTab.isReallyBlank
				)
			)
			) {
			browser.removeCurrentTab();
			return;
		}

		BrowserCloseWindow();
	},
 
	openLinkInNewTab : function(aURI, aLinkNode, aShouldActivateTab) 
	{
		if (!this.browserWindow) {
			window.openDialog(this.browserURI, '_blank', 'chrome,all,dialog=no', aURI);
			return;
		}

		var browser  = this.browserWindow.TabbrowserService.browser;

		var info = {};
		var openIn = this.getPref('browser.tabs.extensions.open_tab_in_link');
		if (openIn > -1)
			info.openIn = openIn;
		if (aLinkNode)
			info.parentTab = browser.mCurrentTab;

		var referrer = this.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null ;
		var tab      = browser.addTabInternal(aURI, referrer, info);

		if (aShouldActivateTab)
			browser.selectedTab = tab;

		this.makeLinkVisited(aURI, aLinkNode);
	},
 
	openNewTabWith_old : function(aURI, aShouldSendReferrer, aReverseBackgroundPref) 
	{
		urlSecurityCheck(aURI, document);

		var loadInBackground = TabbrowserService.loadInBackground;
		if (aReverseBackgroundPref)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, TabbrowserService.getLastActiveLink(), !loadInBackground);
	},
	
	openNewTabWith : function(aURI, aLinkNode, aEventOrFlag, aSecurityCheckOrEvent) 
	{ // OrFlag/OrEvent is for 0.4 before
		if (typeof aSecurityCheckOrEvent == 'boolean' &&
			aSecurityCheckOrEvent)
			urlSecurityCheck(aURI, document);

		var event = (typeof aEventOrFlag == 'object') ? aEventOrFlag : aSecurityCheckOrEvent ;

		var loadInBackground = TabbrowserService.loadInBackground;
		if (event && event.shiftKey)
			loadInBackground = !loadInBackground;

		TabbrowserService.openLinkInNewTab(aURI, aLinkNode, !loadInBackground);
	},
  
	openNewWindowWith : function(aURI, aShouldSendReferrer) 
	{
		urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = aShouldSendReferrer && TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer);

		TabbrowserService.makeLinkVisited(aURI, TabbrowserService.getLastActiveLink());
	},
	
	openNewWindowWith : function(aURI, aLinkNode) 
	{
		urlSecurityCheck(aURI, document);

		var charsetArg = null;
		if (TabbrowserService.isBrowserWindow)
			charsetArg = 'charset=' + window._content.document.characterSet;

		var referrer = TabbrowserService.shouldSendReferrerWithLinkClick() ? getReferrer(document) : null;
		window.openDialog(TabbrowserService.browserURI, '_blank', 'chrome,all,dialog=no', aURI, charsetArg, referrer);

		TabbrowserService.makeLinkVisited(aURI, aLinkNode);
	},
  
	openDialog : function() 
	{
		var uri = arguments.length ? arguments[0] : null ;
		var TS  = TabbrowserService;

		if (uri == TS.browserURI &&
			TS.winHookMode == 2 &&
			TS.isBrowserWindow) {
			var documentURI = arguments.length > 2 ? arguments[3] : null ;
			var referrer = arguments.length > 4 ? arguments[5] : null ;
			TS.browserWindow.TabbrowserService.browser.addTab(documentURI, referrer);
			return window;
		}

		var args = [];
		for (var i = 0; i < arguments.length; i++)
			args.push('arguments['+i+']');

/*
		window.childWindows.push(eval('__tabextensions__openDialog('+args.join(', ')+')'));
		return window.childWindows[window.childWindows.length-1];
*/
		return eval('__tabextensions__openDialog('+args.join(', ')+')');
	},
 
	// Tab Selection 
	ctrlNumberTabSelection : function(aEvent)
	{
		if (aEvent.altKey && aEvent.keyCode == KeyEvent.DOM_VK_RETURN) { // for WinXP
			aEvent.preventDefault();
			return;
		}

		var index = aEvent.charCode - 49,
			b     = TabbrowserService.browser;

		if (
			!aEvent.ctrlKey ||
//			!(TabbrowserService.isNewTypeBrowser || aEvent.shiftKey) || // firebird:ctrl+num, mozilla:ctrl+shift+num
			index < 0 || index > 8 || index >= b.mTabs.length // out of range
			)
			return;

		var oldTab = b.selectedTab;
		var newTab = b.mTabs[index];
		if (newTab != oldTab) {
			oldTab.selected = false;
			b.selectedTab = newTab;
		}

		TabbrowserService.stopEvent(aEvent);

		return;
	},
 
	Shutdown : function() 
	{
		// to remove "there is no observer for 'dl-start'" error
		var service = TabbrowserService.ObserverService;
		var observers = service.enumerateObservers('dl-start');
		if (TabbrowserService.isBrowserWindow &&
			'dlObserver' in window &&
			!observers.hasMoreElements()) {
			service.addObserver(dlObserver, 'dl-start', false);
		}
		window.__tabextensions__Shutdown();
	},
 
	goQuitApplication : function() 
	{
		var w = TabbrowserService.browserWindows;
		for (var i in w)
			w[i].TabbrowserService.onQuit = true;

		window.__tabextensions__goQuitApplication();
	},
  
	// g@\p̃\bh 
	
	// Context Menu 
	
	// I͈͂̃N^uŊJ 
	// open all links in the selection in tabs
	openAllLinksInTabs : function(aShouldGrouping)
	{
		var links = this.getSelectionLinks();
		if (!links.length) return;

		var targetWindow = document.commandDispatcher.focusedWindow;
		if (!targetWindow || targetWindow.top == window)
			targetWindow = window._content;

		var referrer = this.makeURIFromSpec(targetWindow.location.href);

		var w = this.browserWindow;
		var b = w ? w.TabbrowserService.browser : null ;

		var isGroupMode = this.isGroupMode;
		var rootTab = (isGroupMode && b && w == window) ? (b.mCurrentTab.rootTab || b.mCurrentTab) : null ;

		var i;

		if (b) {
			var t,
				info = {
					parentTab : (aShouldGrouping ? null : rootTab )
				},
				openIn = this.getPref('browser.tabs.extensions.open_tab_in_link');

			if (openIn > -1) info.openIn = openIn;

			for (i in links)
			{
				if (
					i == 0 &&
					b.currentURI.spec == 'about:blank' &&
					this.getPref('browser.tabs.extensions.open_first_in_current')
					) {
					t = b.mCurrentTab;
					t.mBrowser.loadURI(links[i].uri, referrer);
					if (info.parentTab)
						t.parentTab = info.parentTab;
				}
				else {
					t = b.addTabInternal(links[i].uri, referrer, info);
				}

				if (i == 0) {
					if (aShouldGrouping) info.parentTab = t;
					if ('openIn' in info) {
						switch (info.openIn)
						{
							case 1:
								info.openIn = 0;
								break;
							case 2:
								info.openIn = 3;
								break;
							default:
								break;
						}
					}
				}

				this.makeLinkVisited(links[i].uri, links[i].node);
			}
			var loadInBackground = TabbrowserService.loadInBackground;
			if (!loadInBackground) b.selectedTab = tabs[0];
		}
		else {
			for (i in links)
			{
				this.overflowingTabsManager.addTab(links[i].uri, referrer, { parentTab : aShouldGrouping });
				this.makeLinkVisited(links[i].uri, links[i].node);
			}
		}
	},
	
	// I͈͂̃NW 
	getSelectionLinks : function(aShouldRejectMailto)
	{
		var links = [];

		var targetWindow = document.commandDispatcher.focusedWindow;
		if (!targetWindow || targetWindow.top == window)
			targetWindow = window._content;

		var selection = targetWindow.getSelection();
		if (!selection ||
			!selection.rangeCount ||
			!selection.toString())
			return links;

// getRangeAt() cancels the selection, so I cannot use this simple statement...
//		var range = selection.getRangeAt(0);

		var range = targetWindow.document.createRange();
		try {
			range.setStart(selection.anchorNode, selection.anchorOffset);
			range.setEnd(selection.focusNode, selection.focusOffset);
		}
		catch(e) {
			range.setStart(selection.focusNode, selection.focusOffset);
			range.setEnd(selection.anchorNode, selection.anchorOffset);
		}
		var node    = this.getParentLink(range.startContainer) || range.startContainer;
		var endNode = this.getParentLink(range.endContainer) || range.endContainer;

		var uri;
		traceTree:
		do
		{
			if (this.isLinkNode(node)) {
				try { // sometimes fails when we click a string like URI in the end edge of block level elements. why?
					uri = this.makeURLAbsolute(node.baseURI, (node.getAttributeNS(this.XLinkNS, 'href') || node.getAttribute('href') || node.href || node));
					if ((!aShouldRejectMailto || !uri.match(/^mailto:/)) && uri)
						links.push({ node : node, uri : uri });
				}
				catch(e) {
				}
			}

			if (node.hasChildNodes()) {
				node = node.firstChild;
			}
			else {
				while (!node.nextSibling)
				{
					node = node.parentNode;
					if (!node) break traceTree;
				}
				node = node.nextSibling;
			}
//			dump(node+' / '+node.localName+'\n');
		}
		while (node != endNode);

		range.detach();

		return links;
	},
	getParentLink : function(aNode)
	{
		var node = aNode;
		while (!this.isLinkNode(node) && node.parentNode)
			node = node.parentNode;

		return this.isLinkNode(node) ? node : null ;
	},
	isLinkNode : function(aNode)
	{
		return (
				aNode.nodeType == Node.ELEMENT_NODE &&
				(
					aNode.getAttributeNS(this.XLinkNS, 'href') ||
					(
						aNode.localName.toLowerCase().match(/^(a|area|link)$/) &&
						(!aNode.namespaceURI || aNode.namespaceURI == this.XHTMLNS)
					)
				)
				);
	},
	makeURLAbsolute : function(aBase, aURI)
	{
		var baseURI = this.IOService.newURI(aBase, null, null);
		return this.IOService.newURI(baseURI.resolve(aURI), null, null).spec;
	},
  
	// I͈͂̃NubN}[NO[vƂēo^ 
	// bookmark selected links as a bookmark group
	bookmarkAllLinksAsGroup : function()
	{
		var links = this.getSelectionLinks(true);
		if (!links.length) return;

		var info = [];
		for (var i in links)
			info[i] = {
				name    : this.getInnerTextOf(links[i].node),
				url     : links[i].uri,
				charset : null
			};

		var currentInfo = info[0];
		currentInfo.forceToGroup = true;

		if (!this.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'centerscreen,chrome,dialog=yes,resizable,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup,group',
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'centerscreen,chrome,dialog=yes,resizable=no,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup',
				info
			);
	},
  
	// ^uO[vubN}[NO[vƂēo^ 
	// bookmark selected links as a bookmark group
	bookmarkTabGroup : function(aTab, aShouldBookmarkAllTabs)
	{
		if (!aTab || aTab.localName != 'tab')
			aTab = this.browser.mCurrentTab;
		if (!aTab.childTabs.length && aTab.parentTab)
			aTab = aTab.parentTab;

		var tabs = aShouldBookmarkAllTabs ? this.browser.mTabs : this.browser.gatherChildTabsOf(aTab);
		if (!tabs.length) return;

		if (!aShouldBookmarkAllTabs)
			tabs.unshift(aTab);

		tabs = tabs.sort(this.browser.conpareTabOrder);

		var info = [],
			b;
		for (var i in tabs)
		{
			b = tabs[i].mBrowser;
			info[i] = {
				name    : b.contentDocument.title || b.currentURI.spec,
				url     : b.currentURI.spec,
				charset : b.contentDocument.characterSet
			};
		}

		var currentInfo = info[0];
		currentInfo.forceToGroup = true;

//		if (!aShouldBookmarkAllTabs)
			this.browser.highlightGroupFromTab(aTab, true, true);

		if (!this.isNewTypeBrowser)
			window.openDialog(
				'chrome://communicator/content/bookmarks/addBookmark.xul',
				'',
				'modal,centerscreen,chrome,dialog=yes,resizable,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup,group',
				info
			);
		else
			window.openDialog(
				'chrome://browser/content/bookmarks/addBookmark2.xul',
				'',
				'modal,centerscreen,chrome,dialog=yes,resizable=no,dependent',
				currentInfo.name, currentInfo.url, null,
				currentInfo.charset, 'addGroup',
				info
			);

		this.browser.cancelHighlight();
	},
 
	// ̃EBhEURIJAg 
	// open the uri in a tab of existing window and close myself
	openTabInsteadSelf : function()
	{
		if (
			this.openerType == 'ContentWindow' &&
			(
				!this.browser ||
				!('mCurrentTab' in this.browser) ||
				!this.browser.mCurrentTab ||
				!('mTabInfo' in this.browser.mCurrentTab) ||
				!this.browser.mCurrentTab.mTabInfo ||
				!this.browser.mCurrentTab.mTabInfo.currentMethod
			)
			) {
			return;
		}
		if (
			this.openerType == 'ContentWindow' &&
			(
				(this.winHookMode == 1 && '__tabextensions__opener' in window) ||
				this.shouldPopupWindowForURI(this.browser.mCurrentTab.mTabInfo.loadingURI)
			)
			) {
			// uŊJꍇ̓uEU𕡐Jvݒ̎ŁAwindow.open()Weby[WJavaScriptJꂽEBhÉÄӎuŊĴƌȂA^uł͊JȂB
			delete window.__tabextensions__opener;
			window.clearInterval(this.openTabTimer);
			this.openerType = 'PlatformNative';

			this.browser.replaceReadStreamToData  = false;

			return;
		}
		delete window.__tabextensions__opener;

		var i, j, k;

		var uris      = [];
		var names     = [];
		var referrers = [];
		var postData  = [];
		var name, data;
		if (this.openerType == 'ContentWindow') {
			window.clearInterval(this.openTabTimer);
			for (i in this.browser.mTabs)
			{
				uris.push(this.browser.mTabs[i].mTabInfo.loadingURI);
				referrers.push(this.makeURIFromSpec(this.browser.mTabs[i].mTabInfo.loadingReferrerURI));

				name = this.browser.mTabs[i].mTabInfo.loadingName;
				names.push(name && name != '_blank' ? name : '' );

				if (this.browser.mTabs[i].mTabInfo.currentMethod != 'GET')
					postData[i] = this.browser.mTabs[i].mTabInfo.lastPostData;
				else
					postData[i] = null;

				if (!postData[i])
					postData[i] = {
						contentType : '',
						content     : '',
						method      : ''
					};
			}
		}
		else {
			if ('arguments' in window && window.arguments.length) {
				uris = window.arguments[0].split('\n');
				if (window.arguments.length > 3)
					for (i in uris)
						referrers.push(this.makeURIFromSpec(window.arguments[2]));
			}
			else {
				if (!this.openTabTimer) {
					this.browser.replaceReadStreamToData  = true;
					this.openTabTimer = window.setInterval('TabbrowserService.openTabInsteadSelf();', 100);
				}
				return;
			}
		}


		var nav = this.browserWindows;
		if (!uris.length || nav.length < 2) return;

		var b, t,
			lastTab,
			shouldRemoveFirst = false;
		for (i = 0; i < nav.length; i++)
		{
			if (
				nav[i] == window ||
				nav[i].TabbrowserService.openerType == 'ContentWindow' // if the window is opened from webpages, it seems to be a window opened by same opener.
				)
				continue;

			b = nav[i].TabbrowserService.browser;

			lastTab           = b.mCurrentTab;
			shouldRemoveFirst = (b.mTabs.length == 1);

			urisRoop:
			for (j = 0; j < uris.length; j++)
			{
				if (names[j]) {
					for (k in b.mTabs)
						if (b.mTabs[k] == names[j]) {
							t = b.mTabs[k];
							t.browserName = names[j];
							t.mBrowser.webNavigation.loadURI(uris[j], Components.interfaces.nsIWebNavigation.LOAD_FLAGS_NONE, referrers[j], b.createPostStream(postData[j], true), null);

							if (b.tabGroupsAvailable)
								b.attachTabTo(t, null, true);

							continue urisRoop;
						}
				}
				t = b.addTabInternal(
					uris[j],
					referrers[j],
					{
						browserName : (names[j] ? names[j] : null),
						postData    : postData[j]
					}
				);
				try {
					if (b.tabGroupsAvailable) b.attachTabTo(t, null, true);
				}
				catch(e) {
				}
			}

			if (t) {
				if (
					(this.openerType == 'ContentWindow' &&
					!this.loadInBackgroundJS) ||
					(this.openerType == 'PlatformNative' &&
					!this.loadInBackgroundNative) ||
					(this.openerType == 'XULWindow' &&
					!this.loadInBackground)
					)
					b.selectedTab = t;
			}

			if (this.loadInBackgroundNative) {
				if (!this.loadInBackgroundWindowNative)
					nav[i].focus();
			}
			else if (!this.loadInBackgroundWindow)
				nav[i].focus();

			if (shouldRemoveFirst && lastTab.isReallyBlank)
				b.removeTabInternal(lastTab, 'preventUndo=yes');

/*
			try{
				window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
					.getInterface(Components.interfaces.nsIWebNavigation)
					.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
					.QueryInterface(Components.interfaces.nsIDocShell)
					.QueryInterface(Components.interfaces.nsIBaseWindow)
					.contentViewer.hide();
			}
			catch(e){
				dump('TABEXTENSIONS: '+e+'\n');
*/
				try {
					window.minimize();
				}
				catch(ex) {
					dump('TABEXTENSIONS: '+ex+'\n');
				}
//			}

			// In some environments, "window.close" crashs Mozilla.
			// We have to use setTimeout to avoid this problem if "window.close" makes a crash.
			if (!this.getPref('browser.tabs.extensions.window_auto_close_timeout')) {
				try {
					this.setPref('browser.tabs.extensions.window_auto_close_timeout', true);
					window.close();
					this.setPref('browser.tabs.extensions.window_auto_close_timeout', false);
				}
				catch(e) {
				}
			}
			if (!window.closed)
				window.setTimeout('TabbrowserService.browser.stop(); window.close();', 100);

			break;
		}
	},
 
	// ^ȕԂubN}[NɋL 
	// save the status of locking/auto-reloading
	saveBookmarkStatus : function(aTabBrowser, aTab, aEntry)
	{
		if (!aTabBrowser || !aTab || !aEntry ||
			!aTab.mTabInfo.bookmarkID ||
			aTab.mTabInfo.bookmarkURI != aTab.mTabInfo.loadingURI ||
			!this.isBookmarked(aTab.mTabInfo.bookmarkID))
			return;

		var Bookmarks = this.RDF.GetDataSource('rdf:bookmarks');
		var resource  = this.RDF.GetResource(aTab.mTabInfo.bookmarkID);


		var props = [];

		if (aEntry == 'fixedLabel')
			props.push({
				name  : 'UseFixedLabel',
				value : (aTab.mTabInfo.fixedLabel ? true : void(0))
			});


		if (this.shouldSaveBookmarksStatus) {

			if (aEntry == 'locked')
				props.push({
					name  : 'Locked',
					value : (aTab.getAttribute('tab-locked') || void(0))
				});

			if (aEntry == 'referrerblocked') {
				props.push({
					name  : 'ReferrerBlocked',
					value : (aTab.getAttribute('tab-referrerblocked') || void(0))
				});
			}

			if (aEntry == 'autoreload') {
				props.push({
					name  : 'AutoReload',
					value : (aTab.getAttribute('tab-autoreload') || void(0))
				});
				props.push({
					name  : 'AutoReloadInterval',
					value : (aTab.getAttribute('tab-autoreload') ? aTab.mTabInfo.autoReloadInterval : void(0))
				});
			}

			if (aEntry.match(/^allow/) && this.shouldSaveBookmarksPermissions) {
				var subframes = Boolean(this.getPref('browser.frames.enabled'));
				if (aEntry != 'allowSubframes' || subframes)
					props.push({
						name  : aEntry.replace(/allow/, 'Forbid'),
						value : (!aTab.mBrowser.docShell[aEntry] || void(0))
					});
				else // for subframes
					props.push({
						name  : 'ForbidSubframes',
						value : (!aTab.mBrowser.docShell[aEntry] ? void(0) : false)
					});
			}

		}


		if (!props.length) return;

		for (var i in props)
			this.bookmarksData.setData(resource, props[i].name, props[i].value);

		if (!this.bookmarksData.dsource.ArcLabelsOut(resource).hasMoreElements()) {
			this.bookmarksData.container.RemoveElement(resource, true);
		}
	},
 
	// ^u̕ۑƕ 
	
	// ^u̓eۑ 
	saveAllTabs : function(aTabsHistory)
	{
try {
		if (!this.browser || !aTabsHistory) return;

		var i;

		// ŌɕۑꂽqXg폜
		// Remove old data.
		for (i = aTabsHistory.length-1; i > -1; i--)
			this.removeSHEntriesFrom(aTabsHistory.item(i), aTabsHistory);
		aTabsHistory.clearData();

		var t = this.browser.mTabs;
		if (t.length < 1) return;

		for (i = 0; i < t.length; i++)
			this.saveTabAt(i, aTabsHistory);
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.saveAllTabs()"\n\n'+e);
}
	},
	
	// nԖڂ̃^u̓eۑ 
	saveTabAt : function(aIndex, aTabsHistory)
	{
try {
		if (!aTabsHistory) return;

		var t = this.browser.mTabs[aIndex];
		if (!t) return;

		var id = t.tabId;
		var res = aTabsHistory.item(aIndex);
		if (!res) res = aTabsHistory.getResource(id);

		var info = this.browser.getTabInfo(t);


		// update tabgroup info
		aTabsHistory.setData(res, 'parentTab', info.parentTab);

		aTabsHistory.setData(res,
			'tabId',              info.id,

			'uri',                info.uri,
			'selected',           info.selected,
			'HistoryIndex',       info.SHIndex,

			'locked',             info.locked,
			'referrerBlocked',    info.referrerBlocked,
			'autoreloadInterval', info.autoreloadInterval,

			'allowPlugins',       info.allowPlugins,
			'allowJavascript',    info.allowJavascript,
			'allowMetaRedirects', info.allowMetaRedirects,
			'allowSubframes',     info.allowSubframes,
			'allowImages',        info.allowImages,

			'fixedLabel',         info.fixedLabel,

			'bookmarkID',         info.bookmarkID
		);

		this.saveSHEntriesFor(info.SHEntries, res, aTabsHistory);

		// failsafe... sometimes trash entries are saved (they have only "parentTab" value)
		if (!aTabsHistory.getData(res, 'tabId')) {
			try {
				aTabsHistory.removeData(res);
			}
			catch(e) {
				aTabsHistory.removeResource(res);
			}
		}

		aTabsHistory.flush();
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.saveTabAt()"\n\n'+e);
	alert(aIndex);
}
	},
  
	// ^u̓eČ 
	restoreAllTabs : function(aTabsHistory)
	{
try {
		if (this.browsers.length < 1) return;

		if (!aTabsHistory || !aTabsHistory.length) return;

		var i,
			res,
			id,
			entries = [];

		if (aTabsHistory == this.tabsBackupRoot) {
			for (i = 0; i < aTabsHistory.length; i++)
			{
				id = aTabsHistory.item(i).Value.match(/TabsBackup:window-\d+/)[0];

				if (id == this.tabsBackup.id) continue;

				entries[i] = new pRDFData(id, this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
			}

			if (entries.length)
				window.setTimeout(this.restoreAllTabsFromRoot, 0, this.tabsBackupRoot, entries);
		}
		else if (aTabsHistory == this.tabHistoryQuitRoot) {
			for (i = 0; i < aTabsHistory.length; i++)
			{
				id = aTabsHistory.item(i).Value.match(/TabsHistoryQuit:window-\d+/)[0];

				if (id == this.tabHistoryQuit.id) continue;

				entries[i] = new pRDFData(id, this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, true);
			}

			if (entries.length)
				window.setTimeout(this.restoreAllTabsFromRoot, 0, this.tabHistoryQuitRoot, entries);
		}
		else {
			var b = this.browser,
				t = b.mCurrentTab;

			b.removeAllTabsButInternal(t); // close other tabs

			this.restoreAllTabsFrom(aTabsHistory, t);
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.restoreAllTabs()"\n\n'+e);
}
	},
	
	// EBhEƂ̃qXgAꂼ̃EBhEŊJ 
	restoreAllTabsFromRoot : function(aRoot, aEntries)
	{
try {
		var b = TabbrowserService.browser,
			t = b.mCurrentTab,
			i, j;

		var doneFirst = false;
		for (i in aEntries) {
			if (!doneFirst) {
				b.removeAllTabsButInternal(t); // close other tabs
				doneFirst = true;
			}

			TabbrowserService.restoreAllTabsFrom(aEntries[i], i == 0 ? b.mCurrentTab : null );

			for (j = aEntries[i].length-1; j > -1; j--)
				TabbrowserService.removeSHEntriesFrom(aEntries[i].item(j), aEntries[i]);
			aEntries[i].clearData();
			aRoot.removeData(aEntries[i].containerNode);
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.restoreAllTabsFromRoot()"\n\n'+e);
}
	},
 
	// qXg^uČ 
	restoreAllTabsFrom : function(aTabsHistory, aRemoveTab)
	{
try {
		if (!aTabsHistory || !aTabsHistory.length) return;

		var b = this.browser,
			lastTab,
			childTab,
			res,
			info,
			entry,
			names, name, value, key,
			i, j;

		var idTable = [];

		for (i = 0; i < aTabsHistory.length; i++)
		{
try {
			res = aTabsHistory.item(i);

			info = {
				id                 : aTabsHistory.getData(res, 'tabId'),

				uri                : aTabsHistory.getData(res, 'uri'),
				index              : i,
				selected           : (aTabsHistory.getData(res, 'selected') == 'true'),
				SHEntries          : this.getSHEntriesFrom(res, aTabsHistory),
				SHIndex            : Number(aTabsHistory.getData(res, 'HistoryIndex')),

				parentTab          : (aTabsHistory.getData(res, 'parentTab') || null),
				childTabs          : [],

				locked             : (aTabsHistory.getData(res, 'locked') == 'true'),
				referrerBlocked    : (aTabsHistory.getData(res, 'referrerBlocked') == 'true'),
				autoreloadInterval : Number(aTabsHistory.getData(res, 'autoreloadInterval')),

				allowPlugins       : (aTabsHistory.getData(res, 'allowPlugins') == 'true'),
				allowJavascript    : (aTabsHistory.getData(res, 'allowJavascript') == 'true'),
				allowMetaRedirects : (aTabsHistory.getData(res, 'allowMetaRedirects') == 'true'),
				allowSubframes     : (aTabsHistory.getData(res, 'allowSubframes') == 'true'),
				allowImages        : (aTabsHistory.getData(res, 'allowImages') == 'true'),

				fixedLabel         : aTabsHistory.getData(res, 'fixedLabel'),

				bookmarkID         : aTabsHistory.getData(res, 'bookmarkID')
			};

			if (info.parentTab &&
				info.parentTab in idTable)
				info.parentTab = idTable[info.parentTab];

			lastTab = b.addTabWithTabInfo(info);

			idTable[info.id] = lastTab.tabId;

			if (info.selected) b.selectedTab = lastTab;

			if (i == 0 && aRemoveTab) {
				b.removeTabInternal(aRemoveTab, 'preventUndo=yes');
			}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.restoreAllTabsFrom()"\n'+res.Value+'\n\n'+e);
}
		}
}
catch(ex) {
	if (this.debug) alert('in "TabbrowserService.restoreAllTabsFrom()"\n\n'+ex);
}
	},
  
	saveSHEntriesFor : function(aEntries, aParentResource, aTabsHistory) 
	{
try {
		if (!aTabsHistory) return;

		var i, j,
			entry,
			old,
			data,
			entryResource,
			cacheKey;

		for (i = 0; i < aEntries.length; i++)
		{
			entry = aEntries[i];
			if (!entry) continue;

			entryResource = this.RDF.GetResource(aParentResource.Value+':'+i);
			old = aTabsHistory.dsource.GetTarget(entryResource, this.kRDF_ID, true);
			if (old) {
				old = old.QueryInterface(this.knsIRDFLiteral);
				if (old.Value == entry.id)
					continue;
				else // remove old entry
					this.removeSHEntriesFrom(entryResource, aTabsHistory);
			}

			data  = {
				URI             : entry.uri,
				title           : entry.title,
				isSubFrame      : entry.isSubFrame,
				saveLayoutState : entry.saveLayoutState,
				loadType        : entry.loadType,
				x               : entry.x,
				y               : entry.y
			};
			if (entry.cacheKey) {
				data.cacheKey        = entry.cacheKey;
				data.postContentType = entry.postContentType;
				data.postContent     = escape(this.WalletService ? this.WalletService.WALLET_Encrypt(entry.postContent) : entry.postContent );
			}
			else {
				data.cacheKey        = 0;
				data.postContentType = '';
				data.postContent     = '';
			}
			for (j in data)
			{
				old = aTabsHistory.dsource.GetTarget(entryResource, this['kRDF_'+j], true);
				if (old) {
					old = old.QueryInterface(this.knsIRDFLiteral);
					aTabsHistory.dsource.Change(
						entryResource,
						this['kRDF_'+j],
						old,
						this.RDF.GetLiteral(data[j]),
						true
					);
				}
				else
					aTabsHistory.dsource.Assert(
						entryResource,
						this['kRDF_'+j],
						this.RDF.GetLiteral(data[j]),
						true
					);
			}

			if (!aTabsHistory.dsource.HasAssertion(aParentResource, this.kRDF_HistoryEntry, entryResource, true))
				aTabsHistory.dsource.Assert(aParentResource, this.kRDF_HistoryEntry, entryResource, true);

			this.saveSHEntriesFor(aEntries[i].children, entryResource, aTabsHistory);
		}

		// remove old entries after the last entry
		var entries = aTabsHistory.dsource.GetTargets(aParentResource, this.kRDF_HistoryEntry, true);
		for (i = 0; entries.hasMoreElements(); i++)
		{
			entryResource = entries.getNext().QueryInterface(this.knsIRDFResource);
			if (i < aEntries.length) continue;

			this.removeSHEntriesFrom(entryResource, aTabsHistory);
			aTabsHistory.dsource.Unassert(aParentResource, this.kRDF_HistoryEntry, entryResource, true);
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.saveSHEntriesFor()"\n\n'+e);
}
	},
 
	removeSHEntriesFrom : function(aParentResource, aTabsHistory) 
	{
try {
		if (!aParentResource || !aTabsHistory) return;

		var children = aTabsHistory.dsource.GetTargets(aParentResource, this.kRDF_HistoryEntry, true);
		var child, names, name, value;
		while (children.hasMoreElements())
		{
			child = children.getNext().QueryInterface(this.knsIRDFResource);

			aTabsHistory.dsource.Unassert(aParentResource, this.kRDF_HistoryEntry, child);

			this.removeSHEntriesFrom(child, aTabsHistory);

			names = aTabsHistory.dsource.ArcLabelsOut(child);
			while (names.hasMoreElements())
			{
				try {
					name = names.getNext().QueryInterface(this.knsIRDFResource);
					value = aTabsHistory.dsource.GetTarget(child, name, true);
					aTabsHistory.dsource.Unassert(child, name, value);
				}
				catch(ex) {
					dump(ex+'\n');
				}
			}
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.removeSHEntriesFrom()"\n\n'+e);
}
	},
 
	getSHEntriesFrom : function(aParentResource, aTabsHistory) 
	{
try {
		var entries = [],
			entry;

		if (!aTabsHistory || !aParentResource) return entries;

		var children = aTabsHistory.dsource.GetTargets(aParentResource, this.kRDF_HistoryEntry, true);
		var child,
			cacheKey,
			postContent;
		while (children.hasMoreElements())
		{
			child = children.getNext().QueryInterface(this.knsIRDFResource);
			entries[entries.length] = {
				uri             : this.getLiteral(aTabsHistory, child, this.kRDF_URI),
				title           : this.getLiteral(aTabsHistory, child, this.kRDF_title),
				isSubFrame      : (this.getLiteral(aTabsHistory, child, this.kRDF_isSubFrame) == 'true'),
				saveLayoutState : (this.getLiteral(aTabsHistory, child, this.kRDF_saveLayoutState) == 'true'),
				loadType        : parseInt(this.getLiteral(aTabsHistory, child, this.kRDF_loadType)),
				x               : parseInt(this.getLiteral(aTabsHistory, child, this.kRDF_x)),
				y               : parseInt(this.getLiteral(aTabsHistory, child, this.kRDF_y)),
				children        : this.getSHEntriesFrom(child, aTabsHistory)
			};

			cacheKey    = parseInt(this.getLiteral(aTabsHistory, child, this.kRDF_cacheKey));
			postContent = escape(this.WalletService ? this.WalletService.WALLET_Encrypt(this.getLiteral(aTabsHistory, child, this.kRDF_postContent)) : this.getLiteral(aTabsHistory, child, this.kRDF_postContent) );
			try {
				if (postContent)
					postContent = this.WalletService ? unescape(postContent) : unescape(this.WalletService.WALLET_Decrypt(postContent));
			}
			catch(e) {
			}
			if (cacheKey && postContent) {
				entries[entries.length-1].cacheKey        = cacheKey;
				entries[entries.length-1].postContentType = this.getLiteral(aTabsHistory, child, this.kRDF_postContentType);
				entries[entries.length-1].postContent     = postContent;
			}
			else {
				entries[entries.length-1].cacheKey        = 0;
				entries[entries.length-1].postContentType = '';
				entries[entries.length-1].postContent     = '';
			}
		}
}
catch(e) {
	if (this.debug) alert('in "TabbrowserService.getSHEntriesFrom()"\n\n'+e);
}
		return entries;
	},
	getLiteral : function(aTabsHistory, aResource, aName) {
		try {
			return aTabsHistory.dsource.GetTarget(aResource, aName, true).QueryInterface(this.knsIRDFLiteral).Value;
		}
		catch(e) {
		}
		return '';
	},
  
	// ^uZbgz_[̏ 
	initStoredTabSets : function()
	{
		// init data
		this.storedTabSets = [];
		var root = this.storedTabSetsRoot,
			id;
		for (var i = 0; i < root.length; i++)
		{
			id = root.item(i).Value.match(/StoredTabSets:tabset-\d+/)[0];

			if (!id) continue;

			this.storedTabSets[id] = new pRDFData(id, this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, false);
		}

		if (document.getElementById('tabextensions-tabsetMenu'))
			return;


		// create "Tab Sets" menu in the "Go" menu
		var bmMenu = document.getElementById('BookmarksMenu') || document.getElementById('bookmarks-menu');
		if (!bmMenu) return;

		var goPopup = bmMenu.previousSibling.firstChild;
		if (!goPopup) return;

		// create menu
		var menu = document.createElement('menu');
		var seps = goPopup.getElementsByTagName('menuseparator');
		if (!seps.length) return;

		goPopup.insertBefore(menu, seps[0]);
		goPopup.insertBefore(document.createElement('menuseparator'), menu);

		menu.id = 'tabextensions-tabsetMenu';
		menu.setAttribute('label', this.strbundle.GetStringFromName('tabSetsHolder_menu_label'));
		menu.setAttribute('accesskey', this.strbundle.GetStringFromName('tabSetsHolder_menu_accesskey'));
		menu.setAttribute('key', 'key_tabextensions_storedTabSet_openMenu');

		// create menupopup
		var popup = menu.appendChild(document.createElement('menupopup'));
		popup.setAttribute('style', 'max-width:28em');
		popup.setAttribute('oncommand', 'TabbrowserService.loadStoredTabSet(event.target.value);');
		popup.setAttribute('onclick', 'if (event.button != 0) TabbrowserService.renameStoredTabSet(event.target.value, event);');
		popup.setAttribute('onpopupshowing', 'if (event.target == this) TabbrowserService.initTabSetsMenu(this); event.preventBubble();');
		popup.setAttribute('onpopuphiding', 'event.preventBubble();');

		var original = document.getElementById('tabextensions-tabsetMenu-shortcut');
		for (i = 0; i < original.childNodes.length; i++)
		{
			original.childNodes[i].id = '';
			if (original.childNodes[i].hasChildNodes())
				original.childNodes[i].firstChild.id = '';
			popup.appendChild(original.childNodes[i].cloneNode(true));
		}
	},
	
	loadStoredTabSet : function(aID) 
	{
		if (!aID) return;

		this.restoreAllTabs(this.storedTabSets[aID]);
	},
 
 	renameStoredTabSet : function(aID, aEvent) 
	{
		if (!aID) return;

		var old = this.storedTabSetsRoot.getData(this.storedTabSets[aID].containerNode, 'Label');

		if (aEvent && aEvent.type == 'click' && aEvent.button == 1) {
			var node = aEvent.target.parentNode;
			while (node.localName == 'menupopup' ||
					node.localName == 'popup')
			{
				node.hidePopup();
				node = node.parentNode.parentNode;
			}
		}

		var label = { value : old };
		if (!this.PromptService.prompt(
				window,
				this.strbundle.GetStringFromName('tabSetsHolder_rename_title'),
				this.strbundle.GetStringFromName('tabSetsHolder_rename_text'),
				label,
				null,
				{}
			))
			return;

		if (label.value && label.value != old)
			this.storedTabSetsRoot.setData(this.storedTabSets[aID].containerNode, 'Label', label.value);
	},
 
	saveCurrentTabSet : function(aShouldShowAlert) 
	{
		var id = 'StoredTabSets:tabset-'+Math.floor(Math.random() * 100000);
		this.storedTabSets[id] = new pRDFData(id, this.datasource.URI, 'seq', 'http://white.sakura.ne.jp/~piro/rdf#', 'chrome://tabextensions/content/tabextensions.rdf#', null, false);

		var d    = new Date();
		var date = [
				d.getFullYear(), '/', d.getMonth()+1, '/', d.getDate(), ' ',
				d.getHours(), ':', d.getMinutes(), ':', d.getSeconds()
			].join('');

		var titles = [];
		for (var i in this.browser.mTabs)
			titles.push(['"', this.browser.mTabs[i].label, '"'].join(''));

		var label = [
				date,
				titles.join(', ')
			].join(' ');

		window.setTimeout(this.saveCurrentTabSetCallBack, 0, id, label, aShouldShowAlert);
	},
	
	saveCurrentTabSetCallBack : function(aID, aLabel, aShouldShowAlert) 
	{
		var TS = TabbrowserService;
		TS.saveAllTabs(TS.storedTabSets[aID]);

		TS.storedTabSetsRoot.setData(TS.storedTabSets[aID].containerNode, 'Label', aLabel);

		TS.ObserverService.notifyObservers(window, 'tabextensions:storedTabSetsModified', null);

		if (!aShouldShowAlert) return;

		TS.PromptService.alert(
			window,
			TS.strbundle.GetStringFromName('tabSetsHolder_save_alert_title'),
			TS.strbundle.GetStringFromName('tabSetsHolder_save_alert_text')
		);
	},
  
	removeStoredTabSet : function(aID) 
	{
		if (!aID) return;

		for (var i = this.storedTabSets[aID].length-1; i > -1; i--)
			this.removeSHEntriesFrom(this.storedTabSets[aID].item(i), this.storedTabSets[aID]);
		this.storedTabSets[aID].clearData();
		this.storedTabSetsRoot.removeData(this.storedTabSets[aID].containerNode);
		delete this.storedTabSets[aID];

		this.ObserverService.notifyObservers(window, 'tabextensions:storedTabSetsModified', null);
	},
 
	removeAllStoredTabSet : function() 
	{

		if (!this.PromptService.confirm(
				window,
				this.strbundle.GetStringFromName('tabSetsHolder_deleteAll_confirm_title'),
				this.strbundle.GetStringFromName('tabSetsHolder_deleteAll_confirm_text')
			))
			return;

		for (var i in this.storedTabSets)
			this.removeStoredTabSet(this.storedTabSets[i].containerNode.QueryInterface(this.knsIRDFResource).Value.match(/StoredTabSets:tabset-\d+/)[0]);
	},
 
	initTabSetsMenu : function(aPopup) 
	{
		if (!aPopup) return;

		var full   = aPopup.getElementsByAttribute('tabid', 'full')[0],
			sep    = aPopup.getElementsByAttribute('tabid', 'sep')[0],
			rename = aPopup.getElementsByAttribute('tabid', 'rename')[0],
			del    = aPopup.getElementsByAttribute('tabid', 'delete')[0],
			delAll = aPopup.getElementsByAttribute('tabid', 'deleteAll')[0];

		while (aPopup.firstChild.localName == 'menuitem')
			aPopup.removeChild(aPopup.firstChild);

		while (full.firstChild.hasChildNodes())
		{
			full.firstChild.removeChild(full.firstChild.lastChild);
			rename.firstChild.removeChild(rename.firstChild.lastChild);
			del.firstChild.removeChild(del.firstChild.lastChild);
		}

		var item,
			count         = 0,
			tabSetsLength = this.storedTabSetsRoot.length;
		for (var i in this.storedTabSets)
		{
			item = document.createElement('menuitem');
			item.setAttribute('label', this.storedTabSetsRoot.getData(this.storedTabSets[i].containerNode, 'Label'));
			item.setAttribute('value', this.storedTabSets[i].containerNode.QueryInterface(this.knsIRDFResource).Value.match(/StoredTabSets:tabset-\d+/)[0]);
			item.setAttribute('crop', 'end');

			if (count > tabSetsLength-11) {
				item.setAttribute('label', [tabSetsLength-count-1, item.getAttribute('label')].join(' : '));
				item.setAttribute('accesskey', tabSetsLength-count-1);
			}

			if (count) {
				full.firstChild.insertBefore(item, full.firstChild.firstChild);
				rename.firstChild.insertBefore(item.cloneNode(true), rename.firstChild.firstChild);
				del.firstChild.insertBefore(item.cloneNode(true), del.firstChild.firstChild);
			}
			else {
				full.firstChild.appendChild(item);
				rename.firstChild.appendChild(item.cloneNode(true));
				del.firstChild.appendChild(item.cloneNode(true));
			}

			if (count > tabSetsLength-11)
				item = aPopup.insertBefore(item.cloneNode(true), aPopup.firstChild);

			count++;
		}

		if (del.firstChild.hasChildNodes()) {
			sep.removeAttribute('hidden');
			rename.removeAttribute('disabled');
			del.removeAttribute('disabled');
			delAll.removeAttribute('disabled');
		}
		else {
			sep.setAttribute('hidden', true);
			rename.setAttribute('disabled', true);
			del.setAttribute('disabled', true);
			delAll.setAttribute('disabled', true);
		}

		if (full.firstChild.hasChildNodes() &&
			full.firstChild.childNodes.length > aPopup.childNodes.length-7)
			full.removeAttribute('hidden');
		else
			full.setAttribute('hidden', true);
	},
  
	// ^u̗ 	
	initClosedTabsHistory : function()
	{
		// create "Closed Tabs History" menu in the "Go" menu
		var tabsetMenu = document.getElementById('tabextensions-tabsetMenu');
		if (!tabsetMenu) return;

		var menu = document.createElement('menu');
		tabsetMenu.parentNode.insertBefore(menu, tabsetMenu.nextSibling);

		menu.id = 'tabextensions-closedTabsHistory';
		menu.setAttribute('label', this.strbundle.GetStringFromName('closedTabsHistory_menu_label'));
		menu.setAttribute('accesskey', this.strbundle.GetStringFromName('closedTabsHistory_menu_accesskey'));
		menu.setAttribute('key', 'key_tabextensions_closedTabsHistory_openMenu');

		// create menupopup
		var popup = menu.appendChild(document.createElement('menupopup'));
		popup.setAttribute('style', 'max-width:24em');
		popup.setAttribute('oncommand', 'TabbrowserService.reopenTabById(event.target.value, event);');
		popup.setAttribute('onclick', 'TabbrowserService.reopenTabById(event.target.value, event);');
		popup.setAttribute('onpopupshowing', 'if (event.target == this) TabbrowserService.initClosedTabsHistoryMenu(this); event.preventBubble();');
		popup.setAttribute('onpopuphiding', 'event.preventBubble();');

		var original = document.getElementById('tabextensions-closedTabsHistory-shortcut');
		for (var i = 0; i < original.childNodes.length; i++)
		{
			original.childNodes[i].id = '';
			if (original.childNodes[i].hasChildNodes())
				original.childNodes[i].firstChild.id = '';
			popup.appendChild(original.childNodes[i].cloneNode(true));
		}
	},
	
	reopenTabById : function(aID, aEvent) 
	{
		if (!aID ||
			aEvent.type == 'click' && aEvent.button != 1) return;

		var info;
		for (var i in window.gTSGlobalUndoRemoveTabCache)
			if (window.gTSGlobalUndoRemoveTabCache[i].id == aID) {
				info = window.gTSGlobalUndoRemoveTabCache[i];
				window.gTSGlobalUndoRemoveTabCache.splice(i, 1);
				break;
			}

		if (!info) return;

		var t      = this.browser.mCurrentTab;
		var newTab = this.browser.addTabWithTabInfo(info);

		if (t.isReallyBlank) {
			this.browser.moveTabTo(newTab, Number(t.ordinal))
			this.browser.removeTab(t);
		}

		if (aEvent.type != 'click' || aEvent.button != 1)
			this.browser.selectedTab = newTab;

		if (aEvent.type == 'click' && aEvent.button == 1) {
			var node = aEvent.target.parentNode;
			while (node.localName == 'menupopup' ||
					node.localName == 'popup')
			{
				node.hidePopup();
				node = node.parentNode.parentNode;
			}
		}
	},
 
	initClosedTabsHistoryMenu : function(aPopup) 
	{
		if (!aPopup) return;

		var i,
			blank = aPopup.getElementsByAttribute('tabid', 'blank')[0],
			full  = aPopup.getElementsByAttribute('tabid', 'full')[0];

		while (aPopup.firstChild != blank)
			aPopup.removeChild(aPopup.firstChild);

		while (full.firstChild.hasChildNodes())
			full.firstChild.removeChild(full.firstChild.lastChild);

		var item,
			list = gTSGlobalUndoRemoveTabCache;
		for (i = list.length-1; i > -1; i--)
		{
			item = document.createElement('menuitem');
			item.setAttribute('label', list[i].label);
			item.setAttribute('value', list[i].id);
			item.setAttribute('crop',  'center');

			if (i > list.length-11) {
				item.setAttribute('label', [list.length-i-1, item.getAttribute('label')].join(' : '));
				item.setAttribute('accesskey', list.length-i-1);
			}

			full.firstChild.appendChild(item);

			if (i > list.length-11)
				item = aPopup.insertBefore(item.cloneNode(true), blank);
		}

		if (full.firstChild.hasChildNodes())
			blank.setAttribute('hidden', true);
		else
			blank.removeAttribute('hidden');

		if (full.firstChild.hasChildNodes() &&
			full.firstChild.childNodes.length > aPopup.childNodes.length-2)
			full.removeAttribute('hidden');
		else
			full.setAttribute('hidden', true);
	},
  
	// ŋ߃ANeBuuEUEBhE^uRs[ 
	copyTabsFrom : function(aWindow)
	{
		var sourceBrowser = aWindow.TabbrowserService.browser,
			firstTab      = this.browser.mCurrentTab,
			b             = this.browser,
			info,
			lastTab;

		b.removeAllTabsButInternal(firstTab); // close other tabs

		for (var i in sourceBrowser.mTabs)
		{
			info    = sourceBrowser.getTabInfo(sourceBrowser.mTabs[i]);
			lastTab = b.addTabWithTabInfo(info);
			if (info.selected) b.selectedTab = lastTab;
		}

		b.removeTabInternal(firstTab, 'preventUndo=yes');
	},
 
	// EBhEOɊmF 
	// confirm when the window contains tabs
	onWindowClose : function(aEvent)
	{
		var TS = TabbrowserService;

		if (TS.windowClosing) return;
		TS.windowClosing = true;

		var b  = TS.browsers;
		var check, result;

		if (!TS.destructed && b.length > 0) {
			for (var i = 0; i < b.length; i++)
			{
				if (b[i].mTabs.length < 2) continue;

				check  = { value: TS.getPref('browser.tabs.extensions.cancel_windowclose') != -1 };
				if (check.value) {
					result = TS.getPref('browser.tabs.extensions.cancel_windowclose');
					if (result) {
						var statusText = TS.strbundle.GetStringFromName('message_cancel_windowclose').replace(/%s/gi, b[i].mTabs.length-1);
						var status = document.getElementById('statusbar-display');
						if (status)
							status.label = statusText;
						else
							window.status = statusText;

						try {
							var sound = Components.classes['@mozilla.org/sound;1'].createInstance(Components.interfaces.nsISound);
							sound.beep();
						}
						catch(e) {
						}
					}
				}
				else {
					result = TS.PromptService.confirmEx(
							window,
							TS.strbundle.GetStringFromName('message_confirm_windowclose_title'),
							TS.strbundle.GetStringFromName('message_confirm_windowclose_text').replace(/%s/gi, b[i].mTabs.length),
							(TS.PromptService.BUTTON_TITLE_IS_STRING * TS.PromptService.BUTTON_POS_0) +
							(TS.PromptService.BUTTON_TITLE_CANCEL * TS.PromptService.BUTTON_POS_1),
							TS.strbundle.GetStringFromName('message_confirm_windowclose_ok'),
							null,
							null,
							TS.strbundle.GetStringFromName('message_never_show_dialog'),
							check
						);
					if (check.value && result != -1)
						TS.setPref('browser.tabs.extensions.cancel_windowclose', result);
				}

				if (result == 0)
					break;
				else {
					aEvent.preventDefault();
					aEvent.preventBubble();
					aEvent.preventCapture();
					aEvent.stopPropagation();

					window.setTimeout(function() { TabbrowserService.windowClosing = false; }, 100);
					return;
				}
			}
		}

		// failsafe
		if (TS.initialized &&
			!TS.destructed)
			TS.destruct();
	},
	windowClosing : false,
 
	onWindowResize : function(aEvent) 
	{
		if (aEvent.target == window ||
			aEvent.target == document ||
			aEvent.target.ownerDocument == document)
			TabbrowserService.browser.onTabsModified();
	},
 
	//Nbv{[h̊Ď 
	observeClipboard : function()
	{
		// if the window is not top-level browser window, don't open tab
		var TS = TabbrowserService;

		var w = TS.browserWindowsWithZOrder;
		if (!w || !w.length || window != w[0]) return;

		var uri = TS.getURIFromClipboard();
		if (!uri || uri == window.gTSObserveClipboardLastURI.value)
			return;

		var b = TS.browser;
		var browsers = b.browsers;
		for (var i = 0; i < browsers.length; i++)
			if (browsers[i].currentURI.spec == uri)
				return;

		if (b.mCurrentTab.isReallyBlank)
			b.mCurrentTab.mBrowser.loadURI(uri);
		else {
			var t = TS.browser.addTab(uri);
			if (!TS.getPref('browser.tabs.extensions.loadInBackgroundObserveClipbard'))
				TS.browser.selectedTab = t;
		}

		if (!TS.getPref('browser.tabs.extensions.loadInBackgroundWindowObserveClipbard'))
			window.focus();

		window.gTSObserveClipboardLastURI.value = uri;
	},
	observeClipboardTimer : null,
  
	destruct : function() 
	{
		var i;

		if (this.shoulBackupTabs) {
			for (i = this.tabsBackup.length-1; i > -1; i--)
				this.removeSHEntriesFrom(this.tabsBackup.item(i), this.tabsBackup);
			this.tabsBackup.clearData();
			this.tabsBackupRoot.removeData(this.tabsBackup.containerNode);
		}

		var nav = this.browserWindows;
		if (
			(
				(!nav.length && this.isBrowserWindow) ||
				(nav.length == 1 && nav[0] == window)
			) &&
			(
				!this.startWithOpenURLRequest ||
				!this.getPref('browser.tabs.extensions.restore_last_visited_tabs_ignore_OpenURL_requests') ||
				this.browser.mTabs.length > 1 ||
				this.browser.mRemovedTabInfoList.length > 1 ||
				(
					this.browser.mTabs.length == 1 &&
					this.browser.mRemovedTabInfoList.length == 1 &&
					!this.browser.mCurrentTab.isReallyBlank
				)
			)
			)
			this.saveAllTabs(this.tabHistory);

		if (this.isBrowserWindow) {
			if (this.onQuit) {
				this.saveAllTabs(this.tabHistoryQuit);
			}
			else {
				for (i = this.tabHistoryQuit.length-1; i > -1; i--)
					this.removeSHEntriesFrom(this.tabHistoryQuit.item(i), this.tabHistoryQuit);
				this.tabHistoryQuit.clearData();
				this.tabHistoryQuitRoot.removeData(this.tabHistoryQuit.containerNode);
			}
		}

		this.removePrefListener(gTSGeneralPrefListener);

		if (this.isBrowserWindow) {
			this.removePrefListener(gTSTabHistoryQuitPrefListener);
			this.removePrefListener(gTSTabsBackupPrefListener);
			this.removePrefListener(gTWindowModePrefListener);
			this.removePrefListener(gTSOpenTabForWindowOpenPrefListener);
			this.removePrefListener(gTSObserveClipboardPrefListener);

			if (navigator.platform.indexOf('Linux') < 0) {
				window.removeEventListener('dragover', this.onTabbarDragOver, true);
				window.removeEventListener('dragdrop', this.onTabbarDrop, true);
			}

			try {
//				this.ObserverService.removeObserver(gTSDomWindowOpenObserver, 'domwindowopened', false);
				this.ObserverService.removeObserver(gTSStoredTabSetsListener, 'tabextensions:storedTabSetsModified', false);
			}
			catch(e) {
			}
			window.removeEventListener('XULTabbrowserUndoCacheAdded', this.onXULTabbrowserUndoCacheModified, true);
			window.removeEventListener('XULTabbrowserUndoCacheRemoved', this.onXULTabbrowserUndoCacheModified, true);
		}
		if (this.browser) {
			this.removePrefListener(gTSCloseBoxPrefListener);
			this.removePrefListener(gTSLastTabClosingPrefListener);
			this.removePrefListener(gTSTabsAutoHidePrefListener);
			this.removePrefListener(gTSIconOverlayInTabsPrefListener);
			this.removePrefListener(gTSShowTabbarInBottomPrefListener);
			this.removePrefListener(gTSGroupModePrefListener);
			this.removePrefListener(gTSTabsWidthPrefListener);
			this.removePrefListener(gTSTabScrollbarPrefListener);

			window.removeEventListener('resize', this.onWindowResize, false);
		}

		this.BookmarksDS.RemoveObserver(gTSBookmarksObserver);

/*
		var b = this.browserWindows,
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].childWindows.length; j++)
				if (b[i].childWindows[j] == window)
					b[i].childWindows.splice(j, 1);
*/

		window.removeEventListener('close', this.onWindowClose, false);


		if (this.isNewTypeBrowser) {
			var toolbars = document.getElementsByTagName('toolbar');
			for (i = 0; i < toolbars.length; i++)
				toolbars[i].removeEventListener('TSToolbarItemInserted', gTSToolbarItemsInsertedEventListener, false);
		}


		var b = this.browsers;
		for (i = 0; i < b.length; i++)
		{
			b[i].removeEventListener('close', this.onTabbrowserWindowClose, true);
			b[i].removeEventListener('unload', this.onTabbrowserWindowUnload, true);

			b[i].removeEventListener('XULTabbrowserTabLoading', this.onXULTabbrowserTabLoading, false);
			b[i].removeEventListener('XULTabbrowserTabLoad', this.onXULTabbrowserTabLoad, false);
			b[i].removeEventListener('XULTabbrowserTabAdded', this.onXULTabbrowserTabAdded, false);
			b[i].removeEventListener('XULTabbrowserTabRemoved', this.onXULTabbrowserTabRemoved, false);
			b[i].removeEventListener('XULTabbrowserTabReordered', this.onXULTabbrowserTabReordered, false);
//			b[i].removeEventListener('XULTabbrowserTabGroupModified', this.onXULTabbrowserTabGroupModified, false);
			b[i].removeEventListener('XULTabbrowserTabStatusChange', this.onXULTabbrowserTabStatusChange, false);
			b[i].removeEventListener('XULTabbrowserTabDrop', this.onXULTabbrowserTabDrop, false);
			b[i].removeEventListener('XULTabbrowserURIDrop', this.onXULTabbrowserURIDrop, false);
			b[i].removeEventListener('XULTabbrowserAddTabCanceled', this.onXULTabbrowserAddTabCanceled, false);
		}

		this.destructed = true;
	}
 
}; 
 
// Listeners and Observers 
	
// Pref Listeners 
	
var gTSGeneralPrefListener = 
{
	domain  : 'browser.tabs.extensions.autoConfigDDESupport',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		if (!TS.getPref('browser.tabs.extensions.autoConfigDDESupport'))
			TS.clearPref('advanced.system.supportDDEExec');
	}
};
 
var gTSTabHistoryQuitPrefListener = 
{
	domain  : 'browser.tabs.extensions.restore_last_visited_tabs',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		if (TS.shoulBackupTabs) {
			var nullPointer = TS.tabHistoryQuit;
			window.setTimeout(
				function()
				{
					TS.tabHistoryQuitRoot.push(TS.tabHistoryQuit.containerNode);
					TS.saveAllTabs(TS.tabHistoryQuit);
					TS.tabHistoryQuitInitialized = true;
				},
				0
			);
		}
		else if (TS.tabHistoryQuitInitialized) {
			for (var i = this.tabHistoryQuit.length-1; i > -1; i--)
				TS.removeSHEntriesFrom(TS.tabHistoryQuit.item(i), TS.tabHistoryQuit);
			TS.tabHistoryQuit.clearData();
			TS.tabHistoryQuitRoot.removeData(TS.tabHistoryQuit.containerNode);
			TS.tabHistoryQuit = null;
		}
	}
};
 
var gTSTabsBackupPrefListener = 
{
	domain  : 'browser.tabs.extensions.backup_tabs',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;

		if (TS.shoulBackupTabs) {
			var nullPointer = TS.tabsBackup;
			window.setTimeout(
				function()
				{
					TS.tabsBackupRoot.push(TS.tabsBackup.containerNode);
					TS.saveAllTabs(TS.tabsBackup);
					TS.tabsBackupInitialized = true;
				},
				0
			);
		}
		else if (TS.tabsBackupInitialized) {
			for (var i = this.tabsBackup.length-1; i > -1; i--)
				TS.removeSHEntriesFrom(TS.tabsBackup.item(i), TS.tabsBackup);
			TS.tabsBackup.clearData();
			TS.tabsBackupRoot.removeData(TS.tabsBackup.containerNode);
			TS.tabsBackup = null;
		}
	}
};
 
var gTSCloseBoxPrefListener = 
{
	domains : [
		'browser.tabs.extensions.show_closebox',
		'browser.tabs.extensions.show_closebox_always'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var shouldShow       = TabbrowserService.getPref('browser.tabs.extensions.show_closebox');
		var shouldShowAlways = TabbrowserService.getPref('browser.tabs.extensions.show_closebox_always');
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].mTabs.length; j++)
				b[i].mTabs[j].setAttribute('showclosebox', shouldShow && shouldShowAlways);
	}
};
 
var gTSLastTabClosingPrefListener = 
{
	domain  : 'browser.tabs.extensions.last_tab_closing',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (TabbrowserService.getPref('browser.tabs.extensions.last_tab_closing') != 2) {
			TabbrowserService.setPref('browser.tabs.autoHide', false);
			TabbrowserService.setPref('browser.tabs.forceHide', false);
		}

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		if (TabbrowserService.getPref('browser.tabs.autoHide')) {
			for (var i = 0; i < b.length; i++)
				b[i].setStripVisibilityTo(false);
		}
		else {
			for (var i = 0; i < b.length; i++)
				b[i].setStripVisibilityTo(true);
		}
	}
};
 
var gTSTabsAutoHidePrefListener = 
{
	domain  : 'browser.tabs.autoHide',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			!TabbrowserService.getPref('browser.tabs.autoHide'))
			return;

		// disable the feature automatically
		TabbrowserService.setPref('browser.tabs.extensions.last_tab_closing', 2);

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		for (var i = 0; i < b.length; i++)
			b[i].setStripVisibilityTo(b[i].mTabs.length > 1);
	}
};
 
var gTSIconOverlayInTabsPrefListener = 
{
	domain  : 'browser.tabs.extensions.overlay_icon',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var shouldOverlay = TabbrowserService.getPref('browser.tabs.extensions.overlay_icon');
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].mTabs.length; j++)
				b[i].mTabs[j].setAttribute('overlay-icon', shouldOverlay);
	}
};
 
var gTSShowTabbarInBottomPrefListener = 
{
	domain  : 'browser.tabs.extensions.show_tabs_in_bottom.enable',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		var showBottom = TabbrowserService.getPref('browser.tabs.extensions.show_tabs_in_bottom.enable');
		if (showBottom == !b[0].mStrip.getAttribute('class').match(/tabbrowser-strip-bottom/))
			for (var i = 0; i < b.length; i++)
				b[i].updateTabbarPlace();
	}
};
 
var gTWindowModePrefListener = 
{
	domains : [
		'browser.tabs.extensions.window_hook_mode',
		'advanced.system.supportDDEExec',
		'browser.tabs.opentabfor.native_apps'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;


		if (TS.getPref('browser.tabs.extensions.autoConfigDDESupport')) {
			// Enable/disable DDE notification automatically.
			var openTab = TS.getPref('browser.tabs.opentabfor.native_apps') || (TS.getPref('browser.tabs.extensions.window_hook_mode') != 0);
			if (TS.getPref('advanced.system.supportDDEExec') == openTab)
				TS.setPref('advanced.system.supportDDEExec', !openTab);
		}

		if (aPrefName == 'advanced.system.supportDDEExec' ||
			aPrefName == 'browser.tabs.opentabfor.native_apps')
			return;


		if (!TS.winHookMode &&
			!TS.opentabforJS &&
			TS.openerType == 'ContentWindow')
			TS.openerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.

		if (window.location.href != TS.browserURI) return;

		var i;
		var isSingleWindow = TS.winHookMode == 2 ? true : false ;

		var items = [
				document.getElementById('menu_newNavigator'),
				document.getElementsByAttribute('oncommand', 'gContextMenu.openFrame();')[0],
				document.getElementById('cmd_newNavigator')
			];

		// Phoenix/Firebird or Mozilla 1.5 or later
		if (TS.isNewTypeBrowser) {
			var nodes = document.getElementsByAttribute('command', 'cmd_newNavigator');
			for (i = 0; i < nodes.length; i++)
				if (nodes[i].localName == 'menuitem')
					items.push(nodes[i]);
		}

		for (i in items)
			if (items[i]) {
				items[i].setAttribute('hidden', isSingleWindow);
				items[i].setAttribute('disabled', isSingleWindow);
			}
	}
};
 
var gTSOpenTabForWindowOpenPrefListener = 
{
	domain  : 'browser.tabs.opentabfor.windowopen',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		if (!TabbrowserService.winHookMode &&
			!TabbrowserService.opentabforJS &&
			TabbrowserService.openerType == 'ContentWindow')
			TabbrowserService.openerType = 'PlatformNative'; // reset opener type to use this window for reopen new windows opened from webpages in this window.
	}
};
 
// ^u̐eq֌W𖕏 
// clear the relation of tabs when the TabGroup Mode is disabled
var gTSGroupModePrefListener =
{
	domain  : 'browser.tabs.extensions.group.enabled',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed' ||
			TabbrowserService.getPref('browser.tabs.extensions.group.enabled')) return;

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
			for (j = 0; j < b[i].mTabs.length; j++)
			{
				b[i].mTabs[j].parentTab = null;
				b[i].mTabs[j].childTabs = [];
				b[i].mTabs[j].mTabInfo.openedAutomatically = false;
				b[i].mTabs[j].mTabInfo.groupHost = null;
			}
	}
};
 
var gTSTabsWidthPrefListener = 
{
	domains : [
		'browser.tabs.extensions.tabs_width_type',
		'browser.tabs.extensions.tabs_width',
		'browser.tabs.extensions.tabs_min_width',
		'browser.tabs.extensions.tabs_max_width',
		'browser.tabs.extensions.tabs_title_crop'
	],
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser'),
			i, j;
		for (i = 0; i < b.length; i++)
		{
			for (j = 0; j < b[i].mTabs.length; j++)
				b[i].mTabs[j].initTab();

			b[i].onTabsModified();
		}
	}
};
 
var gTSTabScrollbarPrefListener = 
{
	domain  : 'browser.tabs.extensions.show_scrollbar',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var toShow = TabbrowserService.getPref('browser.tabs.extensions.show_scrollbar');
		var b = document.getElementsByTagNameNS(TabbrowserService.XULNS, 'tabbrowser');
		for (var i = 0; i < b.length; i++)
			if (toShow)
				b[i].setAttribute('tab-scrollbar', true);
			else
				b[i].removeAttribute('tab-scrollbar');
	}
};
 
var gTSObserveClipboardPrefListener = 
{
	domain  : 'browser.tabs.extensions.observe.clipboard.enabled',
	observe : function(aSubject, aTopic, aPrefName)
	{
		if (aTopic != 'nsPref:changed') return;

		var TS = TabbrowserService;
		if (TS.getPref('browser.tabs.extensions.observe.clipboard.enabled')) {
			if (TS.observeClipboardTimer) return;

			var interval = TS.getPref('browser.tabs.extensions.observe.clipboard.interval');
			if (interval < 1) interval = 1;
			TS.observeClipboardTimer = window.setInterval(TS.observeClipboard, interval);
		}
		else if (TS.observeClipboardTimer) {
			window.clearInterval(TS.observeClipboardTimer);
			TS.observeClipboardTimer = null;
		}
	}
};
  
var gTSToolbarItemsInsertedEventListener = function(aEvent, aId) 
{
	if (!aEvent && !aId) return;

	var node = aId ? document.getElementById(aId) : aEvent.targetItem ;
	if (!node) return;

	switch (node.id)
	{
		case 'back-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

		case 'forward-button':
			node.setAttribute('onclick', 'if (event.target != this) gotoHistoryIndex(event); event.preventBubble();');
			break;

/*
		case 'urlbar-container':
			node = node.firstChild;
			node.setAttribute('ontextentered', 'return TabbrowserService.handleURLBarCommand(param);');
			break;
*/

		default:
			break;
	}
};
 
var gTSBookmarksObserver = 
{
	// save status
	onAssert: function (aDS, aSource, aProperty, aTarget)
	{
		var uri = aTarget.Value;
		if (aDS.URI != 'rdf:bookmarks' || !uri) return;

		var TS = TabbrowserService;
		var b  = TS.browsers;

		var i, j;
		for (i = 0; i < b.length; i++)
			for (j in b[i].mTabs)
				if (b[i].mTabs[j].mBrowser.currentURI.spec == uri) {
					if (b[i].mTabs[j].getAttribute('tab-locked'))
						TS.saveBookmarkStatus(b[i], b[i].mTabs[j], 'locked');
					if (b[i].mTabs[j].getAttribute('tab-autoreload'))
						TS.saveBookmarkStatus(b[i], b[i].mTabs[j], 'autoreload');
				}
	},

	// clear stored status
	onUnassert: function (aDS, aSource, aProperty, aTarget)
	{
		if (aDS.URI != 'rdf:bookmarks' ||
			!aSource.Value.match(/^NC:(BookmarksRoot|IEFavoritesRoot|SystemBookmarksStaticRoot|NewBookmarkFolder|PersonalToolbarFolder|NewSearchFolder)/) ||
			!aTarget.Value) return;

		var data = TabbrowserService.bookmarksData;

		data.removeData(data.getResource(aTarget.Value));

		// remove entry from icon data
		var dir = aDS.URI.split('#')[0].split('?')[0].replace(/[^\/]+$/, '').replace(/\/$/, '')+'/';
		TabbrowserService.iconData.removeData(dir);
	},

	onChange: function (aDS, aSource, aProperty, aOldTarget, aNewTarget) {},
	onMove: function (aDS, aOldSource, aNewSource, aProperty, aTarget) {},
	beginUpdateBatch: function (aDS) {},
	endUpdateBatch: function (aDS) {}
};
 
// to catch and cancel window.open() 
/*
var gTSDomWindowOpenObserver =
{
	observe : function (aSubject, aTopic, aData)
	{
		dump('tabextensions : on'+aTopic+'\n');
		if (aTopic != 'domwindowopened') {
			return;
		}

		window.setTimeout(this.callBackFunc, 0, aSubject, this);
	},
	callBackFunc : function(aSubject, aThis)
	{
		var TS = TabbrowserService;

		if (!aSubject.location.href) {
			window.setTimeout(aThis.callBackFunc, 0, aSubject, aThis);
			return;
		}
		else if (aSubject.location.href != TS.browserURI) { // this is not browser
			return;
		}

		var openerType = (aSubject.opener) ? 'XULWindow' :
						(
							!('arguments' in aSubject) &&
							!('__tabextensions__opener' in aSubject) &&
							(
								TS.winHookMode ||
								TS.opentabforJS
							)
						) ? 'ContentWindow' :
						'PlatformNative' ;

		var w = aSubject.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
				.getInterface(Components.interfaces.nsIWebNavigation)
				.QueryInterface(Components.interfaces.nsIDocShellTreeItem)
				.treeOwner
				.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
				.getInterface(Components.interfaces.nsIXULWindow)
				.QueryInterface(Components.interfaces.nsIBaseWindow);

		if (
			(TS.winHookMode == 1 && openerType == 'PlatformNative') ||
			(TS.winHookMode == 2 && openerType != 'ContentWindow')
			) {
			w.visibility = false;
			w.enabled = false;
		}
		else if (
			openerType == 'ContentWindow' &&
			(TS.winHookMode || TS.opentabforJS)
			) {
			w.visibility = false;
			w.enabled = false;
		}
	}
};
*/
 
// observe modifying in other window 
var gTSStoredTabSetsListener =
{
	observe : function (aSubject, aTopic, aData)
	{
		if (aTopic != 'tabextensions:storedTabSetsModified' ||
			aSubject == window) return;

		TabbrowserService.storedTabSetsRoot = null;
		var nullPointer = TabbrowserService.storedTabSetsRoot;
		window.setTimeout(
			function()
			{
				TabbrowserService.initStoredTabSets();
			},
			0
		);
	}
};
  
var TabbrowserServiceTabbarDNDObserver = 
{
	// ^uo[̃hbv
	onDrop : function(aEvent, aTransferData, aSession)
	{
		if (aTransferData.flavour.contentType != 'tabbrowser/tabbar' ||
			navigator.platform.indexOf('Linux') > -1) {
			return;
		}

		var TS = TabbrowserService;
		if (aEvent.originalTarget.ownerDocument.defaultView.top.document != TS.browser.contentDocument) {
			TS.browser.removeAttribute('tabbar-moving');
			return;
		}

		var inBottom = TS.getPref('browser.tabs.extensions.show_tabs_in_bottom.enable');
		var hidden  = TS.getPref('browser.tabs.extensions.show_tabs_in_bottom.confirm_hidden');

		var check = { value: hidden };
		if (!check.value) {
			var result = TS.PromptService.confirmEx(
					window,
					TS.strbundle.GetStringFromName('message_movetabbar_title'),
					TS.strbundle.GetStringFromName(inBottom ? 'message_movetabbar_text_toTop' : 'message_movetabbar_text_toBottom' ),
					(TS.PromptService.BUTTON_TITLE_OK * TS.PromptService.BUTTON_POS_0) +
					(TS.PromptService.BUTTON_TITLE_CANCEL * TS.PromptService.BUTTON_POS_1),
					null,
					null,
					null,
					TS.strbundle.GetStringFromName('message_never_show_dialog'),
					check
				);

			if (check.value) {
				TS.setPref('browser.tabs.extensions.show_tabs_in_bottom.confirm_hidden', true);
				if (result != 0)
					TS.setPref('browser.tabs.extensions.show_tabs_in_bottom.onDrag', false);
			}

			TS.browser.removeAttribute('tabbar-moving');

			if (result != 0) return;
		}

		TS.setPref('browser.tabs.extensions.show_tabs_in_bottom.enable', !inBottom);

		TS.browser.removeAttribute('tabbar-moving');
	},

	onDragOver : function(aEvent, aFlavour, aSession)
	{
		if (aEvent.originalTarget.ownerDocument.defaultView.top.document != TabbrowserService.browser.contentDocument)
			aSession.canDrop = false;
	},

	getSupportedFlavours : function ()
	{
		var flavours = new FlavourSet();
		flavours.appendFlavour('tabbrowser/tabbar');
		return flavours;
	}
};
 
// EBhEJɊEBhEŃ^uJ 
// open a tab in existing window instead of myself
if (window == window.top && // do no action when this is a sidebar panel, etc.
	!TabbrowserService.openerType &&
	TabbrowserService.isBrowserWindow &&
	TabbrowserService.browserWindows.length > 1) {
	if (window.opener)
		TabbrowserService.openerType = 'XULWindow';
	else if (
		!('arguments' in window) &&
		!('__tabextensions__opener' in window) &&
		(
			TabbrowserService.winHookMode ||
			TabbrowserService.opentabforJS
		)
		)
		TabbrowserService.openerType = 'ContentWindow';
	else
		TabbrowserService.openerType = 'PlatformNative';

	// EBhȆɃ^uŊJ
	if (
		(
			TabbrowserService.openerType == 'PlatformNative' &&
			(TabbrowserService.winHookMode == 1 || TabbrowserService.opentabforPlatformNative)
		) ||
		(TabbrowserService.winHookMode == 2 && TabbrowserService.openerType != 'ContentWindow')
		) {
		// if the page is the startup page, this window maybe opened from the shell program.
		if (
			!TabbrowserService.getPref('browser.tabs.extensions.sameness_shell_as_a_program') ||
			!('arguments' in window) ||
			window.arguments.length != 1 ||
			!(
				(
					(TabbrowserService.getPref('browser.windows.loadOnNewWindow') === null ? TabbrowserService.getPref('browser.startup.page') : TabbrowserService.getPref('browser.windows.loadOnNewWindow') ) == 0 &&
					window.arguments[0] == 'about:blank'
				) ||
				(
					(TabbrowserService.getPref('browser.windows.loadOnNewWindow') === null ? TabbrowserService.getPref('browser.startup.page') : TabbrowserService.getPref('browser.windows.loadOnNewWindow') ) == 1 &&
					window.arguments[0] == getHomePage()[0]
				) ||
				(
					(TabbrowserService.getPref('browser.windows.loadOnNewWindow') === null ? TabbrowserService.getPref('browser.startup.page') : TabbrowserService.getPref('browser.windows.loadOnNewWindow') ) == 2 &&
					window.arguments[0] == TabbrowserService.GlobalHistory.QueryInterface(Components.interfaces.nsIBrowserHistory).lastPageVisited
				)
			)
			)
			TabbrowserService.openTabInsteadSelf();
	}
	else if ( // window.open̎sɐɎsꍇ̃tFCZ[t
		TabbrowserService.openerType == 'ContentWindow' &&
		(
			TabbrowserService.winHookMode ||
			TabbrowserService.opentabforJS
		)
		) {
//		dump('TABEXTENSIONS: opened by "target" links or JavaScript in webpages\n');
		TabbrowserService.browser.replaceReadStreamToData  = true;
		TabbrowserService.openTabTimer = window.setInterval('TabbrowserService.openTabInsteadSelf();', 100);
	}
}
 
// end of definition 
}
 
//  
// initialize
if (TabbrowserService.isNewTypeBrowser) {
	// Phoenix/Firebird or Mozilla 1.5 or later cannot add event listener in "TabbrowserService.init()", so do it in this point.
	window.addEventListener('close', function(aEvent)
	{
		TabbrowserService.onWindowClose(aEvent);
	},
	false);
}

if ('Shutdown' in window && !('__tabextensions__Shutdown' in window)) {
	window.__tabextensions__Shutdown = window.Shutdown;
	window.Shutdown = TabbrowserService.Shutdown;
}

window.addEventListener('unload', function()
{
	if (!TabbrowserService.initialized ||
		TabbrowserService.destructed) return;

	TabbrowserService.destruct();
},
false);
window.addEventListener('unload', function()
{
	if (!TabbrowserService.initialized ||
		TabbrowserService.destructed) return;

	TabbrowserService.destruct();
},
false);

window.addEventListener('load', function()
{
	if (TabbrowserService.initialized) return;

	TabbrowserService.init();
},
false);
window.addEventListener('load', function()
{
	if (TabbrowserService.initialized) return;

	TabbrowserService.init();
},
false);
 
