/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Tabbrowser Extensions.
 *
 * The Initial Developer of the Original Code is SHIMODA Hiroshi.
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): SHIMODA Hiroshi <piro@p.club.ne.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gBookmarkID;
var gBookmarkURI;
var gBookmarkResource;
var gBookmarkURIResource;
var gInfo = {};

function init(aPanelID)
{
	var TS = TabbrowserService;
	var panel = getPanel(aPanelID);

	switch(aPanelID)
	{
		case 'Status':

			initCheckbox('Locked', 'locked' in gInfo && gInfo.locked, aPanelID);
			initCheckbox('ReferrerBlocked', 'referrerBlocked' in gInfo && gInfo.referrerBlocked, aPanelID);
			initCheckbox('AutoReload', 'autoreloadInterval' in gInfo && gInfo.autoreloadInterval ? true : false, aPanelID);

			panel.document.getElementById('AutoReloadInterval').value = Number(TS.bookmarksData.getData(gBookmarkResource, 'AutoReloadInterval'))/1000 || '0' ;

			initCheckbox('AllowPlugins', !('allowPlugins' in gInfo) || gInfo.allowPlugins, aPanelID);
			initCheckbox('AllowJavascript', !('allowJavascript' in gInfo) || gInfo.allowJavascript, aPanelID);
			initCheckbox('AllowMetaRedirects', !('allowMetaRedirects' in gInfo) || gInfo.allowMetaRedirects, aPanelID);
			initCheckbox('AllowSubframes', !('allowSubframes' in gInfo) || gInfo.allowSubframes, aPanelID);
			initCheckbox('AllowImages', !('allowImages' in gInfo) || gInfo.allowImages, aPanelID);


			if (!TS.shouldSaveBookmarksStatus)
				showHideItem('status-groupbox', aPanelID, false);

			if (!TS.shouldSaveBookmarksStatus ||
				!TS.shouldSaveBookmarksPermissions)
				showHideItem('allow-groupbox', aPanelID, false);

			if (!TS.shouldSaveBookmarksStatus &&
				!TS.shouldSaveBookmarksPermissions) {
				showHideItem('description-disabled', aPanelID, true);
			}

			panelControlLinkedItems(panel.document.getElementById('AutoReload'), panel);
			break;

		case 'Extra':
			panel.document.getElementById('IconURI').value = getIcon();
			panel.document.getElementById('ReferrerURI').value = TS.bookmarksData.getData(gBookmarkResource, 'ReferrerURI') || '' ;
			break;

		default:
			break;
	}
}

function initCheckbox(aID, aFlag, aPanelID)
{
	var w = (aPanelID) ? getPanel(aPanelID) : window ;
	var node = w.document.getElementById(aID);
	if (node) node.checked = Boolean(aFlag);
}

function showHideItem(aID, aPanelID, aFlag)
{
	var w = (aPanelID) ? getPanel(aPanelID) : window ;
	var node = w.document.getElementById(aID);
	if (node) node.hidden = !aFlag;
}

function getPanel(aID)
{
	return document.getElementById('tabpanel'+aID).firstChild.contentDocument.defaultView; // contentWindow is not defined in Mozilla 1.0.x
}

function saveValue(aIDAndKey, aOldValue, aType, aPanelID)
{
	var w = (aPanelID) ? getPanel(aPanelID) : window ;
	var node = w.document.getElementById(aIDAndKey);

	if (!node) return null;

	if (node.localName == 'checkbox') {
		if (aIDAndKey.match(/^Allow/))
			aIDAndKey = aIDAndKey.replace(/^Allow/, 'Forbid');
		if (
			aIDAndKey != 'AllowSubframes' ||
			TabbrowserService.getPref('browser.frames.enabled')
			)
			TabbrowserService.bookmarksData.setData(gBookmarkResource, aIDAndKey, (aIDAndKey.match(/^Forbid/) ? !node.checked : node.checked ) || void(0));
		else // for subframes
			TabbrowserService.bookmarksData.setData(gBookmarkResource, aIDAndKey, node.checked ? false : void(0));

		return aIDAndKey.match(/^Forbid/) ? !node.checked : node.checked ;
	}
	else if (node.localName == 'textbox') {
		if (aType) {
			if (aType == Number && isNaN(aType(node.value))) return null;
			if (aType == Components.interfaces.nsIURI) {
				try {
					var testURI = TabbrowserService.makeURIFromSpec(node.value);
				}
				catch(e) {
					return null;
				}
			}
		}

		var value = node.value;
		if (aIDAndKey == 'AutoReloadInterval')
			value = Number(value)*1000;

		if (aIDAndKey == 'IconURI')
			TabbrowserService.iconData.setData(gBookmarkURI, aIDAndKey, value || void(0));
		else
			TabbrowserService.bookmarksData.setData(gBookmarkResource, aIDAndKey, value || void(0));

		return value;
	}
	return null;
}



function getIcon()
{
//	return TabbrowserService.getIconForBookmark(gBookmarkURI == gBookmarkID ? gBookmarkURI : gBookmarkID );
	return TabbrowserService.getIconForBookmark(gBookmarkURI);
}

function setIcon()
{
//	TabbrowserService.setIconForBookmark(gBookmarkURI == gBookmarkID ? gBookmarkURI : gBookmarkID );
	TabbrowserService.setIconForBookmark(gBookmarkURI);
}



function panelControlLinkedItems(elem, aWindow)
{
	var target = elem.getAttribute('linked').split(/ +/);
	var item;

	var disabled = (elem.localName == 'textbox' ? (!elem.value || !Number(elem.value)) : !elem.checked );

	for (var i in target)
	{
		item = aWindow.document.getElementById(target[i]);
		item.disabled = disabled;
	}
}


function newCommit()
{
	var info = { uri : gBookmarkURI },
		val,
		TS   = TabbrowserService;

	if (saveValue('UseFixedLabel'))
		info.useFixedLabel = true;

	if (saveValue('Locked',              null, null, 'Status'))
		info.locked = true;
	if (saveValue('AutoReload',          null, null, 'Status'))
		info.autoreload = true;
	val = saveValue('AutoReloadInterval',  null, Number, 'Status');
	if (val) info.autoreloadInterval = val;
	if (saveValue('ReferrerBlocked',     null, null, 'Status'))
		info.referrerBlocked = true;
	if (saveValue('AllowPlugins',       null, null, 'Status'))
		info.allowPlugins = false;
	if (saveValue('AllowJavascript',    null, null, 'Status'))
		info.allowJavascript = false;
	if (saveValue('AllowMetaRedirects', null, null, 'Status'))
		info.allowMetaRedirects = false;
	if (saveValue('AllowSubframes',     null, null, 'Status'))
		info.allowSubframes = false;
	if (saveValue('AllowImages',        null, null, 'Status'))
		info.allowImages = false;


	if (getIcon() != getPanel('Extra').document.getElementById('IconURI').value) {
		saveValue('IconURI', getIcon(), Components.interfaces.nsIURI, 'Extra');
		setIcon();
	}
	saveValue('ReferrerURI', null, Components.interfaces.nsIURI, 'Extra');


	var data = TS.bookmarksData;
	if (!data.dsource.ArcLabelsOut(gBookmarkResource).hasMoreElements())
		data.container.RemoveElement(gBookmarkResource, true);


	var retVal = __tabextensions__Commit();


	var w = TS.browserWindows;
	var b;

	var i, j;
	var name = ('useFixedLabel' in info && info.useFixedLabel) ? TS.getNameForBookmark(gBookmarkID) : null ;
	for (i in w)
	{
		b = w[i].TabbrowserService.browser;
		for (j in b.mTabs)
			if (b.mTabs[j].mTabInfo.bookmarkID == gBookmarkID) {
				b.initTabWithTabInfo(b.mTabs[j], info);
				if (name) b.setFixedLabelFor(b.mTabs[j], name, gBookmarkURI);
			}
	}

	return retVal;
}


window.addEventListener(
	'load',
	function()
	{
		var i;
		var TS = TabbrowserService;
		gBookmarkID = window.arguments[0];

		gBookmarkResource = TS.RDF.GetResource(gBookmarkID);

//		gBookmarkURI = TS.bookmarksData.getData(gBookmarkResource, 'URL') ?  gBookmarkID : TS.BookmarksDS.GetTarget(gBookmarkResource, TS.kNC_URL, true).Value ;
		gBookmarkURI = TS.BookmarksDS.GetTarget(gBookmarkResource, TS.kNC_URL, true);
		gBookmarkURI = gBookmarkURI ? gBookmarkURI.Value : null ;
		gBookmarkURIResource = gBookmarkURI ? TS.RDF.GetResource(gBookmarkURI) : null ;

		// don't initialize if this is a folder or a bookmarklet
		if (TS.isBookmarkFolder(gBookmarkResource) ||
			!gBookmarkURI ||
			gBookmarkURI.match(/^javascript:/i)) return;


		TS.readBookmarkStatusToTabInfo(gBookmarkID, gInfo);

		window.__tabextensions__Commit = window.Commit;
		window.Commit = window.newCommit;


		var tabbox = document.getElementsByTagName('tabbox')[0];

		if (!TS.getPref('browser.tabs.extensions.bookmarks.use_fixed_label')) {
			var row = document.createElement('row');
			row.appendChild(document.createElement('spacer'));
			row.appendChild(document.createElement('checkbox'));
			row.lastChild.setAttribute('id', 'UseFixedLabel');
			row.lastChild.setAttribute('label', TS.strbundle.GetStringFromName('bookmarksProperty_useFixedLabel'));
			var ref = tabbox.getElementsByTagName('row')[1];
			ref.parentNode.insertBefore(row, ref);

			var seps = ref.parentNode.parentNode.parentNode.parentNode.getElementsByTagName('separator');
			for (i = seps.length-1; i > -1; i--)
				seps[i].parentNode.removeChild(seps[i]);
//			ref.parentNode.parentNode.parentNode.setAttribute('style', 'padding-top: 0 !important; padding-bottom: 0 !important; margin-top: 0 !important; margin-bottom: 0 !important;');

			initCheckbox('UseFixedLabel', 'useFixedLabel' in gInfo && gInfo.useFixedLabel);
		}

		var tabs = ['Status', 'Extra'],
			tab,
			panel;
		for (i in tabs) {

			tab = tabbox.firstChild.appendChild(document.createElement('tab'));
			tab.setAttribute('label', TS.strbundle.GetStringFromName('bookmarksProperty_tab'+tabs[i]+'Label'));
			tab.setAttribute('accesskey', TS.strbundle.GetStringFromName('bookmarksProperty_tab'+tabs[i]+'Accesskey'));
			tab.setAttribute('id', 'tab'+tabs[i]);

			panel = tabbox.lastChild.appendChild(document.createElement('tabpanel'));
			panel.setAttribute('flex', 1);

			panel.appendChild(document.createElement('iframe'));
			panel.setAttribute('id', 'tabpanel'+tabs[i]);
			panel.setAttribute('style', 'min-height:12em !important;');

			panel.lastChild.setAttribute('flex', 1);
			panel.lastChild.setAttribute('src', 'chrome://tabextensions/content/bookmarks/bookmarksProperty'+tabs[i]+'.xul');
		}

	},
	false
);
